/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.legacyapi;

import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Tags;
import io.smallrye.metrics.legacyapi.AnnotatedGaugeAdapter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import org.eclipse.microprofile.metrics.MetricID;
import org.eclipse.microprofile.metrics.annotation.Metric;

class MetricDescriptor {
    final String name;
    final Tags tags;
    ExtendedMetricID metricId = null;

    MetricDescriptor(String name, Tags tags) {
        this.name = name;
        this.tags = tags;
    }

    MetricDescriptor(String name, String ... tags) {
        this.name = name;
        this.tags = Tags.of((String[])tags);
    }

    public MetricDescriptor(Metric annotation) {
        this.name = annotation.name();
        this.tags = Tags.of((String[])annotation.tags());
    }

    public MetricDescriptor(AnnotatedGaugeAdapter adapter) {
        this.name = adapter.name();
        this.tags = Tags.of((String[])adapter.tags());
    }

    public String name() {
        return this.name;
    }

    public Tags tags() {
        return this.tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MetricDescriptor that = (MetricDescriptor)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.tags, that.tags);
    }

    public int hashCode() {
        int result = Objects.hash(this.name);
        result = 31 * result + this.tags.hashCode();
        return result;
    }

    org.eclipse.microprofile.metrics.Tag[] convertTags() {
        ArrayList mpTags = new ArrayList();
        this.tags.stream().forEach(x -> mpTags.add(new org.eclipse.microprofile.metrics.Tag(x.getKey(), x.getValue())));
        return mpTags.toArray(new org.eclipse.microprofile.metrics.Tag[0]);
    }

    public String toString() {
        return this.name + Arrays.asList(this.tags);
    }

    public boolean isTagNamesMatch(Tags otherTags) {
        if (this.tags.equals((Object)otherTags)) {
            return true;
        }
        HashSet tagNameSet = new HashSet();
        HashSet otherTagNameSet = new HashSet();
        this.tags.stream().forEach(tag -> tagNameSet.add(tag.getKey()));
        otherTags.stream().forEach(tag -> otherTagNameSet.add(tag.getKey()));
        if (tagNameSet.size() != otherTagNameSet.size()) {
            return false;
        }
        tagNameSet.stream().forEach(name -> {
            if (otherTagNameSet.contains(name)) {
                otherTagNameSet.remove(name);
            }
        });
        return otherTagNameSet.size() == 0;
    }

    public MetricDescriptor(MetricID metricID) {
        this.name = metricID.getName();
        this.tags = this.extractTags(metricID.getTagsAsList());
        this.metricId = MetricDescriptor.sanitizeMetricID(metricID, this);
    }

    private Tags extractTags(List<org.eclipse.microprofile.metrics.Tag> tagsAsList) {
        ArrayList<Tag> list = new ArrayList<Tag>();
        for (org.eclipse.microprofile.metrics.Tag t : tagsAsList) {
            list.add(Tag.of((String)t.getTagName(), (String)t.getTagValue()));
        }
        return Tags.of(list);
    }

    public MetricID toMetricID() {
        ExtendedMetricID result = this.metricId;
        if (result == null) {
            result = this.metricId = new ExtendedMetricID(this);
        }
        return result;
    }

    public static ExtendedMetricID sanitizeMetricID(MetricID metricID, MetricDescriptor metricDescriptor) {
        if (metricID instanceof ExtendedMetricID) {
            return (ExtendedMetricID)metricID;
        }
        return new ExtendedMetricID(metricDescriptor);
    }

    static class ExtendedMetricID
    extends MetricID {
        final MetricDescriptor source;

        public ExtendedMetricID(MetricDescriptor source) {
            super(source.name(), source.convertTags());
            this.source = source;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ExtendedMetricID that = (ExtendedMetricID)((Object)o);
            return this.source.equals(that.source);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.source);
        }
    }
}

