/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.profile.action;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.Prototype;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.profile.action.ProfileAction;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.MetricContext;
import org.opensaml.profile.context.PreviousEventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.LoggerFactory;

@Prototype
public abstract class AbstractProfileAction
extends AbstractInitializableComponent
implements ProfileAction {
    @Nullable
    private String logPrefix;
    @Nullable
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;
    @Nullable
    private NonnullSupplier<HttpServletResponse> httpServletResponseSupplier;
    private boolean preExecuted;

    @Nullable
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier != null) {
            return (HttpServletRequest)this.httpServletRequestSupplier.get();
        }
        return null;
    }

    @Nonnull
    public HttpServletRequest ensureHttpServletRequest() {
        HttpServletRequest ret = this.getHttpServletRequest();
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("HttpServletRequest was absent");
    }

    @Nullable
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = requestSupplier;
    }

    @Nullable
    public HttpServletResponse getHttpServletResponse() {
        if (this.httpServletResponseSupplier != null) {
            return (HttpServletResponse)this.httpServletResponseSupplier.get();
        }
        return null;
    }

    @Nonnull
    public HttpServletResponse ensureHttpServletResponse() {
        HttpServletResponse ret = this.getHttpServletResponse();
        if (ret != null) {
            return ret;
        }
        throw new IllegalStateException("HttpServletResponse was absent");
    }

    @Nullable
    public NonnullSupplier<HttpServletResponse> getHttpServletResponseSupplier() {
        return this.httpServletResponseSupplier;
    }

    public void setHttpServletResponseSupplier(@Nullable NonnullSupplier<HttpServletResponse> supplier) {
        this.checkSetterPreconditions();
        this.httpServletResponseSupplier = supplier;
    }

    @Override
    public void execute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.checkComponentActive();
        EventContext previousEvent = (EventContext)profileRequestContext.getSubcontext(EventContext.class);
        if (previousEvent != null) {
            ((PreviousEventContext)profileRequestContext.ensureSubcontext(PreviousEventContext.class)).setEvent(previousEvent.getEvent());
            profileRequestContext.removeSubcontext(EventContext.class);
        }
        if (this.doPreExecute(profileRequestContext)) {
            this.preExecuted = true;
            try {
                this.doExecute(profileRequestContext);
            }
            catch (Throwable t) {
                try {
                    if (t instanceof Exception) {
                        this.doPostExecute(profileRequestContext, (Exception)t);
                    } else {
                        this.doPostExecute(profileRequestContext);
                    }
                }
                catch (Throwable t2) {
                    LoggerFactory.getLogger(AbstractProfileAction.class).warn(this.getLogPrefix() + " Unchecked exception/error thrown by doPostInvoke, superseding earlier exception/error ", t);
                    t2.addSuppressed(t);
                    throw t2;
                }
                throw t;
            }
            this.doPostExecute(profileRequestContext);
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricContext metricCtx = (MetricContext)profileRequestContext.getSubcontext(MetricContext.class);
        if (metricCtx != null) {
            String name = this.getClass().getSimpleName();
            assert (name != null);
            metricCtx.start(name);
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
    }

    protected void doPostExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MetricContext metricCtx = (MetricContext)profileRequestContext.getSubcontext(MetricContext.class);
        if (metricCtx != null) {
            String name = this.getClass().getSimpleName();
            assert (name != null);
            metricCtx.stop(name);
            metricCtx.inc(name);
        }
    }

    protected void doPostExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull Exception e) {
        this.doPostExecute(profileRequestContext);
    }

    protected boolean isPreExecuteCalled() {
        return this.preExecuted;
    }

    @Nonnull
    @NotEmpty
    protected String getLogPrefix() {
        if (this.logPrefix == null) {
            this.logPrefix = "Profile Action " + this.getClass().getSimpleName() + ":";
        }
        assert (this.logPrefix != null);
        return this.logPrefix;
    }
}

