/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.task;

import jakarta.enterprise.concurrent.ManagedExecutorService;
import jakarta.enterprise.concurrent.ManagedTask;
import jakarta.enterprise.concurrent.ManagedTaskListener;
import java.io.Serializable;
import java.util.concurrent.Future;

public abstract class ManagedTaskListenerTask
implements ManagedTaskListener,
Serializable {
    private final ManagedTaskListener listener;
    protected Future<?> future;
    protected final Object delegate;
    protected transient ManagedExecutorService executor;

    protected ManagedTaskListenerTask(Object task) {
        this.listener = ManagedTask.class.isInstance(task) ? ((ManagedTask)ManagedTask.class.cast(task)).getManagedTaskListener() : NoopManagedTaskListener.INSTANCE;
        this.delegate = task;
    }

    public void taskSubmitted(Future<?> future, ManagedExecutorService executor, Object task) {
        this.future = future;
        this.executor = executor;
        if (this.listener != null) {
            this.listener.taskSubmitted(future, executor, task);
        }
    }

    public void taskAborted(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        if (this.listener != null) {
            this.listener.taskAborted(this.future, this.executor, this.delegate, exception);
        }
    }

    public void taskDone(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        if (this.listener != null) {
            this.listener.taskDone(future, executor, task, exception);
        }
    }

    public void taskStarting(Future<?> future, ManagedExecutorService executor, Object task) {
        if (this.listener != null) {
            this.listener.taskStarting(future, executor, task);
        }
    }

    public void taskAborted(Throwable skippedException) {
        this.taskAborted(this.future, this.executor, this.delegate, skippedException);
    }

    public Object getDelegate() {
        return this.delegate;
    }

    private static class NoopManagedTaskListener
    implements ManagedTaskListener,
    Serializable {
        private static final NoopManagedTaskListener INSTANCE = new NoopManagedTaskListener();

        private NoopManagedTaskListener() {
        }

        public void taskSubmitted(Future<?> future, ManagedExecutorService executor, Object task) {
        }

        public void taskAborted(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        }

        public void taskDone(Future<?> future, ManagedExecutorService executor, Object task, Throwable exception) {
        }

        public void taskStarting(Future<?> future, ManagedExecutorService executor, Object task) {
        }
    }
}

