/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security.jaas;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;

public class UsernamePasswordCallbackHandler
implements CallbackHandler {
    private final String username;
    private final String password;

    public UsernamePasswordCallbackHandler(String username, String password) {
        this.username = username;
        this.password = password;
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof PasswordCallback) {
                PasswordCallback passwordCallback = (PasswordCallback)callback;
                if (this.password == null) {
                    passwordCallback.setPassword(null);
                    continue;
                }
                passwordCallback.setPassword(this.password.toCharArray());
                continue;
            }
            if (!(callback instanceof NameCallback)) continue;
            NameCallback nameCallback = (NameCallback)callback;
            if (this.username == null) {
                nameCallback.setName(null);
                continue;
            }
            nameCallback.setName(this.username);
        }
    }
}

