/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.util.Collection;
import java.util.TreeSet;
import javax.naming.LinkRef;
import javax.naming.NamingException;
import org.apache.openejb.core.ThreadContext;

public class ContextValue
extends LinkRef {
    public static final String MODULES_PREFIX = "openejb/modules/";
    private final Collection<String> links = new TreeSet<String>();

    public ContextValue(String linkName) {
        super(linkName);
    }

    @Override
    public synchronized String getLinkName() throws NamingException {
        if (this.links.size() == 1) {
            return "java:" + this.links.iterator().next();
        }
        ThreadContext tc = ThreadContext.getThreadContext();
        if (tc != null && tc.getBeanContext() != null) {
            return "java:" + ContextValue.linkName(tc.getBeanContext().getModuleID(), super.getLinkName());
        }
        throw new NamingException("more than one module binding match this name " + super.getLinkName());
    }

    public void addValue(String link) {
        this.links.add(link);
    }

    public boolean hasLink(String link) {
        return this.links.contains(link);
    }

    public static String linkName(String moduleId, String name) {
        return MODULES_PREFIX + moduleId + "/" + name;
    }
}

