/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.WebDeploymentListener;
import org.apache.tomee.catalina.event.AfterApplicationCreated;

public class WebDeploymentListeners {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB, WebDeploymentListeners.class);

    public boolean add(WebDeploymentListener webDeploymentListener) {
        LOGGER.warning("WebDeploymentListener API is replaced by 'void afterApplicationCreated(@Observes final AfterApplicationCreated event)' API");
        SystemInstance.get().addObserver((Object)new WebDeploymentListenerObserver(webDeploymentListener));
        return true;
    }

    private static class WebDeploymentListenerObserver {
        private final WebDeploymentListener delegate;

        public WebDeploymentListenerObserver(WebDeploymentListener webDeploymentListener) {
            this.delegate = webDeploymentListener;
        }

        public void afterApplicationCreated(@Observes AfterApplicationCreated event) {
            this.delegate.afterApplicationCreated(event.getApp(), event.getWeb());
        }
    }
}

