/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.sse;

import jakarta.servlet.AsyncContext;
import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.ws.rs.sse.OutboundSseEvent;
import jakarta.ws.rs.sse.SseBroadcaster;
import jakarta.ws.rs.sse.SseEventSink;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.cxf.jaxrs.sse.SseEventSinkImpl;

public final class SseBroadcasterImpl
implements SseBroadcaster {
    private final Set<SseEventSink> subscribers = new CopyOnWriteArraySet<SseEventSink>();
    private final Set<Consumer<SseEventSink>> closers = new CopyOnWriteArraySet<Consumer<SseEventSink>>();
    private final Set<BiConsumer<SseEventSink, Throwable>> exceptioners = new CopyOnWriteArraySet<BiConsumer<SseEventSink, Throwable>>();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public void register(final SseEventSink sink) {
        this.assertNotClosed();
        SseEventSinkImpl sinkImpl = (SseEventSinkImpl)sink;
        AsyncContext ctx = sinkImpl.getAsyncContext();
        ctx.addListener(new AsyncListener(){

            public void onComplete(AsyncEvent asyncEvent) throws IOException {
                SseBroadcasterImpl.this.subscribers.remove(sink);
                SseBroadcasterImpl.this.closers.forEach(closer -> closer.accept(sink));
            }

            public void onTimeout(AsyncEvent asyncEvent) throws IOException {
                SseBroadcasterImpl.this.subscribers.remove(sink);
            }

            public void onError(AsyncEvent asyncEvent) throws IOException {
                SseBroadcasterImpl.this.subscribers.remove(sink);
                SseBroadcasterImpl.this.exceptioners.forEach(exceptioner -> exceptioner.accept(sink, asyncEvent.getThrowable()));
            }

            public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
            }
        });
        this.subscribers.add(sink);
    }

    public CompletionStage<?> broadcast(OutboundSseEvent event) {
        this.assertNotClosed();
        ArrayList futures = new ArrayList();
        for (SseEventSink sink : this.subscribers) {
            try {
                futures.add(sink.send(event).toCompletableFuture());
            }
            catch (Exception ex) {
                this.exceptioners.forEach(exceptioner -> exceptioner.accept(sink, ex));
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    public void onClose(Consumer<SseEventSink> subscriber) {
        this.assertNotClosed();
        this.closers.add(subscriber);
    }

    public void onError(BiConsumer<SseEventSink, Throwable> exceptioner) {
        this.assertNotClosed();
        this.exceptioners.add(exceptioner);
    }

    public void close() {
        this.close(true);
    }

    private void assertNotClosed() {
        if (this.closed.get()) {
            throw new IllegalStateException("The SSE broadcaster is already closed");
        }
    }

    public void close(boolean cascading) {
        if (!cascading) {
            return;
        }
        if (this.closed.compareAndSet(false, true)) {
            this.subscribers.forEach(subscriber -> subscriber.close());
        }
    }
}

