/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.util;

import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.api.util.UtilLogging;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.Extensible;
import org.eclipse.microprofile.openapi.models.OpenAPI;
import org.eclipse.microprofile.openapi.models.Reference;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.responses.APIResponses;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

public class MergeUtil {
    private static final Set<String> EXCLUDED_PROPERTIES = new HashSet<String>();

    private MergeUtil() {
    }

    public static final OpenAPI merge(OpenAPI document1, OpenAPI document2) {
        return MergeUtil.mergeObjects(document1, document2);
    }

    static <T, P> boolean cycleDetected(String propertyName, T obj1, P prop1, T obj2, P prop2) {
        if (prop1 == obj2 || prop2 == obj1) {
            UtilLogging.logger.cylicReferenceAvoided(propertyName, obj1.getClass().getName());
            return true;
        }
        return false;
    }

    public static <T> T mergeObjects(T object1, T object2) {
        if (object1 == object2) {
            return object1;
        }
        if (object1 == null) {
            return object2;
        }
        if (object2 == null) {
            return object1;
        }
        if (!object1.getClass().equals(object2.getClass())) {
            return object2;
        }
        try {
            Arrays.stream(Introspector.getBeanInfo(object1.getClass()).getPropertyDescriptors()).filter(descriptor -> !EXCLUDED_PROPERTIES.contains(descriptor.getName())).filter(descriptor -> Objects.nonNull(descriptor.getWriteMethod())).forEach(descriptor -> {
                try {
                    MergeUtil.mergeProperty(object1, object2, descriptor);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    throw new OpenApiRuntimeException(e);
                }
            });
        }
        catch (IntrospectionException e) {
            UtilLogging.logger.failedToIntrospectBeanInfo(object1.getClass(), e);
        }
        return object1;
    }

    static <T> void mergeProperty(T object1, T object2, PropertyDescriptor descriptor) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        Class<?> ptype = descriptor.getPropertyType();
        Method writeMethod = descriptor.getWriteMethod();
        if (Constructible.class.isAssignableFrom(ptype)) {
            Object newValue;
            Object val1 = descriptor.getReadMethod().invoke(object1, new Object[0]);
            Object val2 = descriptor.getReadMethod().invoke(object2, new Object[0]);
            if (!MergeUtil.cycleDetected(descriptor.getName(), object1, val1, object2, val2) && (newValue = MergeUtil.mergeObjects(val1, val2)) != null) {
                writeMethod.invoke(object1, newValue);
            }
        } else if (Map.class.isAssignableFrom(ptype)) {
            Map values1 = (Map)descriptor.getReadMethod().invoke(object1, new Object[0]);
            Map values2 = (Map)descriptor.getReadMethod().invoke(object2, new Object[0]);
            Map newValues = MergeUtil.mergeMaps(values1, values2);
            writeMethod.invoke(object1, newValues);
        } else if (List.class.isAssignableFrom(ptype)) {
            List values1 = (List)descriptor.getReadMethod().invoke(object1, new Object[0]);
            List values2 = (List)descriptor.getReadMethod().invoke(object2, new Object[0]);
            List newValues = MergeUtil.mergeLists(values1, values2);
            writeMethod.invoke(object1, newValues);
        } else {
            Object newValue = descriptor.getReadMethod().invoke(object2, new Object[0]);
            if (newValue != null) {
                writeMethod.invoke(object1, newValue);
            }
        }
    }

    private static Map mergeMaps(Map values1, Map values2) {
        if (values1 == values2) {
            return values1;
        }
        if (values1 == null) {
            return values2;
        }
        if (values2 == null) {
            return values1;
        }
        if (!(values1 instanceof ModelImpl)) {
            values1 = new LinkedHashMap(values1);
        }
        if (!(values2 instanceof ModelImpl)) {
            values2 = new LinkedHashMap(values2);
        }
        LinkedHashMap targetValues = values1;
        Set entrySet = values2.entrySet();
        entrySet.stream().map(entry -> {
            Object pval1;
            Object key = entry.getKey();
            Object pval2 = entry.getValue();
            Object value = targetValues.containsKey(key) ? ((pval1 = targetValues.get(key)) instanceof Map ? MergeUtil.mergeMaps((Map)pval1, (Map)pval2) : (pval1 instanceof List ? MergeUtil.mergeLists((List)pval1, (List)pval2) : (pval1 instanceof Constructible ? MergeUtil.mergeObjects(pval1, pval2) : pval2))) : pval2;
            return new AbstractMap.SimpleEntry(key, value);
        }).forEach(modifiedEntry -> targetValues.put(modifiedEntry.getKey(), modifiedEntry.getValue()));
        if (values1 instanceof Constructible) {
            MergeUtil.mergeConstructible(values1, values2);
        }
        return values1;
    }

    static void mergeConstructible(Map values1, Map values2) {
        if (values1 instanceof Reference) {
            Reference ref1 = (Reference)values1;
            Reference ref2 = (Reference)values2;
            if (ref2.getRef() != null) {
                ref1.setRef(ref2.getRef());
            }
        }
        if (values1 instanceof Extensible) {
            Extensible extensible1 = (Extensible)values1;
            Extensible extensible2 = (Extensible)values2;
            extensible1.setExtensions(MergeUtil.mergeMaps(extensible1.getExtensions(), extensible2.getExtensions()));
        }
        if (values1 instanceof APIResponses) {
            APIResponses responses1 = (APIResponses)values1;
            APIResponses responses2 = (APIResponses)values2;
            responses1.defaultValue(MergeUtil.mergeObjects(responses1.getDefaultValue(), responses2.getDefaultValue()));
        }
    }

    private static List mergeLists(List values1, List values2) {
        if (Objects.equals(values1, values2)) {
            return values1;
        }
        if (values2 == null) {
            return values1;
        }
        if (values1 == null || values1.isEmpty()) {
            return values2;
        }
        if (values1.get(0) instanceof String) {
            return MergeUtil.mergeStringLists(values1, values2);
        }
        if (values1.get(0) instanceof Tag) {
            return MergeUtil.mergeTagLists(values1, values2);
        }
        if (values1.get(0) instanceof Server) {
            return MergeUtil.mergeServerLists(values1, values2);
        }
        if (values1.get(0) instanceof SecurityRequirement) {
            return MergeUtil.mergeSecurityRequirementLists(values1, values2);
        }
        if (values1.get(0) instanceof Parameter) {
            return MergeUtil.mergeParameterLists(values1, values2);
        }
        ArrayList merged = new ArrayList(values1.size() + values2.size());
        merged.addAll(values1);
        merged.addAll(values2);
        return merged;
    }

    private static List<String> mergeStringLists(List<String> values1, List<String> values2) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(values1);
        set.addAll(values2);
        return new ArrayList<String>(set);
    }

    private static List<Tag> mergeTagLists(List<Tag> values1, List<Tag> values2) {
        values1 = new ArrayList<Tag>(values1);
        for (Tag value2 : values2) {
            Tag match = null;
            for (Tag value1 : values1) {
                if (value1.getName() == null || !value1.getName().equals(value2.getName())) continue;
                match = value1;
                break;
            }
            if (match == null) {
                values1.add(value2);
                continue;
            }
            MergeUtil.mergeObjects(match, value2);
        }
        return values1;
    }

    private static List<Server> mergeServerLists(List<Server> values1, List<Server> values2) {
        values1 = new ArrayList<Server>(values1);
        for (Server value2 : values2) {
            Server match = null;
            for (Server value1 : values1) {
                if (value1.getUrl() == null || !value1.getUrl().equals(value2.getUrl())) continue;
                match = value1;
                break;
            }
            if (match == null) {
                values1.add(value2);
                continue;
            }
            MergeUtil.mergeObjects(match, value2);
        }
        return values1;
    }

    private static List<SecurityRequirement> mergeSecurityRequirementLists(List<SecurityRequirement> values1, List<SecurityRequirement> values2) {
        values1 = new ArrayList<SecurityRequirement>(values1);
        for (SecurityRequirement value2 : values2) {
            if (values1.contains(value2)) continue;
            values1.add(value2);
        }
        return values1;
    }

    private static List<Parameter> mergeParameterLists(List<Parameter> values1, List<Parameter> values2) {
        ArrayList<Parameter> mutableValues = new ArrayList<Parameter>(values1);
        values2.stream().filter(v -> Objects.nonNull(v.getName())).filter(v -> Objects.nonNull(v.getIn())).forEach(value2 -> {
            Optional<Parameter> match = mutableValues.stream().filter(value1 -> Objects.equals(value1.getName(), value2.getName())).filter(value1 -> Objects.equals(value1.getIn(), value2.getIn())).findFirst();
            if (match.isPresent()) {
                MergeUtil.mergeObjects(match.get(), value2);
            } else {
                mutableValues.add((Parameter)value2);
            }
        });
        return mutableValues;
    }

    static {
        EXCLUDED_PROPERTIES.add("class");
        EXCLUDED_PROPERTIES.add("openapi");
    }
}

