/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Set;
import org.apache.openejb.loader.Embedder;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.Zips;
import org.apache.openejb.loader.provisining.ProvisioningResolver;

public final class ProvisioningUtil {
    private static final String ADDITIONAL_LIB_CONFIG = "provisioning.properties";
    private static final String ZIP_KEY = "zip";
    private static final String DESTINATION_KEY = "destination";
    private static final String JAR_KEY = "jar";
    private static volatile ProvisioningResolver DEFAULT_PROVISIONING_RESOLVER = null;

    private ProvisioningUtil() {
    }

    public static Collection<File> addAdditionalLibraries() throws IOException {
        File destination;
        String toExtract;
        File conf = SystemInstance.get().getConf(ADDITIONAL_LIB_CONFIG);
        if (conf == null || !conf.exists()) {
            return Collections.emptyList();
        }
        Properties additionalLibProperties = IO.readProperties(conf);
        ProvisioningResolver resolver = SystemInstance.get().getComponent(ProvisioningResolver.class);
        if (resolver == null) {
            throw new IllegalStateException("SystemInstance not ready");
        }
        LinkedList<String> libToCopy = new LinkedList<String>();
        String toCopy = additionalLibProperties.getProperty(JAR_KEY);
        if (toCopy != null) {
            for (String lib : toCopy.split(",")) {
                libToCopy.addAll(resolver.realLocation(lib.trim()));
            }
        }
        if ((toExtract = additionalLibProperties.getProperty(ZIP_KEY)) != null) {
            for (String zip : toExtract.split(",")) {
                Set<String> strings = resolver.realLocation(zip);
                if (strings.size() != 1) {
                    throw new IllegalArgumentException("Didnt find a single zip: " + strings);
                }
                libToCopy.addAll(ProvisioningUtil.extract(strings.iterator().next()));
            }
        }
        if (!(destination = additionalLibProperties.containsKey(DESTINATION_KEY) ? new File(additionalLibProperties.getProperty(DESTINATION_KEY)) : new File(SystemInstance.get().getBase().getDirectory(), Embedder.ADDITIONAL_LIB_FOLDER)).exists()) {
            Files.mkdirs(destination);
        }
        ArrayList<File> newFiles = new ArrayList<File>(libToCopy.size());
        for (String lib : libToCopy) {
            newFiles.add(ProvisioningUtil.copy(new File(lib), destination));
        }
        return newFiles;
    }

    private static File copy(File file, File lib) throws IOException {
        File dest = new File(lib, file.getName());
        if (dest.exists()) {
            return dest;
        }
        IO.copy(file, dest);
        return dest;
    }

    private static Collection<String> extract(String zip) throws IOException {
        File zipFile;
        File extracted;
        File tmp = new File(SystemInstance.get().getBase().getDirectory(), "temp");
        if (!tmp.exists()) {
            try {
                Files.mkdirs(tmp);
            }
            catch (Files.FileRuntimeException fileRuntimeException) {
                // empty catch block
            }
        }
        if ((extracted = new File(tmp, (zipFile = new File(zip)).getName().replace(".zip", ""))).exists()) {
            return ProvisioningUtil.list(extracted);
        }
        Files.mkdirs(extracted);
        Zips.unzip(zipFile, extracted);
        return ProvisioningUtil.list(extracted);
    }

    private static Collection<String> list(File dir) {
        if (dir == null) {
            return Collections.emptyList();
        }
        ArrayList<String> libs = new ArrayList<String>();
        File[] files = dir.listFiles();
        if (files == null) {
            return Collections.emptyList();
        }
        for (File file : files) {
            if (file.isDirectory()) {
                libs.addAll(ProvisioningUtil.list(file));
                continue;
            }
            libs.add(file.getAbsolutePath());
        }
        return libs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Set<String> realLocation(String location) {
        boolean initialized = SystemInstance.isInitialized();
        if (initialized) return SystemInstance.get().getComponent(ProvisioningResolver.class).realLocation(location);
        if (DEFAULT_PROVISIONING_RESOLVER != null) return DEFAULT_PROVISIONING_RESOLVER.realLocation(location);
        Class<ProvisioningUtil> clazz = ProvisioningUtil.class;
        synchronized (ProvisioningUtil.class) {
            if (DEFAULT_PROVISIONING_RESOLVER != null) return DEFAULT_PROVISIONING_RESOLVER.realLocation(location);
            DEFAULT_PROVISIONING_RESOLVER = new ProvisioningResolver();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return DEFAULT_PROVISIONING_RESOLVER.realLocation(location);
        }
    }
}

