/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.common.constraint.Assert;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigValidationException;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config._private.ConfigMessages;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.microprofile.config.inject.ConfigProperties;

public final class ConfigMappings {
    public static void registerConfigMappings(SmallRyeConfig config, Set<ConfigClass> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, new SmallRyeConfigBuilder(), configClasses);
        }
    }

    public static void registerConfigProperties(SmallRyeConfig config, Set<ConfigClass> configClasses) throws ConfigValidationException {
        if (!configClasses.isEmpty()) {
            ConfigMappings.mapConfiguration(config, new SmallRyeConfigBuilder().withValidateUnknown(false), configClasses);
        }
    }

    public static Map<String, ConfigMappingInterface.Property> getProperties(ConfigClass configClass) {
        HashMap<String, ConfigMappingInterface.Property> properties = new HashMap<String, ConfigMappingInterface.Property>();
        for (Map.Entry<String, ConfigMappingInterface.Property> entry : ConfigMappingInterface.getProperties(ConfigMappingLoader.getConfigMapping(configClass.getType())).get(configClass.getType()).get("").entrySet()) {
            properties.put(ConfigMappings.prefix(configClass.getPrefix(), entry.getKey()), entry.getValue());
        }
        return properties;
    }

    private static void mapConfiguration(SmallRyeConfig config, SmallRyeConfigBuilder configBuilder, Set<ConfigClass> configClasses) throws ConfigValidationException {
        for (ConfigClass configClass : configClasses) {
            configBuilder.withMapping(configClass);
        }
        config.getDefaultValues().addDefaults(configBuilder.getDefaultValues());
        config.getMappings().putAll(config.buildMappings(configBuilder));
    }

    static String prefix(String prefix, String path) {
        return ConfigMappings.prefix(prefix, path, new StringBuilder(prefix));
    }

    static String prefix(String prefix, String path, StringBuilder sb) {
        if (prefix.isEmpty()) {
            return path;
        }
        if (path.isEmpty()) {
            return prefix;
        }
        if (path.charAt(0) == '[') {
            return sb.append(path).toString();
        }
        return sb.append(".").append(path).toString();
    }

    public static final class ConfigClass {
        private final Class<?> type;
        private final String prefix;
        private final Map<String, String> properties;

        public ConfigClass(Class<?> type, String prefix) {
            Assert.checkNotNullParam((String)"klass", type);
            Assert.checkNotNullParam((String)"path", (Object)prefix);
            this.type = type;
            this.prefix = prefix;
            this.properties = new HashMap<String, String>();
            Class<?> mappingClass = ConfigMappingLoader.getConfigMappingClass(type);
            StringBuilder sb = new StringBuilder(prefix);
            for (Map.Entry<String, String> property : ConfigMappingLoader.configMappingProperties(mappingClass).entrySet()) {
                String path = property.getKey();
                String name = prefix.isEmpty() ? path : (path.isEmpty() ? prefix : (path.charAt(0) == '[' ? sb.append(path).toString() : sb.append(".").append(path).toString()));
                this.properties.put(name, property.getValue());
                sb.setLength(prefix.length());
            }
        }

        @Deprecated(forRemoval=true)
        public Class<?> getKlass() {
            return this.type;
        }

        public Class<?> getType() {
            return this.type;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public Map<String, String> getProperties() {
            return this.properties;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConfigClass that = (ConfigClass)o;
            return this.type.equals(that.type) && this.prefix.equals(that.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.type, this.prefix);
        }

        public static ConfigClass configClass(Class<?> klass, String prefix) {
            return new ConfigClass(klass, prefix);
        }

        public static ConfigClass configClass(Class<?> klass) {
            String prefix;
            if (!klass.isInterface() && klass.isAnnotationPresent(ConfigMapping.class)) {
                throw ConfigMessages.msg.mappingAnnotationNotSupportedInClass(klass);
            }
            if (klass.isInterface() && klass.isAnnotationPresent(ConfigProperties.class)) {
                throw ConfigMessages.msg.propertiesAnnotationNotSupportedInInterface(klass);
            }
            if (klass.isInterface()) {
                ConfigMapping configMapping = klass.getAnnotation(ConfigMapping.class);
                String prefix2 = configMapping != null ? configMapping.prefix() : "";
                return ConfigClass.configClass(klass, prefix2);
            }
            ConfigProperties configProperties = klass.getAnnotation(ConfigProperties.class);
            String string = prefix = configProperties != null ? configProperties.prefix() : "";
            if (prefix.equals("org.eclipse.microprofile.config.inject.configproperties.unconfiguredprefix")) {
                prefix = "";
            }
            return ConfigClass.configClass(klass, prefix);
        }
    }
}

