/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import jakarta.enterprise.concurrent.ManagedScheduledExecutorService;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.BaseConvertDefinitions;
import org.apache.openejb.config.CompManagedBean;
import org.apache.openejb.config.sys.Resource;
import org.apache.openejb.jee.JndiConsumer;
import org.apache.openejb.jee.KeyedCollection;
import org.apache.openejb.jee.ManagedScheduledExecutor;
import org.apache.openejb.util.PropertyPlaceHolderHelper;

public class ConvertManagedScheduledExecutorServiceDefinitions
extends BaseConvertDefinitions {
    @Override
    public AppModule deploy(AppModule appModule) throws OpenEJBException {
        List<JndiConsumer> jndiConsumers = this.collectConsumers(appModule);
        KeyedCollection managedScheduledExecutors = new KeyedCollection();
        KeyedCollection managedScheduledExecutorsFromCompManagedBeans = new KeyedCollection();
        for (JndiConsumer consumer : jndiConsumers) {
            if (consumer == null) continue;
            if (consumer instanceof CompManagedBean) {
                managedScheduledExecutorsFromCompManagedBeans.addAll(consumer.getManagedScheduledExecutorMap().values());
                continue;
            }
            managedScheduledExecutors.addAll(consumer.getManagedScheduledExecutorMap().values());
        }
        Map managedScheduledExecutorsMap = managedScheduledExecutors.toMap();
        for (ManagedScheduledExecutor managedScheduledExecutor : managedScheduledExecutorsFromCompManagedBeans) {
            if (managedScheduledExecutorsMap.containsKey(managedScheduledExecutor.getName().getvalue())) continue;
            managedScheduledExecutors.add((Object)managedScheduledExecutor);
        }
        for (ManagedScheduledExecutor managedScheduledExecutor : managedScheduledExecutors) {
            appModule.getResources().add(this.toResource(managedScheduledExecutor));
        }
        return appModule;
    }

    private Resource toResource(ManagedScheduledExecutor managedScheduledExecutor) {
        String name = this.cleanUpName(managedScheduledExecutor.getName().getvalue());
        Resource def = new Resource(name, ManagedScheduledExecutorService.class.getName());
        def.setJndi(managedScheduledExecutor.getName().getvalue().replaceFirst("java:", ""));
        String contextName = managedScheduledExecutor.getContextService().getvalue();
        if ("java:comp/DefaultContextService".equals(contextName)) {
            contextName = "Default Context Service";
        }
        Properties p = def.getProperties();
        ConvertManagedScheduledExecutorServiceDefinitions.put(p, "Context", contextName);
        ConvertManagedScheduledExecutorServiceDefinitions.put(p, "HungTaskThreshold", managedScheduledExecutor.getHungTaskThreshold());
        ConvertManagedScheduledExecutorServiceDefinitions.put(p, "Core", managedScheduledExecutor.getMaxAsync());
        ConvertManagedScheduledExecutorServiceDefinitions.put(p, "JndiName", def.getJndi());
        return def;
    }

    private static void put(Properties properties, String key, Object value) {
        if (key == null) {
            return;
        }
        if (value == null) {
            return;
        }
        properties.put(key, PropertyPlaceHolderHelper.value(String.valueOf(value)));
    }
}

