/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import jakarta.enterprise.inject.Default;
import jakarta.enterprise.inject.spi.DefinitionException;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import jakarta.servlet.http.HttpServlet;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;

public class CheckInjectionPointUsage
extends ValidationBase {
    @Override
    public void validate(EjbModule ejbModule) {
        if (ejbModule.getBeans() == null) {
            return;
        }
        try {
            for (Field field : ejbModule.getFinder().findAnnotatedFields(Inject.class)) {
                Annotation[] annotations;
                if (!field.getType().equals(InjectionPoint.class) || !HttpServlet.class.isAssignableFrom(field.getDeclaringClass()) || (annotations = field.getAnnotations()).length != 1 && (annotations.length != 2 || field.getAnnotation(Default.class) == null)) continue;
                throw new DefinitionException("Can't inject InjectionPoint in " + field.getDeclaringClass());
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }
}

