/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.client;

import org.apache.cxf.Bus;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.openejb.server.cxf.client.SaajInFaultInterceptor;
import org.apache.openejb.server.cxf.client.SaajInInterceptor;
import org.apache.openejb.server.cxf.client.SaajOutInterceptor;
import org.apache.openejb.server.cxf.transport.util.CxfUtil;
import org.apache.openejb.server.webservices.saaj.SaajUniverse;

public abstract class SaajInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static boolean interceptorsRegistered = false;
    protected SaajUniverse universe;

    public SaajInterceptor(String phase, SaajUniverse universe) {
        super(phase);
        this.universe = universe;
    }

    public static synchronized void registerInterceptors() {
        if (!interceptorsRegistered) {
            Bus bus = CxfUtil.getBus();
            ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(CxfUtil.initBusLoader());
            try {
                SaajUniverse universe = new SaajUniverse();
                bus.getOutInterceptors().add(new SaajOutInterceptor(universe));
                bus.getInInterceptors().add(new SaajInInterceptor(universe));
                bus.getInInterceptors().add(new SaajInFaultInterceptor(universe));
            }
            finally {
                if (oldLoader != null) {
                    CxfUtil.clearBusLoader((ClassLoader)oldLoader);
                }
            }
            interceptorsRegistered = true;
        }
    }
}

