/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.formatter;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.logging.ConsoleHandler;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import org.apache.juli.AsyncFileHandler;

public class AsyncConsoleHandler
extends AsyncFileHandler {
    private final ConsoleHandler delegate = new ConsoleHandler(){
        {
            this.setFormatter(new SingleLineFormatter());
        }
    };

    @Override
    protected void publishInternal(LogRecord record) {
        this.delegate.publish(record);
    }

    public AsyncConsoleHandler() {
        String formatter;
        String filter;
        LogManager manager = LogManager.getLogManager();
        String cname = this.getClass().getName();
        String lvl = manager.getProperty(cname + ".level");
        if (lvl != null) {
            this.delegate.setLevel(Level.parse(lvl));
        }
        if ((filter = manager.getProperty(cname + ".filter")) != null) {
            try {
                this.delegate.setFilter((Filter)Filter.class.cast(ClassLoader.getSystemClassLoader().loadClass(filter).newInstance()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        if ((formatter = manager.getProperty(cname + ".formatter")) != null) {
            try {
                this.delegate.setFormatter((Formatter)Formatter.class.cast(ClassLoader.getSystemClassLoader().loadClass(formatter).newInstance()));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException reflectiveOperationException) {
                // empty catch block
            }
        }
        try {
            this.delegate.setEncoding(manager.getProperty(cname + ".encoding"));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    @Override
    public void flush() {
        this.delegate.flush();
    }

    @Override
    public void open() {
    }

    @Override
    protected void closeWriter() {
    }

    @Override
    protected void openWriter() {
    }

    private static class SingleLineFormatter
    extends Formatter {
        private static final String SEP = System.getProperty("line.separator", "\n");

        private SingleLineFormatter() {
        }

        @Override
        public synchronized String format(LogRecord record) {
            boolean exception = record.getThrown() != null;
            StringBuilder sbuf = new StringBuilder();
            sbuf.append(record.getLevel().getLocalizedName());
            sbuf.append(" - ");
            sbuf.append(this.formatMessage(record));
            sbuf.append(SEP);
            if (exception) {
                try {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    record.getThrown().printStackTrace(pw);
                    pw.close();
                    sbuf.append(sw.toString());
                }
                catch (Exception exception2) {
                    // empty catch block
                }
            }
            return sbuf.toString();
        }
    }
}

