/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.jul.formatter.log;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.juli.logging.Log;
import org.apache.tomee.jul.formatter.log.JULLogger;
import org.apache.tomee.jul.formatter.log.TomEELog;

public final class ReloadableLog {
    public static final Class<?>[] INTERFACES = new Class[]{Log.class};

    private ReloadableLog() {
    }

    public static Log newLog(String name, String factory) {
        return (Log)Log.class.cast(Proxy.newProxyInstance(ReloadableLog.class.getClassLoader(), INTERFACES, (InvocationHandler)new ReloadableLogHandler(factory, name)));
    }

    private static final class ReloadableLogHandler
    implements InvocationHandler {
        private static final String LOG4J_IMPL = "org.apache.tomee.loader.log.Log4jLog";
        private static final String LOG4J2_IMPL = "org.apache.tomee.loader.log.Log4j2Log";
        private static final String SLF4J_IMPL = "org.apache.tomee.loader.log.Slf4jLog";
        private static final String MAVEN_IMPL = "org.apache.openejb.maven.util.TomEEMavenLog";
        private volatile String factory;
        private final String name;
        private final AtomicReference<Log> delegate = new AtomicReference();
        private volatile boolean done = false;

        public ReloadableLogHandler(String factory, String name) {
            this.factory = factory;
            this.name = name;
            this.initDelegate();
        }

        private Log initDelegate() {
            block18: {
                if (this.done) {
                    return this.delegate.get();
                }
                try {
                    if (this.factory == null) {
                        String f = TomEELog.getLoggerClazz();
                        if (f != null) {
                            this.factory = f;
                        }
                        Log log = this.delegate.get();
                        if (this.factory == null && log != null) {
                            return log;
                        }
                    }
                    switch (this.factory) {
                        case "org.apache.openejb.util.Log4jLogStreamFactory": {
                            this.delegate.set(this.newInstance(LOG4J_IMPL));
                            break;
                        }
                        case "org.apache.openejb.util.Log4j2LogStreamFactory": {
                            this.delegate.set(this.newInstance(LOG4J2_IMPL));
                            break;
                        }
                        case "org.apache.openejb.util.Slf4jLogStreamFactory": {
                            this.delegate.set(this.newInstance(SLF4J_IMPL));
                            break;
                        }
                        case "org.apache.openejb.maven.util.MavenLogStreamFactory": {
                            this.delegate.set(this.newInstance(MAVEN_IMPL));
                            break;
                        }
                        default: {
                            this.delegate.set(new JULLogger(this.name));
                        }
                    }
                    this.done = true;
                }
                catch (Throwable the) {
                    if (this.delegate.get() != null) break block18;
                    this.delegate.set(new JULLogger(this.name));
                }
            }
            return this.delegate.get();
        }

        private Log newInstance(String impl) throws InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException, ClassNotFoundException {
            return (Log)Log.class.cast(Thread.currentThread().getContextClassLoader().loadClass(impl).getConstructor(String.class).newInstance(this.name));
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                return method.invoke((Object)this.initDelegate(), args);
            }
            catch (InvocationTargetException ite) {
                throw ite.getCause();
            }
        }
    }
}

