/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import javax.security.auth.Subject;

public class JDK24Subject {
    private static final MethodHandle CURRENT = JDK24Subject.lookupCurrent();

    public static Subject currentSubject() {
        try {
            return CURRENT.invoke();
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private static MethodHandle lookupCurrent() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findStatic(Subject.class, "current", MethodType.methodType(Subject.class));
        }
        catch (NoSuchMethodException e) {
            MethodHandle getContext = JDK24Subject.lookupGetContext();
            MethodHandle getSubject = JDK24Subject.lookupGetSubject();
            return MethodHandles.filterReturnValue(getContext, getSubject);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle lookupGetSubject() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> contextClazz = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            return lookup.findStatic(Subject.class, "getSubject", MethodType.methodType(Subject.class, contextClazz));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }

    private static MethodHandle lookupGetContext() {
        try {
            Class<?> controllerClazz = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessController");
            Class<?> contextClazz = ClassLoader.getSystemClassLoader().loadClass("java.security.AccessControlContext");
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            return lookup.findStatic(controllerClazz, "getContext", MethodType.methodType(contextClazz));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException e) {
            throw new AssertionError((Object)e);
        }
    }
}

