/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.support;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.saml.ext.saml2mdquery.AttributeQueryDescriptorType;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.slf4j.Logger;

public class AttributeConsumingServiceSelector {
    @Nonnull
    private Logger log = LoggerFactory.getLogger(AttributeConsumingServiceSelector.class);
    @Nullable
    private Integer index;
    @Nullable
    private RoleDescriptor roleDescriptor;
    private boolean onBadIndexUseDefault;

    @Nullable
    public Integer getIndex() {
        return this.index;
    }

    public void setIndex(@Nullable Integer requestedIndex) {
        this.index = requestedIndex;
    }

    @Nullable
    public RoleDescriptor getRoleDescriptor() {
        return this.roleDescriptor;
    }

    public void setRoleDescriptor(@Nullable RoleDescriptor descriptor) {
        this.roleDescriptor = descriptor;
    }

    public void setOnBadIndexUseDefault(boolean flag) {
        this.onBadIndexUseDefault = flag;
    }

    public boolean isOnBadIndexUseDefault() {
        return this.onBadIndexUseDefault;
    }

    @Nullable
    public AttributeConsumingService selectService() {
        List<AttributeConsumingService> candidates = this.getCandidates();
        if (candidates == null || candidates.isEmpty()) {
            this.log.debug("AttributeConsumingService candidate list was empty, can not select service");
            return null;
        }
        this.log.debug("AttributeConsumingService index was specified: {}", (Object)(this.index != null ? 1 : 0));
        AttributeConsumingService acs = null;
        if (this.index != null) {
            acs = this.selectByIndex(candidates);
            if (acs == null && this.isOnBadIndexUseDefault()) {
                acs = this.selectDefault(candidates);
            }
        } else {
            return this.selectDefault(candidates);
        }
        return acs;
    }

    @Nullable
    @Unmodifiable
    @NotLive
    protected List<AttributeConsumingService> getCandidates() {
        if (this.roleDescriptor == null) {
            this.log.debug("RoleDescriptor was not supplied, unable to select AttributeConsumingService");
            return null;
        }
        RoleDescriptor roleDescriptor = this.roleDescriptor;
        if (roleDescriptor instanceof SPSSODescriptor) {
            SPSSODescriptor sprole = (SPSSODescriptor)roleDescriptor;
            this.log.debug("Resolving AttributeConsumingService candidates from SPSSODescriptor");
            return sprole.getAttributeConsumingServices();
        }
        roleDescriptor = this.roleDescriptor;
        if (roleDescriptor instanceof AttributeQueryDescriptorType) {
            AttributeQueryDescriptorType queryrole = (AttributeQueryDescriptorType)roleDescriptor;
            this.log.debug("Resolving AttributeConsumingService candidates from AttributeQueryDescriptorType");
            return queryrole.getAttributeConsumingServices();
        }
        assert (this.roleDescriptor != null);
        this.log.debug("Unable to resolve service candidates, role descriptor was of an unsupported type: {}", (Object)this.roleDescriptor.getClass().getName());
        return null;
    }

    @Nullable
    private AttributeConsumingService selectByIndex(List<AttributeConsumingService> candidates) {
        this.log.debug("Selecting AttributeConsumingService by index");
        for (AttributeConsumingService attribCS : candidates) {
            if (this.index == null || this.index != attribCS.getIndex()) continue;
            this.log.debug("Selected AttributeConsumingService with index: {}", (Object)this.index);
            return attribCS;
        }
        this.log.debug("A service index of '{}' was specified, but was not found in metadata", (Object)this.index);
        return null;
    }

    @Nonnull
    private AttributeConsumingService selectDefault(List<AttributeConsumingService> candidates) {
        this.log.debug("Selecting default AttributeConsumingService");
        AttributeConsumingService firstNoDefault = null;
        for (AttributeConsumingService attribCS : candidates) {
            Boolean isDefault = attribCS.isDefault();
            if (isDefault != null && isDefault.booleanValue()) {
                this.log.debug("Selected AttributeConsumingService with explicit isDefault of true");
                return attribCS;
            }
            if (firstNoDefault != null || attribCS.isDefaultXSBoolean() != null) continue;
            firstNoDefault = attribCS;
        }
        if (firstNoDefault != null) {
            this.log.debug("Selected first AttributeConsumingService with no explicit isDefault");
            return firstNoDefault;
        }
        this.log.debug("Selected first AttributeConsumingService with explicit isDefault of false");
        return candidates.get(0);
    }
}

