/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.jdbc.pool;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.CommonDataSource;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.Xid;
import org.hsqldb.error.Error;
import org.hsqldb.jdbc.JDBCCommonDataSource;
import org.hsqldb.jdbc.JDBCConnection;
import org.hsqldb.jdbc.JDBCDriver;
import org.hsqldb.jdbc.JDBCUtil;
import org.hsqldb.jdbc.pool.JDBCXAConnection;
import org.hsqldb.jdbc.pool.JDBCXAResource;

public class JDBCXADataSource
extends JDBCCommonDataSource
implements XADataSource,
Serializable,
Referenceable,
CommonDataSource {
    private HashMap<Xid, JDBCXAResource> resources = new HashMap();
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock(true);

    @Override
    public XAConnection getXAConnection() throws SQLException {
        JDBCConnection jDBCConnection = (JDBCConnection)JDBCDriver.getConnection(this.url, this.connectionProps);
        JDBCXAConnection jDBCXAConnection = new JDBCXAConnection(this, jDBCConnection);
        return jDBCXAConnection;
    }

    @Override
    public XAConnection getXAConnection(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            throw JDBCUtil.nullArgument();
        }
        if (string.equals(this.user) && string2.equals(this.password)) {
            return this.getXAConnection();
        }
        throw JDBCUtil.sqlException(Error.error(4000));
    }

    @Override
    public Reference getReference() throws NamingException {
        String string = "org.hsqldb.jdbc.JDBCDataSourceFactory";
        Reference reference = new Reference(this.getClass().getName(), string, null);
        reference.add(new StringRefAddr("database", this.getDatabase()));
        reference.add(new StringRefAddr("user", this.getUser()));
        reference.add(new StringRefAddr("password", this.password));
        reference.add(new StringRefAddr("loginTimeout", Integer.toString(this.loginTimeout)));
        return reference;
    }

    public void addResource(Xid xid, JDBCXAResource jDBCXAResource) {
        this.lock.writeLock().lock();
        try {
            this.resources.put(xid, jDBCXAResource);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public JDBCXAResource removeResource(Xid xid) {
        this.lock.writeLock().lock();
        try {
            JDBCXAResource jDBCXAResource = this.resources.remove(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Xid[] getPreparedXids() {
        this.lock.writeLock().lock();
        try {
            Iterator<Xid> iterator = this.resources.keySet().iterator();
            HashSet<Xid> hashSet = new HashSet<Xid>();
            while (iterator.hasNext()) {
                Xid xid = iterator.next();
                if (this.resources.get((Object)xid).state != JDBCXAResource.XA_STATE_PREPARED) continue;
                hashSet.add(xid);
            }
            Xid[] xidArray = new Xid[hashSet.size()];
            hashSet.toArray(xidArray);
            Xid[] xidArray2 = xidArray;
            return xidArray2;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    JDBCXAResource getResource(Xid xid) {
        this.lock.readLock().lock();
        try {
            JDBCXAResource jDBCXAResource = this.resources.get(xid);
            return jDBCXAResource;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }
}

