/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.httpd;

import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Properties;
import java.util.Random;
import org.apache.openejb.loader.Options;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.HttpServer;
import org.apache.openejb.server.httpd.OpenEJBHttpServer;
import org.apache.openejb.server.httpd.ServletRequestAdapter;
import org.apache.openejb.server.httpd.ServletResponseAdapter;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.AbstractHandler;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.session.DefaultSessionIdManager;
import org.eclipse.jetty.server.session.SessionHandler;

public class JettyHttpServer
implements HttpServer {
    private final HttpListener listener;
    private Server server;
    private int port;

    public JettyHttpServer() {
        this(OpenEJBHttpServer.getHttpListenerRegistry());
    }

    public JettyHttpServer(HttpListener listener) {
        this.listener = listener;
    }

    @Override
    public HttpListener getListener() {
        return this.listener;
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException();
    }

    public void service(InputStream in, OutputStream out) throws ServiceException, IOException {
        throw new UnsupportedOperationException();
    }

    public String getName() {
        return "jetty";
    }

    public int getPort() {
        return this.port;
    }

    public String getIP() {
        return "0.0.0.0";
    }

    public void init(Properties props) throws Exception {
        Options options = new Options(props);
        this.port = options.get("port", 8080);
        this.server = new Server();
        ServerConnector connector = new ServerConnector(this.server);
        connector.setPort(this.port);
        this.server.setConnectors(new Connector[]{connector});
        ContextHandler context = new ContextHandler();
        context.setContextPath("/");
        ContextHandler.Context servletContext = context.getServletContext();
        this.server.setHandler((Handler)context);
        AbstractHandler handler = new AbstractHandler((ServletContext)servletContext){
            final /* synthetic */ ServletContext val$servletContext;
            {
                this.val$servletContext = servletContext;
            }

            public void handle(String target, Request request, HttpServletRequest req, HttpServletResponse res) throws IOException, ServletException {
                try {
                    request.setHandled(true);
                    ServletRequestAdapter httpRequest = new ServletRequestAdapter(req, res, this.val$servletContext);
                    ServletResponseAdapter httpResponse = new ServletResponseAdapter(res);
                    JettyHttpServer.this.listener.onMessage(httpRequest, httpResponse);
                }
                catch (ServletException | IOException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new ServletException((Throwable)e);
                }
            }
        };
        SessionHandler sessionHandler = new SessionHandler();
        DefaultSessionIdManager sessionManager = new DefaultSessionIdManager(this.server, (Random)new SecureRandom());
        sessionHandler.setSessionIdManager((SessionIdManager)sessionManager);
        sessionHandler.setHandler((Handler)handler);
        context.setHandler((Handler)sessionHandler);
    }

    public void start() throws ServiceException {
        try {
            this.server.join();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public void stop() throws ServiceException {
        try {
            this.server.destroy();
        }
        catch (Exception e) {
            throw new ServiceException((Throwable)e);
        }
    }
}

