/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import jakarta.annotation.Resource;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.ws.rs.container.ResourceContext;
import jakarta.ws.rs.container.ResourceInfo;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Configuration;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.HttpHeaders;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.SecurityContext;
import jakarta.ws.rs.core.UriInfo;
import jakarta.ws.rs.ext.ContextResolver;
import jakarta.ws.rs.ext.Providers;
import jakarta.ws.rs.sse.Sse;
import jakarta.ws.rs.sse.SseEventSink;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.cxf.jaxrs.ext.ContextProvider;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.rest.ThreadLocalContextManager;

public final class Contexts {
    private static final ThreadLocal<Exchange> EXCHANGE = new ThreadLocal();
    private static final Set<Class<?>> CONTEXT_CLASSES = Contexts.contextClasses();

    private Contexts() {
    }

    public static Collection<Class<?>> findContextFields(Class<?> cls, Collection<Class<?>> types) {
        if (cls == Object.class || cls == null) {
            return Collections.emptyList();
        }
        for (Field f : cls.getDeclaredFields()) {
            for (Annotation a : f.getAnnotations()) {
                if (a.annotationType() != Context.class && (a.annotationType() != Resource.class || !Contexts.isContextClass(f.getType()))) continue;
                types.add(f.getType());
            }
        }
        Contexts.findContextFields(cls.getSuperclass(), types);
        return types;
    }

    private static boolean isContextClass(Class<?> type) {
        return CONTEXT_CLASSES.contains(type);
    }

    private static Set<Class<?>> contextClasses() {
        HashSet classes = new HashSet();
        classes.add(UriInfo.class);
        classes.add(SecurityContext.class);
        classes.add(HttpHeaders.class);
        classes.add(ContextResolver.class);
        classes.add(Providers.class);
        classes.add(Request.class);
        classes.add(Application.class);
        classes.add(HttpServletRequest.class);
        classes.add(HttpServletResponse.class);
        classes.add(ServletConfig.class);
        classes.add(ServletContext.class);
        classes.add(MessageContext.class);
        classes.add(Sse.class);
        classes.add(SseEventSink.class);
        return classes;
    }

    public static void bind(Exchange exchange) {
        if (exchange == null) {
            return;
        }
        ClassResourceInfo cri = ((OperationResourceInfo)exchange.get(OperationResourceInfo.class)).getClassResourceInfo();
        HashSet types = new HashSet();
        for (Field field : cri.getContextFields()) {
            types.add(field.getType());
        }
        Contexts.bind(exchange, types);
    }

    public static void bind(Exchange exchange, Collection<Class<?>> types) {
        EXCHANGE.set(exchange);
        CdiAppContextsService.pushRequestReleasable((Runnable)CleanUpThreadLocal.INSTANCE);
        for (Class<?> type : types) {
            Configuration config;
            Request binding;
            if (Request.class.equals(type)) {
                binding = (Request)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, Request.class);
                ThreadLocalContextManager.REQUEST.set((Object)binding);
                continue;
            }
            if (UriInfo.class.equals(type)) {
                binding = (UriInfo)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, UriInfo.class);
                ThreadLocalContextManager.URI_INFO.set((Object)binding);
                continue;
            }
            if (HttpHeaders.class.equals(type)) {
                binding = (HttpHeaders)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, HttpHeaders.class);
                ThreadLocalContextManager.HTTP_HEADERS.set((Object)binding);
                continue;
            }
            if (SecurityContext.class.equals(type)) {
                binding = (SecurityContext)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, SecurityContext.class);
                ThreadLocalContextManager.SECURITY_CONTEXT.set((Object)binding);
                continue;
            }
            if (ContextResolver.class.equals(type)) {
                binding = (ContextResolver)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), type, ContextResolver.class);
                ThreadLocalContextManager.CONTEXT_RESOLVER.set((Object)binding);
                continue;
            }
            if (Providers.class.equals(type)) {
                Providers providers = (Providers)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, Providers.class);
                ThreadLocalContextManager.PROVIDERS.set((Object)providers);
                continue;
            }
            if (ServletRequest.class.equals(type)) {
                ServletRequest servletRequest = (ServletRequest)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, ServletRequest.class);
                if (servletRequest == null) {
                    servletRequest = (ServletRequest)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, HttpServletRequest.class);
                }
                ThreadLocalContextManager.SERVLET_REQUEST.set((Object)servletRequest);
                continue;
            }
            if (HttpServletRequest.class.equals(type)) {
                HttpServletRequest httpServletRequest = (HttpServletRequest)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, HttpServletRequest.class);
                ThreadLocalContextManager.HTTP_SERVLET_REQUEST.set((Object)httpServletRequest);
                continue;
            }
            if (HttpServletResponse.class.equals(type)) {
                HttpServletResponse httpServletResponse = (HttpServletResponse)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, HttpServletResponse.class);
                ThreadLocalContextManager.HTTP_SERVLET_RESPONSE.set((Object)httpServletResponse);
                continue;
            }
            if (ServletConfig.class.equals(type)) {
                ServletConfig servletConfig = (ServletConfig)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, ServletConfig.class);
                ThreadLocalContextManager.SERVLET_CONFIG.set((Object)servletConfig);
                continue;
            }
            if (Configuration.class.equals(type)) {
                config = (Configuration)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, Configuration.class);
                ThreadLocalContextManager.CONFIGURATION.set((Object)config);
                continue;
            }
            if (ResourceInfo.class.equals(type)) {
                config = (ResourceInfo)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, ResourceInfo.class);
                ThreadLocalContextManager.RESOURCE_INFO.set((Object)config);
                continue;
            }
            if (ResourceContext.class.equals(type)) {
                config = (ResourceContext)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, ResourceContext.class);
                ThreadLocalContextManager.RESOURCE_CONTEXT.set((Object)config);
                continue;
            }
            if (Application.class.equals(type)) {
                config = (Application)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, Application.class);
                ThreadLocalContextManager.APPLICATION.set((Application)config);
                continue;
            }
            Message message = exchange.getInMessage();
            ContextProvider provider = ProviderFactory.getInstance((Message)message).createContextProvider(type, message);
            if (provider == null) continue;
            Object value = provider.createContext(message);
            HashMap<String, Object> map = (HashMap<String, Object>)ThreadLocalContextManager.OTHERS.get();
            if (map == null) {
                map = new HashMap<String, Object>();
                ThreadLocalContextManager.OTHERS.set(map);
            }
            map.put(type.getName(), value);
        }
    }

    public static <T> T find(Class<T> clazz) {
        Message m = JAXRSUtils.getCurrentMessage();
        if (m != null) {
            return (T)JAXRSUtils.createContextValue((Message)m, null, clazz);
        }
        Exchange exchange = EXCHANGE.get();
        if (exchange == null) {
            throw new IllegalStateException("No CXF message usable for JAX-RS @Context injections in that thread so can't use " + clazz);
        }
        return (T)JAXRSUtils.createContextValue((Message)exchange.getInMessage(), null, clazz);
    }

    public static Object state() {
        return EXCHANGE.get();
    }

    public static Object restore(Object oldState) {
        Object old = Contexts.state();
        EXCHANGE.set((Exchange)Exchange.class.cast(oldState));
        return old;
    }

    private static class CleanUpThreadLocal
    implements Runnable {
        public static final Runnable INSTANCE = new CleanUpThreadLocal();

        private CleanUpThreadLocal() {
        }

        @Override
        public void run() {
            EXCHANGE.remove();
            ThreadLocalContextManager.reset();
        }
    }
}

