/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.metrics.base;

import com.sun.management.OperatingSystemMXBean;
import io.smallrye.metrics.legacyapi.LegacyMetricRegistryAdapter;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import org.eclipse.microprofile.metrics.Metadata;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.Tag;

public class LegacyBaseMetrics {
    private final boolean nativeMode;
    private static final String GARBAGE_COLLECTION_TOTAL = "gc.total";
    private static final String GARBAGE_COLLECTION_TIME = "gc.time";
    private static final String THREAD_COUNT = "thread.count";
    private static final String THREAD_DAEMON_COUNT = "thread.daemon.count";
    private static final String THREAD_MAX_COUNT = "thread.max.count";
    private static final String CURRENT_LOADED_CLASS_COUNT = "classloader.loadedClasses.count";
    private static final String TOTAL_LOADED_CLASS_COUNT = "classloader.loadedClasses.total";
    private static final String TOTAL_UNLOADED_CLASS_COUNT = "classloader.unloadedClasses.total";
    private static final String JVM_UPTIME = "jvm.uptime";
    private static final String SYSTEM_LOAD_AVERAGE = "cpu.systemLoadAverage";
    private static final String CPU_AVAILABLE_PROCESSORS = "cpu.availableProcessors";
    private static final String PROCESS_CPU_LOAD = "cpu.processCpuLoad";
    private static final String PROCESS_CPU_TIME = "cpu.processCpuTime";
    private static final String MEMORY_COMMITTED_HEAP = "memory.committedHeap";
    private static final String MEMORY_MAX_HEAP = "memory.maxHeap";
    private static final String MEMORY_USED_HEAP = "memory.usedHeap";

    public LegacyBaseMetrics() {
        this.nativeMode = false;
    }

    public LegacyBaseMetrics(boolean nativeMode) {
        this.nativeMode = nativeMode;
    }

    public void register(MetricRegistry registry) {
        this.garbageCollectionMetrics(registry);
        this.classLoadingMetrics(registry);
        this.baseOperatingSystemMetrics(registry);
        this.threadingMetrics(registry);
        this.runtimeMetrics(registry);
        this.baseMemoryMetrics(registry);
    }

    private void garbageCollectionMetrics(MetricRegistry registry) {
        if (registry instanceof LegacyMetricRegistryAdapter) {
            for (GarbageCollectorMXBean gc : ManagementFactory.getGarbageCollectorMXBeans()) {
                LegacyMetricRegistryAdapter lmr = (LegacyMetricRegistryAdapter)registry;
                Tag tag = new Tag("name", gc.getName());
                Metadata metadata = Metadata.builder().withName(GARBAGE_COLLECTION_TOTAL).withDescription("Displays the total number of collections that have occurred. This attribute lists -1 if the collection count is undefined for this collector.").build();
                lmr.counter(metadata, gc, GarbageCollectorMXBean::getCollectionCount, tag);
                metadata = Metadata.builder().withName(GARBAGE_COLLECTION_TIME).withDescription("Displays the approximate accumulated collection elapsed time in seconds. This attribute displays -1 if the collection elapsed time is undefined for this collector. The Java virtual machine implementation may use a high resolution timer to measure the elapsed time. This attribute may display the same value even if the collection count has been incremented if the collection elapsed time is very short.").withUnit("seconds").build();
                lmr.gauge(metadata, gc, gcObj -> (double)gcObj.getCollectionTime() / 1000.0, tag);
            }
        }
    }

    private void classLoadingMetrics(MetricRegistry registry) {
        if (registry instanceof LegacyMetricRegistryAdapter) {
            ClassLoadingMXBean classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
            LegacyMetricRegistryAdapter lmr = (LegacyMetricRegistryAdapter)registry;
            Metadata metadata = Metadata.builder().withName(TOTAL_LOADED_CLASS_COUNT).withDescription("Displays the total number of classes that have been loaded since the Java virtual machine has started execution.").build();
            lmr.counter(metadata, classLoadingMXBean, ClassLoadingMXBean::getTotalLoadedClassCount, new Tag[0]);
            metadata = Metadata.builder().withName(TOTAL_UNLOADED_CLASS_COUNT).withDescription("Displays the total number of classes unloaded since the Java virtual machine has started execution.").build();
            lmr.counter(metadata, classLoadingMXBean, ClassLoadingMXBean::getUnloadedClassCount, new Tag[0]);
            metadata = Metadata.builder().withName(CURRENT_LOADED_CLASS_COUNT).withDescription("Displays the number of classes that are currently loaded in the Java virtual machine.").build();
            lmr.gauge(metadata, classLoadingMXBean, ClassLoadingMXBean::getLoadedClassCount, new Tag[0]);
        }
    }

    private void baseOperatingSystemMetrics(MetricRegistry registry) {
        if (registry instanceof LegacyMetricRegistryAdapter) {
            java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
            LegacyMetricRegistryAdapter lmr = (LegacyMetricRegistryAdapter)registry;
            Metadata metadata = Metadata.builder().withName(SYSTEM_LOAD_AVERAGE).withDescription("Displays the system load average for the last minute. The system load average is the sum of the number of runnable entities queued to the available processors and the number of runnable entities running on the available processors averaged over a period of time. The way in which the load average is calculated is operating system specific but is typically a damped time-dependent average. If the load average is not available, a negative value is displayed. This attribute is designed to provide a hint about the system load and may be queried frequently. The load average may be unavailable on some platforms where it is expensive to implement this method.").build();
            lmr.gauge(metadata, operatingSystemMXBean::getSystemLoadAverage, new Tag[0]);
            metadata = Metadata.builder().withName(CPU_AVAILABLE_PROCESSORS).withDescription("Displays the number of processors available to the Java virtual machine. This value may change during a particular invocation of the virtual machine.").build();
            lmr.gauge(metadata, operatingSystemMXBean::getAvailableProcessors, new Tag[0]);
            if (!this.nativeMode && OperatingSystemMXBean.class.isAssignableFrom(operatingSystemMXBean.getClass())) {
                try {
                    OperatingSystemMXBean internalOperatingSystemMXBean = (OperatingSystemMXBean)operatingSystemMXBean;
                    metadata = Metadata.builder().withName(PROCESS_CPU_LOAD).withDescription("Displays  the \"recent cpu usage\" for the Java Virtual Machine process. This value is a double in the [0.0,1.0] interval. A value of 0.0 means that none of the CPUs were running threads from the JVM process during the recent period of time observed, while a value of 1.0 means that all CPUs were actively running threads from the JVM 100% of the time during the recent period being observed. Threads from the JVM include the application threads as well as the JVM internal threads. All values betweens 0.0 and 1.0 are possible depending of the activities going on in the JVM process and the whole system. If the Java Virtual Machine recent CPU usage is not available, the method returns a negative value.").withUnit("percent").build();
                    lmr.gauge(metadata, internalOperatingSystemMXBean::getProcessCpuLoad, new Tag[0]);
                    metadata = Metadata.builder().withName(PROCESS_CPU_TIME).withDescription("Displays the CPU time used by the process on which the Java virtual machine is running in seconds.").withUnit("seconds").build();
                    lmr.gauge(metadata, () -> (double)internalOperatingSystemMXBean.getProcessCpuTime() / 1.0E9, new Tag[0]);
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
        }
    }

    private void threadingMetrics(MetricRegistry registry) {
        if (registry instanceof LegacyMetricRegistryAdapter) {
            ThreadMXBean thread = ManagementFactory.getThreadMXBean();
            LegacyMetricRegistryAdapter lmr = (LegacyMetricRegistryAdapter)registry;
            Metadata metadata = Metadata.builder().withName(THREAD_COUNT).withDescription("Displays the current number of live threads including both daemon and non-daemon threads").build();
            lmr.gauge(metadata, thread::getThreadCount, new Tag[0]);
            metadata = Metadata.builder().withName(THREAD_DAEMON_COUNT).withDescription("Displays the current number of live daemon threads.").build();
            lmr.gauge(metadata, thread::getDaemonThreadCount, new Tag[0]);
            metadata = Metadata.builder().withName(THREAD_MAX_COUNT).withDescription("Displays the peak live thread count since the Java virtual machine started or peak was reset. This includes daemon and non-daemon threads.").build();
            lmr.gauge(metadata, thread::getPeakThreadCount, new Tag[0]);
        }
    }

    private void runtimeMetrics(MetricRegistry registry) {
        if (registry instanceof LegacyMetricRegistryAdapter) {
            RuntimeMXBean runtimeMXBean = ManagementFactory.getRuntimeMXBean();
            LegacyMetricRegistryAdapter lmr = (LegacyMetricRegistryAdapter)registry;
            Metadata metadata = Metadata.builder().withName(JVM_UPTIME).withDescription("Displays the time from the start of the Java virtual machine in seconds.").withUnit("seconds").build();
            lmr.gauge(metadata, () -> (double)runtimeMXBean.getUptime() / 1000.0, new Tag[0]);
        }
    }

    private void baseMemoryMetrics(MetricRegistry registry) {
        if (registry instanceof LegacyMetricRegistryAdapter) {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            LegacyMetricRegistryAdapter lmr = (LegacyMetricRegistryAdapter)registry;
            Metadata metadata = Metadata.builder().withName(MEMORY_COMMITTED_HEAP).withDescription("Displays the amount of memory in bytes that is committed for the Java virtual machine to use. This amount of memory is guaranteed for the Java virtual machine to use.").withUnit("bytes").build();
            lmr.gauge(metadata, () -> memoryMXBean.getHeapMemoryUsage().getCommitted(), new Tag[0]);
            metadata = Metadata.builder().withName(MEMORY_MAX_HEAP).withDescription("Displays the maximum amount of heap memory in bytes that can be used for memory management. This attribute displays -1 if the maximum heap memory size is undefined. This amount of memory is not guaranteed to be available for memory management if it is greater than the amount of committed memory. The Java virtual machine may fail to allocate memory even if the amount of used memory does not exceed this maximum size.").withUnit("bytes").build();
            lmr.gauge(metadata, () -> memoryMXBean.getHeapMemoryUsage().getMax(), new Tag[0]);
            metadata = Metadata.builder().withName(MEMORY_USED_HEAP).withDescription("Displays the amount of used heap memory in bytes.").withUnit("bytes").build();
            lmr.gauge(metadata, () -> memoryMXBean.getHeapMemoryUsage().getUsed(), new Tag[0]);
        }
    }
}

