/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.microprofile.jwt.principal;

import jakarta.json.Json;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.apache.openejb.spi.CallerPrincipal;
import org.eclipse.microprofile.jwt.Claims;
import org.eclipse.microprofile.jwt.JsonWebToken;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;

@CallerPrincipal
public class JWTCallerPrincipal
implements JsonWebToken {
    private static final Logger logger = Logger.getLogger(JWTCallerPrincipal.class.getName());
    private final String jwt;
    private final String type;
    private final JwtClaims claimsSet;
    private final String name;

    public JWTCallerPrincipal(String jwt, String type, JwtClaims claimsSet, String name) {
        this.name = name;
        this.jwt = jwt;
        this.type = type;
        this.claimsSet = claimsSet;
        this.fixJoseTypes();
    }

    public String getName() {
        return this.name;
    }

    public <T> Optional<T> claim(String claimName) {
        Object claim = this.getClaim(claimName);
        return Optional.ofNullable(claim);
    }

    public Set<String> getAudience() {
        HashSet<String> audSet = new HashSet<String>();
        try {
            List audList = this.claimsSet.getStringListClaimValue("aud");
            if (audList != null) {
                audSet.addAll(audList);
            }
        }
        catch (MalformedClaimException e) {
            try {
                String aud = this.claimsSet.getStringClaimValue("aud");
                audSet.add(aud);
            }
            catch (MalformedClaimException e1) {
                logger.log(Level.FINEST, "Can't retrieve malformed 'aud' claim.", e);
            }
        }
        return audSet.isEmpty() ? null : audSet;
    }

    public Set<String> getGroups() {
        HashSet<String> groups = new HashSet<String>();
        try {
            List globalGroups = this.claimsSet.getStringListClaimValue("groups");
            if (globalGroups != null) {
                groups.addAll(globalGroups);
            }
        }
        catch (MalformedClaimException e) {
            logger.log(Level.FINEST, "Can't retrieve malformed 'groups' claim.", e);
        }
        return groups;
    }

    public Set<String> getClaimNames() {
        return new HashSet<String>(this.claimsSet.getClaimNames());
    }

    public String getRawToken() {
        return this.jwt;
    }

    public Object getClaim(String claimName) {
        Claims claimType = Claims.UNKNOWN;
        Object claim = null;
        try {
            claimType = Claims.valueOf((String)claimName);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        switch (claimType) {
            case auth_time: 
            case updated_at: {
                try {
                    claim = this.claimsSet.getClaimValue(claimType.name(), Long.class);
                    if (claim != null) break;
                    claim = 0L;
                }
                catch (MalformedClaimException e) {
                    logger.log(Level.FINEST, "Can't retrieve 'updated_at' a malformed claim.", e);
                }
                break;
            }
            case groups: {
                claim = this.getGroups();
                break;
            }
            case aud: {
                claim = this.getAudience();
                break;
            }
            case UNKNOWN: {
                claim = this.claimsSet.getClaimValue(claimName);
                break;
            }
            default: {
                claim = this.claimsSet.getClaimValue(claimType.name());
            }
        }
        return claim;
    }

    public boolean implies(Subject subject) {
        return false;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean showAll) {
        String toString = "DefaultJWTCallerPrincipal{id='" + this.getTokenID() + "', name='" + this.getName() + "', expiration=" + this.getExpirationTime() + ", notBefore=" + this.getClaim(Claims.nbf.name()) + ", issuedAt=" + this.getIssuedAtTime() + ", issuer='" + this.getIssuer() + "', audience=" + this.getAudience() + ", subject='" + this.getSubject() + "', type='" + this.type + "', issuedFor='" + this.getClaim("azp") + "', authTime=" + this.getClaim("auth_time") + ", givenName='" + this.getClaim("given_name") + "', familyName='" + this.getClaim("family_name") + "', middleName='" + this.getClaim("middle_name") + "', nickName='" + this.getClaim("nickname") + "', preferredUsername='" + this.getClaim("preferred_username") + "', email='" + this.getClaim("email") + "', emailVerified=" + this.getClaim(Claims.email_verified.name()) + ", allowedOrigins=" + this.getClaim("allowedOrigins") + ", updatedAt=" + this.getClaim("updated_at") + ", acr='" + this.getClaim("acr") + "'";
        StringBuilder tmp = new StringBuilder(toString);
        tmp.append(", groups=[");
        for (String group : this.getGroups()) {
            tmp.append(group);
            tmp.append(',');
        }
        tmp.setLength(tmp.length() - 1);
        tmp.append("]}");
        return tmp.toString();
    }

    private void fixJoseTypes() {
        if (this.claimsSet.hasClaim(Claims.address.name())) {
            this.replaceMap(Claims.address.name());
        }
        if (this.claimsSet.hasClaim(Claims.jwk.name())) {
            this.replaceMap(Claims.jwk.name());
        }
        if (this.claimsSet.hasClaim(Claims.sub_jwk.name())) {
            this.replaceMap(Claims.sub_jwk.name());
        }
        Set<String> customClaimNames = this.filterCustomClaimNames(this.claimsSet.getClaimNames());
        for (String name : customClaimNames) {
            Object claimValue = this.claimsSet.getClaimValue(name);
            if (claimValue instanceof List) {
                this.replaceList(name);
                continue;
            }
            if (claimValue instanceof Map) {
                this.replaceMap(name);
                continue;
            }
            if (!(claimValue instanceof Number)) continue;
            this.replaceNumber(name);
        }
    }

    private Set<String> filterCustomClaimNames(Collection<String> claimNames) {
        HashSet<String> customNames = new HashSet<String>(claimNames);
        for (Claims claim : Claims.values()) {
            customNames.remove(claim.name());
        }
        return customNames;
    }

    private void replaceMap(String name) {
        try {
            Map map = (Map)this.claimsSet.getClaimValue(name, Map.class);
            JsonObject jsonObject = this.replaceMap(map);
            this.claimsSet.setClaim(name, (Object)jsonObject);
        }
        catch (MalformedClaimException e) {
            logger.log(Level.WARNING, "replaceMap failure for: " + name, e);
        }
    }

    private JsonObject replaceMap(Map<String, Object> map) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Object entryValue = entry.getValue();
            if (entryValue instanceof Map) {
                JsonObject entryJsonObject = this.replaceMap((Map)entryValue);
                builder.add(entry.getKey(), (JsonValue)entryJsonObject);
                continue;
            }
            if (entryValue instanceof List) {
                JsonArray array = (JsonArray)this.wrapValue(entryValue);
                builder.add(entry.getKey(), (JsonValue)array);
                continue;
            }
            if (entryValue instanceof Long || entryValue instanceof Integer) {
                long lvalue = ((Number)entryValue).longValue();
                builder.add(entry.getKey(), lvalue);
                continue;
            }
            if (entryValue instanceof Double || entryValue instanceof Float) {
                double value = ((Number)entryValue).doubleValue();
                builder.add(entry.getKey(), value);
                continue;
            }
            if (entryValue instanceof Boolean) {
                boolean flag = (Boolean)entryValue;
                builder.add(entry.getKey(), flag);
                continue;
            }
            if (!(entryValue instanceof String)) continue;
            builder.add(entry.getKey(), entryValue.toString());
        }
        return builder.build();
    }

    private JsonValue wrapValue(Object value) {
        JsonValue jsonValue = null;
        if (value instanceof Number) {
            Number number = (Number)value;
            jsonValue = number instanceof Long || number instanceof Integer ? Json.createObjectBuilder().add("tmp", number.longValue()).build().getJsonNumber("tmp") : Json.createObjectBuilder().add("tmp", number.doubleValue()).build().getJsonNumber("tmp");
        } else if (value instanceof Boolean) {
            Boolean flag = (Boolean)value;
            jsonValue = flag != false ? JsonValue.TRUE : JsonValue.FALSE;
        } else if (value instanceof List) {
            JsonArrayBuilder arrayBuilder = Json.createArrayBuilder();
            List list = (List)value;
            for (Object element : list) {
                if (element instanceof String) {
                    arrayBuilder.add(element.toString());
                    continue;
                }
                JsonValue jvalue = this.wrapValue(element);
                arrayBuilder.add(jvalue);
            }
            jsonValue = arrayBuilder.build();
        }
        return jsonValue;
    }

    private void replaceList(String name) {
        try {
            List list = (List)this.claimsSet.getClaimValue(name, List.class);
            JsonArray array = (JsonArray)this.wrapValue(list);
            this.claimsSet.setClaim(name, (Object)array);
        }
        catch (MalformedClaimException e) {
            logger.log(Level.WARNING, "replaceList failure for: " + name, e);
        }
    }

    private void replaceNumber(String name) {
        try {
            Number number = (Number)this.claimsSet.getClaimValue(name, Number.class);
            JsonNumber jsonNumber = (JsonNumber)this.wrapValue(number);
            this.claimsSet.setClaim(name, (Object)jsonNumber);
        }
        catch (MalformedClaimException e) {
            logger.log(Level.WARNING, "replaceNumber failure for: " + name, e);
        }
    }
}

