/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import jakarta.enterprise.event.Event;
import jakarta.enterprise.inject.spi.Decorator;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.Interceptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.event.EventImpl;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.portable.AbstractProducer;
import org.apache.webbeans.util.GenericsUtil;

public class EventProducer<T>
extends AbstractProducer<Event<T>> {
    private WebBeansContext webBeansContext;

    public EventProducer(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    @Override
    protected List<Decorator<?>> filterDecorators(Event<T> instance, List<Decorator<?>> decorators) {
        if (!EventImpl.class.isInstance(instance)) {
            return decorators;
        }
        Type type = ((EventImpl)EventImpl.class.cast(instance)).getMetadata().getType();
        ArrayList list = new ArrayList(decorators.size());
        for (Decorator<?> original : decorators) {
            ParameterizedType arg;
            Type[] actualTypeArguments;
            Type event = original.getDelegateType();
            if (!ParameterizedType.class.isInstance(event) || (actualTypeArguments = (arg = (ParameterizedType)ParameterizedType.class.cast(event)).getActualTypeArguments()).length <= 0 || !GenericsUtil.isAssignableFrom(true, false, actualTypeArguments[0], type, new HashMap<Type, Integer>())) continue;
            list.add(original);
        }
        return list;
    }

    @Override
    protected Event<T> produce(Map<Interceptor<?>, ?> interceptors, CreationalContextImpl<Event<T>> creationalContext) {
        EventImpl instance = null;
        InjectionPoint injectionPoint = creationalContext.getInjectionPoint();
        if (injectionPoint != null) {
            Type type = injectionPoint.getType();
            ParameterizedType pt = (ParameterizedType)type;
            Type[] eventActualTypeArgs = pt.getActualTypeArguments();
            Type eventType = eventActualTypeArgs[0];
            Annotation[] qualifiers = new Annotation[injectionPoint.getQualifiers().size()];
            qualifiers = injectionPoint.getQualifiers().toArray(qualifiers);
            try {
                instance = new EventImpl(new EventMetadataImpl(null, eventType, injectionPoint, qualifiers, this.webBeansContext), this.webBeansContext);
            }
            catch (Exception e) {
                throw new WebBeansException("Exception in creating Event implicit component for event type : " + eventType);
            }
            finally {
                creationalContext.removeInjectionPoint();
            }
        }
        return instance;
    }
}

