/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable.events;

import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.ProcessInjectionPoint;
import jakarta.enterprise.inject.spi.configurator.InjectionPointConfigurator;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.configurator.InjectionPointConfiguratorImpl;
import org.apache.webbeans.portable.events.AfterObserver;
import org.apache.webbeans.portable.events.EventBase;

public class ProcessInjectionPointImpl<T, X>
extends EventBase
implements ProcessInjectionPoint<T, X>,
AfterObserver {
    private boolean set;
    private InjectionPoint injectionPoint;
    private InjectionPointConfiguratorImpl injectionPointConfigurator;

    public ProcessInjectionPointImpl(InjectionPoint injectionPoint) {
        this.injectionPoint = injectionPoint;
    }

    public InjectionPoint getInjectionPoint() {
        this.checkState();
        if (this.injectionPointConfigurator != null) {
            return this.injectionPointConfigurator.getInjectionPoint();
        }
        return this.injectionPoint;
    }

    public void setInjectionPoint(InjectionPoint injectionPoint) {
        this.checkState();
        if (this.injectionPointConfigurator != null) {
            throw new IllegalStateException("You can't set and configure the injection point at the same time");
        }
        this.set = true;
        this.injectionPoint = injectionPoint;
    }

    public void addDefinitionError(Throwable t) {
        this.checkState();
        WebBeansContext.getInstance().getBeanManagerImpl().getErrorStack().pushError(t);
    }

    public InjectionPointConfigurator configureInjectionPoint() {
        this.checkState();
        if (this.set) {
            throw new IllegalStateException("You can't set and configure the injection point at the same time");
        }
        if (this.injectionPointConfigurator == null) {
            this.injectionPointConfigurator = new InjectionPointConfiguratorImpl(this.injectionPoint);
        }
        return this.injectionPointConfigurator;
    }

    @Override
    public void afterObserver() {
        if (this.injectionPointConfigurator != null) {
            this.injectionPoint = this.injectionPointConfigurator.getInjectionPoint();
            this.injectionPointConfigurator = null;
        } else if (this.set) {
            this.set = false;
        }
    }
}

