/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance.metrics;

import io.smallrye.faulttolerance.SpecCompatibility;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.core.metrics.MeteredOperation;
import io.smallrye.faulttolerance.internal.InterceptionPoint;

public final class CdiMeteredOperationImpl
implements MeteredOperation {
    private final FaultToleranceOperation operation;
    private final InterceptionPoint interceptionPoint;
    private final SpecCompatibility specCompatibility;

    public CdiMeteredOperationImpl(FaultToleranceOperation operation, InterceptionPoint interceptionPoint, SpecCompatibility specCompatibility) {
        this.operation = operation;
        this.interceptionPoint = interceptionPoint;
        this.specCompatibility = specCompatibility;
    }

    public boolean isAsynchronous() {
        return this.specCompatibility.isOperationTrulyOrPseudoAsynchronous(this.operation);
    }

    public boolean hasBulkhead() {
        return this.operation.hasBulkhead();
    }

    public boolean hasCircuitBreaker() {
        return this.operation.hasCircuitBreaker();
    }

    public boolean hasFallback() {
        return this.operation.hasFallback();
    }

    public boolean hasRateLimit() {
        return this.operation.hasRateLimit();
    }

    public boolean hasRetry() {
        return this.operation.hasRetry();
    }

    public boolean hasTimeout() {
        return this.operation.hasTimeout();
    }

    public String name() {
        return this.operation.getName();
    }

    public Object cacheKey() {
        return this.interceptionPoint;
    }
}

