/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.myfaces.cdi.NonContextualKey;
import org.apache.myfaces.cdi.util.CDIUtils;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.cdi.view.ViewScopeContext;
import org.apache.myfaces.cdi.view.ViewScopeContextualStorageHolder;

public class ViewScopeCDIMap
implements Map<String, Object> {
    private String viewScopeId;
    private ContextualStorage storage;

    public ViewScopeCDIMap(String viewScopeId) {
        this.viewScopeId = viewScopeId;
    }

    private ContextualStorage getStorage() {
        if (this.storage != null && !this.storage.isActivated()) {
            this.storage = null;
        }
        if (this.storage == null) {
            FacesContext facesContext = FacesContext.getCurrentInstance();
            BeanManager beanManager = CDIUtils.getBeanManager(facesContext);
            ViewScopeContextualStorageHolder bean = CDIUtils.get(beanManager, ViewScopeContextualStorageHolder.class);
            this.storage = bean.getContextualStorage(this.viewScopeId);
        }
        return this.storage;
    }

    private Map<String, Object> getBeanNameToKeyMapping() {
        return this.getStorage().getBeanNameToKeyMapping();
    }

    private Map<Object, ContextualInstanceInfo<?>> getCreationalContextInstances() {
        return this.getStorage().getStorage();
    }

    public String getViewScopeId() {
        return this.viewScopeId;
    }

    @Override
    public int size() {
        return this.getBeanNameToKeyMapping().size();
    }

    @Override
    public boolean isEmpty() {
        return this.getBeanNameToKeyMapping().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getBeanNameToKeyMapping().containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value != null) {
            for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : this.getCreationalContextInstances().entrySet()) {
                if (entry.getValue() == null || !value.equals(entry.getValue().getContextualInstance())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Object get(Object key) {
        Object beanKey = this.getBeanNameToKeyMapping().get(key);
        if (beanKey != null) {
            ContextualInstanceInfo<?> info = this.getCreationalContextInstances().get(beanKey);
            return info == null ? null : info.getContextualInstance();
        }
        return null;
    }

    @Override
    public Object put(String key, Object value) {
        NonContextualKey beanKey = new NonContextualKey(key);
        this.getBeanNameToKeyMapping().put(key, beanKey);
        ContextualInstanceInfo<Object> info = new ContextualInstanceInfo<Object>();
        info.setContextualInstance(value);
        return this.getCreationalContextInstances().put(beanKey, info);
    }

    @Override
    public Object remove(Object key) {
        Object beanKey = this.getBeanNameToKeyMapping().remove(key);
        ContextualInstanceInfo<?> info = this.getCreationalContextInstances().remove(beanKey);
        return info == null ? null : info.getContextualInstance();
    }

    @Override
    public void putAll(Map<? extends String, ? extends Object> m) {
        for (Map.Entry<? extends String, ? extends Object> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ViewScopeContext.destroyAll(facesContext, this.viewScopeId);
    }

    @Override
    public Set<String> keySet() {
        return this.getBeanNameToKeyMapping().keySet();
    }

    @Override
    public Collection<Object> values() {
        ArrayList<Object> values = new ArrayList<Object>(this.getBeanNameToKeyMapping().size());
        for (Map.Entry<String, Object> entry : this.getBeanNameToKeyMapping().entrySet()) {
            ContextualInstanceInfo<?> info;
            if (entry.getValue() == null || (info = this.getCreationalContextInstances().get(entry.getValue())) == null) continue;
            values.add(info.getContextualInstance());
        }
        return values;
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        HashSet<Map.Entry<String, Object>> values = new HashSet<Map.Entry<String, Object>>();
        for (Map.Entry<String, Object> entry : this.getBeanNameToKeyMapping().entrySet()) {
            ContextualInstanceInfo<?> info;
            if (entry.getValue() == null || (info = this.getCreationalContextInstances().get(entry.getValue())) == null) continue;
            values.add(new EntryWrapper<String, Object>(entry));
        }
        return values;
    }

    private class EntryWrapper<String, Object>
    implements Map.Entry<String, Object> {
        private Map.Entry<String, Object> entry;

        public EntryWrapper(Map.Entry<String, Object> entry) {
            this.entry = entry;
        }

        @Override
        public String getKey() {
            return this.entry.getKey();
        }

        @Override
        public Object getValue() {
            ContextualInstanceInfo<?> info = ViewScopeCDIMap.this.getCreationalContextInstances().get(this.entry.getValue());
            return info == null ? null : (Object)info.getContextualInstance();
        }

        @Override
        public Object setValue(Object value) {
            ContextualInstanceInfo<Object> info = ViewScopeCDIMap.this.getCreationalContextInstances().get(this.entry.getValue());
            Object oldValue = null;
            if (info != null) {
                info.setContextualInstance(value);
            } else {
                info = new ContextualInstanceInfo();
                info.setContextualInstance(value);
                ViewScopeCDIMap.this.getCreationalContextInstances().put(this.entry.getValue(), info);
            }
            return oldValue;
        }
    }
}

