/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.renderkit.html.util;

import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.myfaces.renderkit.html.util.JavascriptContext;
import org.apache.myfaces.renderkit.html.util.JavascriptUtils;
import org.apache.myfaces.renderkit.html.util.ResourceUtils;

public final class HtmlJavaScriptUtils {
    private static final Logger log = Logger.getLogger(HtmlJavaScriptUtils.class.getName());
    private static final String FIRST_SUBMIT_SCRIPT_ON_PAGE = "org.apache.MyFaces.FIRST_SUBMIT_SCRIPT_ON_PAGE";

    public static void renderFormSubmitScript(FacesContext facesContext) throws IOException {
        if (facesContext.getPartialViewContext() != null && (facesContext.getPartialViewContext().isPartialRequest() || facesContext.getPartialViewContext().isAjaxRequest())) {
            return;
        }
        Map map = facesContext.getExternalContext().getRequestMap();
        Boolean firstScript = (Boolean)map.get(FIRST_SUBMIT_SCRIPT_ON_PAGE);
        if (firstScript == null || firstScript.equals(Boolean.TRUE)) {
            map.put(FIRST_SUBMIT_SCRIPT_ON_PAGE, Boolean.FALSE);
            HtmlJavaScriptUtils.renderFormSubmitScriptIfNecessary(facesContext);
        }
    }

    private static void renderFormSubmitScriptIfNecessary(FacesContext facesContext) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        ResourceUtils.renderDefaultJsfJsInlineIfNecessary(facesContext, writer);
    }

    public static void appendClearHiddenCommandFormParamsFunctionCall(StringBuilder buf, String formName) {
        HtmlJavaScriptUtils.appendClearHiddenCommandFormParamsFunctionCall(new JavascriptContext(buf, false), formName);
    }

    private static void appendClearHiddenCommandFormParamsFunctionCall(JavascriptContext context, String formName) {
        String functionName = HtmlJavaScriptUtils.getClearHiddenCommandFormParamsFunctionName(formName);
        if (formName == null) {
            context.prettyLine();
            context.append("var clearFn = ");
            context.append(functionName);
            context.append(";");
            context.prettyLine();
            context.append("if(typeof window[clearFn] =='function')");
            context.append("{");
            context.append("window[clearFn](formName);");
            context.append("}");
        } else {
            context.prettyLine();
            context.append("if(typeof window.");
            context.append(functionName);
            context.append("=='function')");
            context.append("{");
            context.append(functionName).append("('").append(formName).append("');");
            context.append("}");
        }
    }

    public static String getClearHiddenCommandFormParamsFunctionName(String formName) {
        char separatorChar = FacesContext.getCurrentInstance().getNamingContainerSeparatorChar();
        if (formName == null) {
            return "'clearFormHiddenParams_'+formName.replace(/-/g, '\\$" + separatorChar + "').replace(/" + separatorChar + "/g,'_')";
        }
        return JavascriptUtils.getValidJavascriptNameAsInRI("clearFormHiddenParams_" + formName.replace(separatorChar, '_'));
    }

    public static String getClearHiddenCommandFormParamsFunctionNameMyfacesLegacy(String formName) {
        return "clear_" + JavascriptUtils.getValidJavascriptName(formName, false);
    }
}

