/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.x509.tls.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.tls.CertificateNameOptions;
import org.opensaml.security.x509.tls.ClientTLSValidationConfiguration;
import org.opensaml.security.x509.tls.ClientTLSValidationConfigurationCriterion;
import org.opensaml.security.x509.tls.ClientTLSValidationParameters;
import org.opensaml.security.x509.tls.ClientTLSValidationParametersResolver;

public class BasicClientTLSValidationParametersResolver
implements ClientTLSValidationParametersResolver {
    @Nonnull
    public Iterable<ClientTLSValidationParameters> resolve(@Nullable CriteriaSet criteria) throws ResolverException {
        ClientTLSValidationParameters params = this.resolveSingle(criteria);
        if (params != null) {
            return CollectionSupport.singletonList((Object)params);
        }
        return CollectionSupport.emptyList();
    }

    @Nullable
    public ClientTLSValidationParameters resolveSingle(@Nullable CriteriaSet criteria) throws ResolverException {
        CriteriaSet localCriteria = (CriteriaSet)Constraint.isNotNull((Object)criteria, (String)"CriteriaSet was null");
        ClientTLSValidationParameters params = new ClientTLSValidationParameters();
        params.setX509TrustEngine(this.resolveTrustEngine(localCriteria));
        params.setCertificateNameOptions(this.resolveNameOptions(localCriteria));
        return params;
    }

    @Nullable
    protected TrustEngine<? super X509Credential> resolveTrustEngine(@Nonnull CriteriaSet criteria) {
        ClientTLSValidationConfigurationCriterion tlsCriterion = (ClientTLSValidationConfigurationCriterion)Constraint.isNotNull((Object)((ClientTLSValidationConfigurationCriterion)criteria.get(ClientTLSValidationConfigurationCriterion.class)), (String)"Resolver requires an instance of ClientTLSValidationConfigurationCriterion");
        for (ClientTLSValidationConfiguration config : tlsCriterion.getConfigurations()) {
            if (config.getX509TrustEngine() == null) continue;
            return config.getX509TrustEngine();
        }
        return null;
    }

    @Nullable
    protected CertificateNameOptions resolveNameOptions(@Nonnull CriteriaSet criteria) {
        ClientTLSValidationConfigurationCriterion tlsCriterion = (ClientTLSValidationConfigurationCriterion)Constraint.isNotNull((Object)((ClientTLSValidationConfigurationCriterion)criteria.get(ClientTLSValidationConfigurationCriterion.class)), (String)"Resolver requires an instance of ClientTLSValidationConfigurationCriterion");
        for (ClientTLSValidationConfiguration config : tlsCriterion.getConfigurations()) {
            if (config.getCertificateNameOptions() == null) continue;
            return config.getCertificateNameOptions();
        }
        return null;
    }
}

