/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import com.google.common.base.Strings;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.security.IdentifierGenerationStrategy;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.opensaml.saml.common.SAMLException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.common.profile.logic.DefaultNameIDPolicyPredicate;
import org.opensaml.saml.common.profile.logic.MetadataNameIdentifierFormatStrategy;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.opensaml.saml.saml2.profile.SAML2NameIDGenerator;
import org.slf4j.Logger;

public class AddNameIDToSubjects
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddNameIDToSubjects.class);
    @Nonnull
    private SAMLObjectBuilder<Subject> subjectBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(Subject.DEFAULT_ELEMENT_NAME);
    @Nonnull
    private SAMLObjectBuilder<NameID> nameIdBuilder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().ensureBuilder(NameID.DEFAULT_ELEMENT_NAME);
    private boolean overwriteExisting = true;
    @Nonnull
    private Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy = new MessageLookup(AuthnRequest.class).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, List<Assertion>> assertionsLookupStrategy = new AssertionStrategy();
    @Nonnull
    private Function<ProfileRequestContext, IdentifierGenerationStrategy> idGeneratorLookupStrategy = prc -> IdentifierGenerationStrategy.getInstance((IdentifierGenerationStrategy.ProviderType)IdentifierGenerationStrategy.ProviderType.SECURE);
    @Nullable
    private Function<ProfileRequestContext, String> issuerLookupStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> nameIDPolicyPredicate = new DefaultNameIDPolicyPredicate();
    @Nonnull
    private Function<ProfileRequestContext, List<String>> formatLookupStrategy;
    @NonnullAfterInit
    private SAML2NameIDGenerator generator;
    @NonnullBeforeExec
    private List<String> formats;
    @Nullable
    private String requiredFormat;
    @Nullable
    private AuthnRequest request;
    @NonnullBeforeExec
    private List<Assertion> assertions;
    @NonnullBeforeExec
    private IdentifierGenerationStrategy idGenerator;
    @Nullable
    private String issuerId;

    public AddNameIDToSubjects() throws ComponentInitializationException {
        ((DefaultNameIDPolicyPredicate)this.nameIDPolicyPredicate).setRequesterIdLookupStrategy((Function)new RequesterIdFromIssuerFunction());
        ((DefaultNameIDPolicyPredicate)this.nameIDPolicyPredicate).setObjectLookupStrategy((Function)new NameIDPolicyLookupFunction());
        ((DefaultNameIDPolicyPredicate)this.nameIDPolicyPredicate).initialize();
        this.formatLookupStrategy = new MetadataNameIdentifierFormatStrategy();
        this.formats = CollectionSupport.emptyList();
    }

    public void setOverwriteExisting(boolean flag) {
        this.checkSetterPreconditions();
        this.overwriteExisting = flag;
    }

    public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
        this.checkSetterPreconditions();
        this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
    }

    public void setAssertionsLookupStrategy(@Nonnull Function<ProfileRequestContext, List<Assertion>> strategy) {
        this.checkSetterPreconditions();
        this.assertionsLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Assertions lookup strategy cannot be null");
    }

    public void setIdentifierGeneratorLookupStrategy(@Nonnull Function<ProfileRequestContext, IdentifierGenerationStrategy> strategy) {
        this.checkSetterPreconditions();
        this.idGeneratorLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"IdentifierGenerationStrategy lookup strategy cannot be null");
    }

    public void setIssuerLookupStrategy(@Nullable Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.issuerLookupStrategy = strategy;
    }

    public void setNameIDPolicyPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.nameIDPolicyPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"NameIDPolicy predicate cannot be null");
    }

    public void setFormatLookupStrategy(@Nonnull Function<ProfileRequestContext, List<String>> strategy) {
        this.checkSetterPreconditions();
        this.formatLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Format lookup strategy cannot be null");
    }

    public void setNameIDGenerator(@Nullable SAML2NameIDGenerator theGenerator) {
        this.checkSetterPreconditions();
        this.generator = (SAML2NameIDGenerator)Constraint.isNotNull((Object)theGenerator, (String)"SAML2NameIDGenerator cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.generator == null) {
            throw new ComponentInitializationException("SAML2NameIDGenerator cannot be null");
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add NameID to outgoing Assertion Subjects", (Object)this.getLogPrefix());
        this.idGenerator = this.idGeneratorLookupStrategy.apply(profileRequestContext);
        if (this.idGenerator == null) {
            this.log.debug("{} No identifier generation strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (this.issuerLookupStrategy != null) {
            this.issuerId = this.issuerLookupStrategy.apply(profileRequestContext);
        }
        this.assertions = this.assertionsLookupStrategy.apply(profileRequestContext);
        if (this.assertions == null || this.assertions.isEmpty()) {
            this.log.debug("{} No assertions returned, nothing to do", (Object)this.getLogPrefix());
            return false;
        }
        if (!this.nameIDPolicyPredicate.test(profileRequestContext)) {
            this.log.debug("{} NameIDPolicy was unacceptable", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidNameIDPolicy");
            return false;
        }
        this.request = this.requestLookupStrategy.apply(profileRequestContext);
        this.requiredFormat = this.getRequiredFormat(profileRequestContext);
        if (this.requiredFormat != null) {
            this.formats = CollectionSupport.singletonList((Object)this.requiredFormat);
            this.log.debug("{} Request specified NameID format: {}", (Object)this.getLogPrefix(), (Object)this.requiredFormat);
        } else {
            this.formats = this.formatLookupStrategy.apply(profileRequestContext);
            if (this.formats == null || this.formats.isEmpty()) {
                this.log.debug("{} No candidate NameID formats, nothing to do", (Object)this.getLogPrefix());
                return false;
            }
            this.log.debug("{} Candidate NameID formats: {}", (Object)this.getLogPrefix(), this.formats);
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        NameID nameId = this.generateNameID(profileRequestContext);
        if (nameId == null) {
            if (this.requiredFormat != null) {
                this.log.warn("{} Request specified use of an unsupportable identifier format: {}", (Object)this.getLogPrefix(), (Object)this.requiredFormat);
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidNameIDPolicy");
            } else {
                this.log.debug("{} Unable to generate a NameID, leaving empty", (Object)this.getLogPrefix());
            }
            return;
        }
        int count = 0;
        for (Assertion assertion : this.assertions) {
            assert (assertion != null);
            Subject subject = this.getAssertionSubject(assertion);
            NameID existing = subject.getNameID();
            if (existing == null || this.overwriteExisting) {
                subject.setNameID(count > 0 ? this.cloneNameID(nameId) : nameId);
            }
            ++count;
        }
        if (count > 0) {
            this.log.debug("{} Added NameID to {} assertion subject(s)", (Object)this.getLogPrefix(), (Object)count);
        }
    }

    @Nullable
    private String getRequiredFormat(@Nonnull ProfileRequestContext profileRequestContext) {
        String format;
        NameIDPolicy policy;
        if (!(this.request == null || (policy = this.request.getNameIDPolicy()) == null || Strings.isNullOrEmpty((String)(format = policy.getFormat())) || "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified".equals(format) || "urn:oasis:names:tc:SAML:2.0:nameid-format:encrypted".equals(format))) {
            return format;
        }
        return null;
    }

    @Nullable
    private NameID generateNameID(@Nonnull ProfileRequestContext profileRequestContext) {
        for (String format : this.formats) {
            assert (format != null);
            this.log.debug("{} Trying to generate NameID with Format {}", (Object)this.getLogPrefix(), (Object)format);
            try {
                NameID nameId = this.generator.generate(profileRequestContext, format);
                if (nameId == null) continue;
                this.log.debug("{} Successfully generated NameID with Format {}", (Object)this.getLogPrefix(), (Object)format);
                return nameId;
            }
            catch (SAMLException e) {
                this.log.error("{} Error while generating NameID", (Object)this.getLogPrefix(), (Object)e);
            }
        }
        return null;
    }

    @Nonnull
    private Subject getAssertionSubject(@Nonnull Assertion assertion) {
        Subject subject = assertion.getSubject();
        if (subject != null) {
            return subject;
        }
        subject = (Subject)this.subjectBuilder.buildObject();
        assertion.setSubject(subject);
        return subject;
    }

    @Nonnull
    private NameID cloneNameID(@Nonnull NameID nameId) {
        NameID clone = (NameID)this.nameIdBuilder.buildObject();
        clone.setFormat(nameId.getFormat());
        clone.setNameQualifier(nameId.getNameQualifier());
        clone.setSPNameQualifier(nameId.getSPNameQualifier());
        clone.setSPProvidedID(nameId.getSPProvidedID());
        clone.setValue(nameId.getValue());
        return clone;
    }

    private class AssertionStrategy
    implements Function<ProfileRequestContext, List<Assertion>> {
        private AssertionStrategy() {
        }

        @Override
        @Nullable
        @Unmodifiable
        @NotLive
        public List<Assertion> apply(@Nullable ProfileRequestContext input) {
            MessageContext outboundContext;
            MessageContext messageContext = outboundContext = input != null ? input.getOutboundMessageContext() : null;
            if (outboundContext != null) {
                Object outboundMessage = outboundContext.getMessage();
                if (outboundMessage == null) {
                    Assertion ret = SAML2ActionSupport.buildAssertion((AbstractProfileAction)AddNameIDToSubjects.this, (IdentifierGenerationStrategy)AddNameIDToSubjects.this.idGenerator, (String)AddNameIDToSubjects.this.issuerId);
                    outboundContext.setMessage((Object)ret);
                    return CollectionSupport.singletonList((Object)ret);
                }
                if (outboundMessage instanceof Assertion) {
                    return CollectionSupport.singletonList((Object)((Assertion)outboundMessage));
                }
                if (outboundMessage instanceof Response) {
                    return ((Response)outboundMessage).getAssertions();
                }
            }
            return null;
        }
    }

    public static class RequesterIdFromIssuerFunction
    implements Function<ProfileRequestContext, String> {
        @Nonnull
        private Function<ProfileRequestContext, RequestAbstractType> requestLookupStrategy = new MessageLookup(RequestAbstractType.class).compose((Function)new InboundMessageContextLookup());

        public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, RequestAbstractType> strategy) {
            this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Request lookup strategy cannot be null");
        }

        @Override
        @Nullable
        public String apply(@Nullable ProfileRequestContext profileRequestContext) {
            Issuer issuer;
            RequestAbstractType request = this.requestLookupStrategy.apply(profileRequestContext);
            if (request != null && (issuer = request.getIssuer()) != null && (issuer.getFormat() == null || "urn:oasis:names:tc:SAML:2.0:nameid-format:entity".equals(issuer.getFormat()))) {
                return issuer.getValue();
            }
            return null;
        }
    }

    public static class NameIDPolicyLookupFunction
    implements Function<ProfileRequestContext, SAMLObject> {
        @Nonnull
        private Function<ProfileRequestContext, AuthnRequest> requestLookupStrategy = new MessageLookup(AuthnRequest.class).compose((Function)new InboundMessageContextLookup());

        public void setRequestLookupStrategy(@Nonnull Function<ProfileRequestContext, AuthnRequest> strategy) {
            this.requestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthnRequest lookup strategy cannot be null");
        }

        @Override
        @Nullable
        public SAMLObject apply(@Nullable ProfileRequestContext profileRequestContext) {
            AuthnRequest request = this.requestLookupStrategy.apply(profileRequestContext);
            if (request != null) {
                return request.getNameIDPolicy();
            }
            return null;
        }
    }
}

