/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.resource;

import org.apache.myfaces.resource.ResourceMetaImpl;

public class AliasResourceMetaImpl
extends ResourceMetaImpl {
    private final String _realResourceName;
    private final boolean _couldContainValueExpressions;
    private String resourceIdentifier = null;

    public AliasResourceMetaImpl(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String realResourceName, boolean couldContainValueExpressions) {
        this(prefix, libraryName, libraryVersion, resourceName, resourceVersion, realResourceName, couldContainValueExpressions, null);
    }

    public AliasResourceMetaImpl(String prefix, String libraryName, String libraryVersion, String resourceName, String resourceVersion, String realResourceName, boolean couldContainValueExpressions, String contractName) {
        super(prefix, libraryName, libraryVersion, resourceName, resourceVersion, contractName);
        this._realResourceName = realResourceName;
        this._couldContainValueExpressions = couldContainValueExpressions;
    }

    public String getRealResourceName() {
        return this._realResourceName;
    }

    @Override
    public String getResourceIdentifier() {
        if (this.resourceIdentifier == null) {
            StringBuilder builder = new StringBuilder();
            boolean firstSlashAdded = false;
            if (this.getLocalePrefix() != null && this.getLocalePrefix().length() > 0) {
                builder.append(this.getLocalePrefix());
                firstSlashAdded = true;
            }
            if (this.getLibraryName() != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this.getLibraryName());
                firstSlashAdded = true;
            }
            if (this.getLibraryVersion() != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this.getLibraryVersion());
                firstSlashAdded = true;
            }
            if (this.getRealResourceName() != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this.getRealResourceName());
                firstSlashAdded = true;
            }
            if (this.getResourceVersion() != null) {
                if (firstSlashAdded) {
                    builder.append('/');
                }
                builder.append(this.getResourceVersion());
                builder.append(this.getRealResourceName().substring(this.getRealResourceName().lastIndexOf(46)));
                firstSlashAdded = true;
            }
            this.resourceIdentifier = builder.toString();
        }
        return this.resourceIdentifier;
    }

    @Override
    public boolean couldResourceContainValueExpressions() {
        return this._couldContainValueExpressions;
    }
}

