/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core.io;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;

public class BoundedOutputStreamWriter
extends BufferedWriter {
    private final int bufferSize;
    private int writtenSinceLastFlush = 0;

    public BoundedOutputStreamWriter(OutputStream outputStream, Charset charset, int maxSize) {
        super(new OutputStreamWriter(outputStream, charset), maxSize);
        this.bufferSize = maxSize;
    }

    @Override
    public void write(String s, int off, int len) throws IOException {
        this.autoFlush();
        super.write(s, off, len);
        this.writtenSinceLastFlush += len;
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.autoFlush();
        super.write(cbuf, off, len);
        this.writtenSinceLastFlush += len;
    }

    @Override
    public void write(int c) throws IOException {
        this.autoFlush();
        super.write(c);
        ++this.writtenSinceLastFlush;
    }

    private void autoFlush() throws IOException {
        if (this.writtenSinceLastFlush >= this.bufferSize) {
            this.flush();
            this.writtenSinceLastFlush = 0;
        }
    }
}

