/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.opentelemetry.implementation.cdi;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.instrumentation.annotations.WithSpan;
import io.smallrye.opentelemetry.implementation.cdi.WithSpanInterceptor;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InterceptionType;
import jakarta.enterprise.inject.spi.Interceptor;
import jakarta.enterprise.inject.spi.Prioritized;
import jakarta.enterprise.util.AnnotationLiteral;
import jakarta.interceptor.InvocationContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

public class WithSpanInterceptorBean
implements Interceptor<WithSpanInterceptor>,
Prioritized {
    private final BeanManager beanManager;

    public WithSpanInterceptorBean(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Set<Annotation> getInterceptorBindings() {
        return Collections.singleton(WithSpanLiteral.INSTANCE);
    }

    public boolean intercepts(InterceptionType type) {
        return InterceptionType.AROUND_INVOKE.equals((Object)type);
    }

    public Object intercept(InterceptionType type, WithSpanInterceptor instance, InvocationContext invocationContext) throws Exception {
        return instance.span(invocationContext);
    }

    public Class<?> getBeanClass() {
        return WithSpanInterceptorBean.class;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public WithSpanInterceptor create(CreationalContext<WithSpanInterceptor> creationalContext) {
        Bean bean = this.beanManager.resolve(this.beanManager.getBeans(OpenTelemetry.class, new Annotation[0]));
        OpenTelemetry openTelemetry = (OpenTelemetry)this.beanManager.getReference(bean, OpenTelemetry.class, creationalContext);
        return new WithSpanInterceptor(openTelemetry);
    }

    public void destroy(WithSpanInterceptor instance, CreationalContext<WithSpanInterceptor> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.getBeanClass());
    }

    public Set<Annotation> getQualifiers() {
        return Collections.emptySet();
    }

    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    public String getName() {
        return this.getBeanClass().getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    public int getPriority() {
        return 100;
    }

    public static class WithSpanLiteral
    extends AnnotationLiteral<WithSpan>
    implements WithSpan {
        public static final WithSpanLiteral INSTANCE = new WithSpanLiteral();

        public String value() {
            return null;
        }

        public SpanKind kind() {
            return null;
        }
    }
}

