/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.util.ArrayList;
import java.util.List;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.sys.Container;

public class ContainerUtils {
    public static List<ContainerInfo> getContainerInfos(AppModule module, ConfigurationFactory configFactory) throws OpenEJBException {
        ArrayList<ContainerInfo> containerInfos = new ArrayList<ContainerInfo>();
        if (module.getContainers().isEmpty()) {
            return containerInfos;
        }
        String prefix = module.getModuleId() + "/";
        for (Container container : module.getContainers()) {
            if (container.getId() == null) {
                throw new IllegalStateException("a container can't get a null id: " + container.getType() + " from " + module.getModuleId());
            }
            if (!container.getId().startsWith(prefix)) {
                container.setId(prefix + container.getId());
            }
            ContainerInfo containerInfo = configFactory.createContainerInfo(container);
            containerInfo.originAppName = module.getModuleId();
            Object applicationWideProperty = containerInfo.properties.remove("ApplicationWide");
            if (applicationWideProperty != null) {
                containerInfo.applicationWide = Boolean.parseBoolean(applicationWideProperty.toString().trim());
            }
            containerInfos.add(containerInfo);
        }
        return containerInfos;
    }
}

