/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.util.TimeZone;
import org.hsqldb.DatabaseManager;
import org.hsqldb.DatabaseType;
import org.hsqldb.HsqlException;
import org.hsqldb.HsqlNameManager;
import org.hsqldb.ParserCommand;
import org.hsqldb.SchemaManager;
import org.hsqldb.Session;
import org.hsqldb.SessionManager;
import org.hsqldb.Statement;
import org.hsqldb.Table;
import org.hsqldb.TransactionManager;
import org.hsqldb.TransactionManager2PL;
import org.hsqldb.dbinfo.DatabaseInformation;
import org.hsqldb.error.Error;
import org.hsqldb.lib.FrameworkLogger;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.HsqlTimer;
import org.hsqldb.lib.List;
import org.hsqldb.lib.OrderedHashMap;
import org.hsqldb.map.BaseHashMap;
import org.hsqldb.map.ValuePool;
import org.hsqldb.persist.HsqlDatabaseProperties;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.persist.LobManager;
import org.hsqldb.persist.Logger;
import org.hsqldb.persist.PersistentStoreCollectionDatabase;
import org.hsqldb.result.Result;
import org.hsqldb.rights.GranteeManager;
import org.hsqldb.rights.User;
import org.hsqldb.rights.UserManager;
import org.hsqldb.types.Collation;

public class Database {
    int databaseID;
    HsqlNameManager.HsqlName databaseUniqueName;
    DatabaseType databaseType;
    private final String canonicalPath;
    public HsqlProperties urlProperties;
    private final String path;
    public Collation collation;
    public DatabaseInformation dbInfo;
    private volatile int dbState;
    public Logger logger;
    boolean databaseReadOnly;
    private boolean filesReadOnly;
    private boolean filesInJar;
    public int sqlAvgScale = 0;
    public boolean sqlRestrictExec = false;
    public boolean sqlCharLiteral = true;
    public boolean sqlConcatNulls = true;
    public boolean sqlConvertTruncate = true;
    public boolean sqlDoubleNaN = true;
    public boolean sqlEnforceTypes = false;
    public boolean sqlEnforceRefs = false;
    public boolean sqlEnforceSize = true;
    public boolean sqlEnforceNames = false;
    public boolean sqlEnforceTDCD = true;
    public boolean sqlEnforceTDCU = true;
    public boolean sqlIgnoreCase = false;
    public boolean sqlLiveObject = false;
    public boolean sqlLongvarIsLob = false;
    public boolean sqlLowerCaseIdentifier = false;
    public boolean sqlNullsFirst = true;
    public boolean sqlNullsOrder = true;
    public int sqlMaxRecursive = 256;
    public boolean sqlRegularNames = true;
    public boolean sqlSyntaxDb2 = false;
    public boolean sqlSyntaxMss = false;
    public boolean sqlSyntaxMys = false;
    public boolean sqlSyntaxOra = false;
    public boolean sqlSyntaxPgs = false;
    public boolean sqlSysIndexNames = false;
    public boolean sqlTranslateTTI = true;
    public boolean sqlTruncateTrailing = true;
    public boolean sqlUniqueNulls = true;
    public int recoveryMode = 0;
    private boolean isReferentialIntegrity = true;
    public HsqlDatabaseProperties databaseProperties;
    private final boolean shutdownOnNoConnection;
    int resultMaxMemoryRows;
    public UserManager userManager;
    public GranteeManager granteeManager;
    public HsqlNameManager nameManager;
    public SessionManager sessionManager;
    public TransactionManager txManager;
    public int defaultIsolationLevel = 2;
    public boolean txConflictRollback = true;
    public boolean txInterruptRollback = false;
    public SchemaManager schemaManager;
    public PersistentStoreCollectionDatabase persistentStoreCollection;
    public LobManager lobManager;
    public CheckpointRunner checkpointRunner;
    public TimeoutRunner timeoutRunner;
    Result updateZeroResult = Result.updateZeroResult;
    public static final int DATABASE_ONLINE = 1;
    public static final int DATABASE_OPENING = 2;
    public static final int DATABASE_CLOSING = 3;
    public static final int DATABASE_SHUTDOWN = 4;
    public static final int CLOSEMODE_IMMEDIATELY = 1;
    public static final int CLOSEMODE_NORMAL = 2;
    public static final int CLOSEMODE_COMPACT = 3;
    public static final int CLOSEMODE_SCRIPT = 4;

    Database(DatabaseType databaseType, String string, String string2, HsqlProperties hsqlProperties) {
        this.setState(4);
        this.databaseType = databaseType;
        this.path = string;
        this.canonicalPath = string2;
        this.urlProperties = hsqlProperties;
        if (this.databaseType == DatabaseType.DB_RES) {
            this.filesInJar = true;
            this.filesReadOnly = true;
        }
        this.logger = new Logger(this);
        this.shutdownOnNoConnection = this.urlProperties.isPropertyTrue("shutdown");
        this.recoveryMode = this.urlProperties.getIntegerProperty("recover", 0);
    }

    synchronized void open() {
        if (!this.isShutdown()) {
            return;
        }
        this.reopen();
    }

    void reopen() {
        this.setState(2);
        try {
            this.createObjectStructures();
            this.logger.open();
            boolean bl = this.logger.isNewDatabase;
            if (bl) {
                String string = this.urlProperties.getProperty("user", "SA");
                String string2 = this.urlProperties.getProperty("password", "");
                this.userManager.createFirstUser(string, string2);
                this.schemaManager.createPublicSchema();
                this.logger.checkpoint(null, false, false);
            }
            this.lobManager.open();
            this.dbInfo.setWithContent(true);
            this.checkpointRunner = new CheckpointRunner();
            this.timeoutRunner = new TimeoutRunner();
        }
        catch (Throwable throwable) {
            this.logger.logSevereEvent("could not reopen database", throwable);
            this.logger.close(1);
            this.logger.releaseLock();
            this.setState(4);
            this.clearStructures();
            DatabaseManager.removeDatabase(this);
            if (throwable instanceof HsqlException) {
                throw throwable;
            }
            throw Error.error(458, throwable);
        }
        this.setState(1);
    }

    void clearStructures() {
        if (this.schemaManager != null) {
            this.schemaManager.release();
        }
        if (this.checkpointRunner != null) {
            this.checkpointRunner.stop();
        }
        if (this.timeoutRunner != null) {
            this.timeoutRunner.stop();
        }
        this.lobManager = null;
        this.granteeManager = null;
        this.userManager = null;
        this.nameManager = null;
        this.schemaManager = null;
        this.sessionManager = null;
        this.dbInfo = null;
        this.checkpointRunner = null;
        this.timeoutRunner = null;
    }

    public void createObjectStructures() {
        this.nameManager = new HsqlNameManager(this);
        this.databaseUniqueName = this.nameManager.newHsqlName("", false, 0);
        this.lobManager = new LobManager(this);
        this.granteeManager = new GranteeManager(this);
        this.userManager = new UserManager(this);
        this.schemaManager = new SchemaManager(this);
        this.persistentStoreCollection = new PersistentStoreCollectionDatabase(this);
        this.isReferentialIntegrity = true;
        this.sessionManager = new SessionManager(this);
        this.collation = Collation.newDatabaseInstance();
        this.dbInfo = DatabaseInformation.newDatabaseInformation(this);
        this.txManager = new TransactionManager2PL(this);
        this.lobManager.createSchema();
        this.sessionManager.getSysLobSession().setSchema("SYSTEM_LOBS");
        this.schemaManager.setSchemaChangeTimestamp();
        this.schemaManager.createSystemTables();
    }

    public int getDatabaseID() {
        return this.databaseID;
    }

    public HsqlNameManager.HsqlName getName() {
        return this.databaseUniqueName;
    }

    public String getNameString() {
        return this.databaseUniqueName.name;
    }

    public void setDatabaseName(String string) {
        this.databaseUniqueName.rename(string, false);
    }

    public DatabaseType getType() {
        return this.databaseType;
    }

    public String getPath() {
        return this.path;
    }

    public HsqlNameManager.HsqlName getCatalogName() {
        return this.nameManager.getCatalogName();
    }

    public HsqlDatabaseProperties getProperties() {
        return this.databaseProperties;
    }

    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public boolean isReadOnly() {
        return this.databaseReadOnly;
    }

    boolean isShutdown() {
        return this.dbState == 4;
    }

    synchronized Session connect(String string, String string2, TimeZone timeZone) {
        if (this.getState() != 1) {
            throw Error.error(1301);
        }
        if (string.equalsIgnoreCase("SA")) {
            string = "SA";
        }
        User user = this.userManager.getUser(string, string2);
        Session session = this.sessionManager.newSession(this, user, this.databaseReadOnly, true, timeZone);
        return session;
    }

    public void setReadOnly() {
        this.databaseReadOnly = true;
        this.filesReadOnly = true;
    }

    public void setFilesReadOnly() {
        this.filesReadOnly = true;
    }

    public boolean isFilesReadOnly() {
        return this.filesReadOnly;
    }

    public boolean isFilesInJar() {
        return this.filesInJar;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public GranteeManager getGranteeManager() {
        return this.granteeManager;
    }

    public void setLiveObject(boolean bl) {
        this.sqlLiveObject = bl;
    }

    public void setReferentialIntegrity(boolean bl) {
        this.isReferentialIntegrity = bl;
    }

    public boolean isReferentialIntegrity() {
        return this.isReferentialIntegrity;
    }

    public int getResultMaxMemoryRows() {
        return this.resultMaxMemoryRows;
    }

    public void setResultMaxMemoryRows(int n) {
        this.resultMaxMemoryRows = n;
    }

    public void setRestrictExec(boolean bl) {
        this.sqlRestrictExec = bl;
    }

    public void setStrictNames(boolean bl) {
        this.sqlEnforceNames = bl;
    }

    public void setRegularNames(boolean bl) {
        this.sqlRegularNames = bl;
        this.nameManager.setSqlRegularNames(bl);
    }

    public void setStrictColumnSize(boolean bl) {
        this.sqlEnforceSize = bl;
    }

    public void setStrictReferences(boolean bl) {
        this.sqlEnforceRefs = bl;
    }

    public void setStrictTypes(boolean bl) {
        this.sqlEnforceTypes = bl;
    }

    public void setStrictTDCD(boolean bl) {
        this.sqlEnforceTDCD = bl;
    }

    public void setStrictTDCU(boolean bl) {
        this.sqlEnforceTDCU = bl;
    }

    public void setTranslateTTI(boolean bl) {
        this.sqlTranslateTTI = bl;
    }

    public void setNullsFirst(boolean bl) {
        this.sqlNullsFirst = bl;
    }

    public void setNullsOrder(boolean bl) {
        this.sqlNullsOrder = bl;
    }

    public void setCharacterLiteral(boolean bl) {
        this.sqlCharLiteral = bl;
    }

    public void setConcatNulls(boolean bl) {
        this.sqlConcatNulls = bl;
    }

    public void setUniqueNulls(boolean bl) {
        this.sqlUniqueNulls = bl;
    }

    public void setConvertTrunc(boolean bl) {
        this.sqlConvertTruncate = bl;
    }

    public void setTruncateTrailing(boolean bl) {
        this.sqlTruncateTrailing = bl;
    }

    public void setDoubleNaN(boolean bl) {
        this.sqlDoubleNaN = bl;
    }

    public void setAvgScale(int n) {
        this.sqlAvgScale = n;
    }

    public void setMaxRecursive(int n) {
        this.sqlMaxRecursive = n;
    }

    public void setLongVarIsLob(boolean bl) {
        this.sqlLongvarIsLob = bl;
    }

    public void setIgnoreCase(boolean bl) {
        this.sqlIgnoreCase = bl;
    }

    public void setSysIndexNames(boolean bl) {
        this.sqlSysIndexNames = bl;
    }

    public void setLowerCaseIndentifer(boolean bl) {
        this.sqlLowerCaseIdentifier = bl;
    }

    public void setSyntaxDb2(boolean bl) {
        this.sqlSyntaxDb2 = bl;
    }

    public void setSyntaxMss(boolean bl) {
        this.sqlSyntaxMss = bl;
    }

    public void setSyntaxMys(boolean bl) {
        this.sqlSyntaxMys = bl;
    }

    public void setSyntaxOra(boolean bl) {
        this.sqlSyntaxOra = bl;
    }

    public void setSyntaxPgs(boolean bl) {
        this.sqlSyntaxPgs = bl;
    }

    void closeIfLast() {
        if (this.sessionManager.isEmpty() && this.dbState == 1) {
            if (this.shutdownOnNoConnection) {
                try {
                    this.close(2);
                }
                catch (HsqlException hsqlException) {}
            } else {
                this.logger.synchLog();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(int n) {
        HsqlException hsqlException = null;
        Database database = this;
        synchronized (database) {
            if (this.getState() != 1) {
                return;
            }
            this.setState(3);
        }
        this.sessionManager.closeAllSessions();
        if (this.filesReadOnly) {
            n = 1;
        }
        boolean bl = this.logger.close(n);
        this.lobManager.close();
        this.sessionManager.close();
        try {
            if (bl && n == 3) {
                this.clearStructures();
                this.reopen();
                this.txManager.setSystemChangeNumber(this.txManager.getSystemChangeNumber() + 1L);
                this.setState(3);
                this.sessionManager.closeAllSessions();
                this.logger.close(2);
                this.lobManager.close();
                this.sessionManager.close();
            }
        }
        catch (Throwable throwable) {
            hsqlException = throwable instanceof HsqlException ? (HsqlException)throwable : Error.error(458, throwable);
        }
        this.logger.releaseLock();
        this.setState(4);
        this.clearStructures();
        DatabaseManager.removeDatabase(this);
        FrameworkLogger.clearLoggers("hsqldb.db." + this.getNameString());
        if (hsqlException != null) {
            throw hsqlException;
        }
    }

    private void setState(int n) {
        this.dbState = n;
    }

    int getState() {
        return this.dbState;
    }

    String getStateString() {
        int n = this.getState();
        switch (n) {
            case 3: {
                return "DATABASE_CLOSING";
            }
            case 1: {
                return "DATABASE_ONLINE";
            }
            case 2: {
                return "DATABASE_OPENING";
            }
            case 4: {
                return "DATABASE_SHUTDOWN";
            }
        }
        return "UNKNOWN";
    }

    public List<String> getSettingsSQLArray() {
        Object object;
        HsqlArrayList<String> hsqlArrayList = new HsqlArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.getCatalogName().name.equals("PUBLIC")) {
            object = this.getCatalogName().statementName;
            stringBuilder.append("ALTER CATALOG PUBLIC RENAME TO ").append((String)object);
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        hsqlArrayList.add(this.collation.getDatabaseCollationSQL());
        object = this.schemaManager.getTables("SYSTEM_LOBS");
        for (int i = 0; i < ((BaseHashMap)object).size(); ++i) {
            Table table = (Table)((OrderedHashMap)object).get(i);
            if (!table.isCached()) continue;
            stringBuilder.append("SET").append(' ').append("TABLE").append(' ').append(table.getName().getSchemaQualifiedStatementName()).append(' ').append("TYPE").append(' ').append("CACHED");
            hsqlArrayList.add(stringBuilder.toString());
            stringBuilder.setLength(0);
        }
        return hsqlArrayList;
    }

    public Result getScript(boolean bl) {
        Result result = Result.newSingleColumnResult("COMMAND");
        List<String> list = this.logger.getPropertiesSQLArray(bl);
        result.addRows(list);
        list = this.getSettingsSQLArray();
        result.addRows(list);
        list = this.granteeManager.getSQLArray();
        result.addRows(list);
        list = this.schemaManager.getSQLArray();
        result.addRows(list);
        list = this.schemaManager.getTableSpaceSQLArray();
        result.addRows(list);
        if (bl) {
            list = this.schemaManager.getIndexRootsSQLArray();
            result.addRows(list);
        }
        list = this.schemaManager.getTablePropsSQLArray(!bl);
        result.addRows(list);
        list = this.userManager.getAuthenticationSQLArray();
        result.addRows(list);
        list = this.userManager.getInitialSchemaSQLArray();
        result.addRows(list);
        list = this.granteeManager.getRightsSQLArray();
        result.addRows(list);
        return result;
    }

    public String getURI() {
        return this.databaseType.value() + this.canonicalPath;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public HsqlProperties getURLProperties() {
        return this.urlProperties;
    }

    public TimeoutRunner getTimeoutRunner() {
        return this.timeoutRunner;
    }

    static class TimeoutRunner
    implements Runnable {
        private Object timerTask;
        private HsqlArrayList<Session.TimeoutManager> timeoutList;
        int abortCount;

        TimeoutRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                TimeoutRunner timeoutRunner = this;
                synchronized (timeoutRunner) {
                    long l = System.currentTimeMillis();
                    for (int i = 0; i < this.timeoutList.size(); ++i) {
                        Session.TimeoutManager timeoutManager = this.timeoutList.get(i);
                        if (timeoutManager.isClosed()) {
                            this.timeoutList.remove(i);
                            --i;
                            continue;
                        }
                        boolean bl = timeoutManager.checkTimeout(l);
                        if (!bl) continue;
                        ++this.abortCount;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stop() {
            TimeoutRunner timeoutRunner = this;
            synchronized (timeoutRunner) {
                if (this.timerTask == null) {
                    return;
                }
                HsqlTimer.cancel(this.timerTask);
                this.timerTask = null;
                this.timeoutList = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSession(Session.TimeoutManager timeoutManager) {
            TimeoutRunner timeoutRunner = this;
            synchronized (timeoutRunner) {
                if (this.timerTask == null) {
                    this.start();
                }
                this.timeoutList.add(timeoutManager);
            }
        }

        private void start() {
            this.timeoutList = new HsqlArrayList();
            this.timerTask = DatabaseManager.getTimer().schedulePeriodicallyAfter(1000L, 1000L, this, true);
        }
    }

    class CheckpointRunner
    implements Runnable {
        private volatile boolean waiting;
        private Object timerTask;

        CheckpointRunner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Statement statement = ParserCommand.getAutoCheckpointStatement(Database.this);
            Session session = Database.this.sessionManager.newSysSession();
            try {
                session.executeCompiledStatement(statement, ValuePool.emptyObjectArray, 0);
            }
            catch (Throwable throwable) {
            }
            finally {
                try {
                    session.commit(false);
                    session.close();
                }
                catch (Throwable throwable) {}
                this.waiting = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void start() {
            CheckpointRunner checkpointRunner = this;
            synchronized (checkpointRunner) {
                if (this.waiting) {
                    return;
                }
                this.waiting = true;
            }
            this.timerTask = DatabaseManager.getTimer().scheduleAfter(0L, this);
        }

        public void stop() {
            HsqlTimer.cancel(this.timerTask);
            this.timerTask = null;
            this.waiting = false;
        }
    }
}

