/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.jakartaee.bcel.classfile;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.tomcat.jakartaee.bcel.classfile.Attribute;
import org.apache.tomcat.jakartaee.bcel.classfile.ConstantPool;
import org.apache.tomcat.jakartaee.bcel.classfile.RecordComponentInfo;
import org.apache.tomcat.jakartaee.bcel.classfile.Visitor;
import org.apache.tomcat.jakartaee.bcel.util.Args;

public final class Record
extends Attribute {
    private static final RecordComponentInfo[] EMPTY_RCI_ARRAY = new RecordComponentInfo[0];
    private RecordComponentInfo[] components;

    private static RecordComponentInfo[] readComponents(DataInput input, ConstantPool constantPool) throws IOException {
        int classCount = input.readUnsignedShort();
        RecordComponentInfo[] components = new RecordComponentInfo[classCount];
        for (int i = 0; i < classCount; ++i) {
            components[i] = new RecordComponentInfo(input, constantPool);
        }
        return components;
    }

    Record(int nameIndex, int length, DataInput input, ConstantPool constantPool) throws IOException {
        this(nameIndex, length, Record.readComponents(input, constantPool), constantPool);
    }

    public Record(int nameIndex, int length, RecordComponentInfo[] classes, ConstantPool constantPool) {
        super((byte)27, nameIndex, length, constantPool);
        this.components = classes != null ? classes : EMPTY_RCI_ARRAY;
        Args.requireU2(this.components.length, "attributes.length");
    }

    @Override
    public void accept(Visitor v) {
        v.visitRecord(this);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        Record c = (Record)this.clone();
        if (this.components.length > 0) {
            c.components = (RecordComponentInfo[])this.components.clone();
        }
        c.setConstantPool(constantPool);
        return c;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.components.length);
        for (RecordComponentInfo component : this.components) {
            component.dump(file);
        }
    }

    public RecordComponentInfo[] getComponents() {
        return this.components;
    }

    @Override
    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Record(");
        buf.append(this.components.length);
        buf.append("):\n");
        for (RecordComponentInfo component : this.components) {
            buf.append("  ").append(component.toString()).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }
}

