/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.shared.net;

import com.google.common.base.Strings;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.net.URLBuilder;
import net.shibboleth.shared.primitive.StringSupport;

public final class SimpleURLCanonicalizer {
    @Nonnull
    private static final Map<String, Integer> SCHEME_PORT_MAP = new HashMap<String, Integer>();

    private SimpleURLCanonicalizer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerSchemePortMapping(@Nonnull @NotEmpty String scheme, @Nonnull Integer port) {
        String trimmedScheme = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)scheme), (String)"Scheme cannot be null");
        Constraint.isNotNull((Object)port, (String)"Port cannot be null");
        Map<String, Integer> map = SCHEME_PORT_MAP;
        synchronized (map) {
            SCHEME_PORT_MAP.put(trimmedScheme.toLowerCase(), port);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deregisterSchemePortMapping(@Nonnull String scheme) {
        String trimmedScheme = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)scheme), (String)"Scheme cannot be null");
        Map<String, Integer> map = SCHEME_PORT_MAP;
        synchronized (map) {
            SCHEME_PORT_MAP.remove(trimmedScheme.toLowerCase());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Integer getRegisteredPort(@Nonnull @NotEmpty String scheme) {
        String trimmedScheme = (String)Constraint.isNotNull((Object)StringSupport.trimOrNull((String)scheme), (String)"Scheme cannot be null");
        Map<String, Integer> map = SCHEME_PORT_MAP;
        synchronized (map) {
            return SCHEME_PORT_MAP.get(trimmedScheme.toLowerCase());
        }
    }

    @Nonnull
    @NotEmpty
    public static String canonicalize(@Nonnull @NotEmpty String url) throws MalformedURLException {
        Constraint.isFalse((boolean)Strings.isNullOrEmpty((String)url), (String)"URL was null or empty");
        URLBuilder urlBuilder = new URLBuilder(url);
        SimpleURLCanonicalizer.canonicalize(urlBuilder);
        return Constraint.isNotEmpty((String)urlBuilder.buildURL(), (String)"Canonical URL was null");
    }

    private static void canonicalize(@Nonnull URLBuilder url) {
        String host;
        String scheme = url.getScheme();
        if (scheme != null) {
            scheme = scheme.toLowerCase();
            url.setScheme(scheme);
            assert (scheme != null);
            Integer port = SimpleURLCanonicalizer.getRegisteredPort(scheme);
            if (port != null && port.equals(url.getPort())) {
                url.setPort(null);
            }
        }
        if ((host = url.getHost()) != null) {
            url.setHost(host.toLowerCase());
        }
    }

    static {
        SimpleURLCanonicalizer.registerSchemePortMapping("ftp", 23);
        SimpleURLCanonicalizer.registerSchemePortMapping("http", 80);
        SimpleURLCanonicalizer.registerSchemePortMapping("https", 443);
        SimpleURLCanonicalizer.registerSchemePortMapping("ldap", 389);
        SimpleURLCanonicalizer.registerSchemePortMapping("ldaps", 636);
    }
}

