/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batchee.container.services.executor;

import java.util.Properties;
import java.util.concurrent.ExecutorService;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.batchee.container.exception.BatchContainerServiceException;
import org.apache.batchee.container.util.ClassLoaderAwareHandler;
import org.apache.batchee.spi.BatchThreadPoolService;

public class JNDIThreadPoolService
implements BatchThreadPoolService {
    public static final String THREADPOOL_JNDI_LOCATION = "thread-pool.jndi";
    public final String DEFAULT_JNDI_LOCATION = "java:comp/DefaultManagedExecutorService";
    private String jndiLocation = null;

    @Override
    public void init(Properties batchConfig) {
        this.jndiLocation = batchConfig.getProperty(THREADPOOL_JNDI_LOCATION, "java:comp/DefaultManagedExecutorService");
    }

    @Override
    public void executeTask(Runnable work, Object config) {
        try {
            InitialContext ctx = new InitialContext();
            ExecutorService delegateService = (ExecutorService)ctx.lookup(this.jndiLocation);
            delegateService.execute(ClassLoaderAwareHandler.runnableLoaderAware(work));
        }
        catch (NamingException e) {
            throw new BatchContainerServiceException(e);
        }
    }

    @Override
    public void shutdown() {
    }
}

