/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey;

import io.churchkey.InvalidPrivateKeySpecException;
import io.churchkey.InvalidPublicKeySpecException;
import io.churchkey.UnsupportedAlgorithmException;
import io.churchkey.dsa.Dsa;
import io.churchkey.jwk.JwkParser;
import io.churchkey.pem.PemParser;
import io.churchkey.rsa.Rsa;
import io.churchkey.ssh.OpenSSHParser;
import io.churchkey.ssh.SSH2Parser;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Key {
    private final java.security.Key key;
    private final Type type;
    private final Algorithm algorithm;
    private final Format format;
    private final Map<String, String> attributes = new HashMap<String, String>();
    private final Key publicKey;

    public Key(java.security.Key key, PublicKey publicKey, Type type, Algorithm algorithm, Format format) {
        this(key, publicKey, type, algorithm, format, new HashMap<String, String>());
    }

    public Key(java.security.Key key, Type type, Algorithm algorithm, Format format) {
        this(key, type, algorithm, format, new HashMap<String, String>());
    }

    public Key(java.security.Key key, Type type, Algorithm algorithm, Format format, Map<String, String> attributes) {
        this(key, null, type, algorithm, format, attributes);
    }

    public Key(java.security.Key key, PublicKey publicKey, Type type, Algorithm algorithm, Format format, Map<String, String> attributes) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(type);
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(format);
        Objects.requireNonNull(attributes);
        this.key = key;
        this.type = type;
        this.algorithm = algorithm;
        this.format = format;
        this.attributes.putAll(attributes);
        this.publicKey = this.publicKey(key, publicKey, algorithm, format, attributes);
    }

    private Key publicKey(java.security.Key key, PublicKey publicKey, Algorithm algorithm, Format format, Map<String, String> attributes) {
        if (!(key instanceof PrivateKey)) {
            return null;
        }
        if (publicKey == null) {
            if (algorithm == Algorithm.RSA && key instanceof RSAPrivateCrtKey) {
                RSAPrivateCrtKey rsaPrivateCrtKey = (RSAPrivateCrtKey)key;
                publicKey = Rsa.Public.builder().publicExponent(rsaPrivateCrtKey.getPublicExponent()).modulus(rsaPrivateCrtKey.getModulus()).build().toKey();
            } else if (algorithm == Algorithm.DSA && key instanceof DSAPrivateKey) {
                DSAPrivateKey privateKey = (DSAPrivateKey)key;
                publicKey = Dsa.Private.builder().x(privateKey.getX()).p(privateKey.getParams().getP()).g(privateKey.getParams().getG()).q(privateKey.getParams().getQ()).build().toPublic().toKey();
            }
        }
        if (publicKey != null) {
            return new Key((java.security.Key)publicKey, Type.PUBLIC, algorithm, format, attributes);
        }
        return null;
    }

    public Key getPublicKey() {
        if (this.type == Type.PRIVATE) {
            return this.publicKey;
        }
        throw new IllegalStateException((Object)((Object)this.type) + " keys do not have public keys");
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public String getAttribute(String name) {
        return this.attributes.get(name);
    }

    public boolean hasAttribute(String name) {
        return this.attributes.containsKey(name);
    }

    public java.security.Key getKey() {
        return this.key;
    }

    public Type getType() {
        return this.type;
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public Format getFormat() {
        return this.format;
    }

    public byte[] encode(Format format) {
        return format.encode(this);
    }

    public String toJwk() {
        return new String(this.encode(Format.JWK), StandardCharsets.UTF_8);
    }

    public String toJwks() {
        return new String(Format.JWK.encodeSet(Collections.singletonList(this)), StandardCharsets.UTF_8);
    }

    public String toPem() {
        return new String(this.encode(Format.PEM), StandardCharsets.UTF_8);
    }

    public String toOpenSsh() {
        return new String(this.encode(Format.OPENSSH), StandardCharsets.UTF_8);
    }

    public String toSsh2() {
        return new String(this.encode(Format.SSH2), StandardCharsets.UTF_8);
    }

    public static class Factory {
        private final KeyFactory keyFactory;

        public Factory(KeyFactory keyFactory) {
            this.keyFactory = keyFactory;
        }

        public PublicKey generatePublic(KeySpec keySpec) {
            try {
                return this.keyFactory.generatePublic(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidPublicKeySpecException(keySpec, e);
            }
        }

        public PrivateKey generatePrivate(KeySpec keySpec) {
            try {
                return this.keyFactory.generatePrivate(keySpec);
            }
            catch (InvalidKeySpecException e) {
                throw new InvalidPrivateKeySpecException(keySpec, e);
            }
        }
    }

    public static enum Format {
        JWK(new JwkParser()),
        OPENSSH(new OpenSSHParser()),
        SSH2(new SSH2Parser()),
        PEM(new PemParser());

        private final Parser parser;

        private Format(Parser parser) {
            this.parser = parser;
        }

        public byte[] encode(Key key) {
            return this.parser.encode(key);
        }

        public Key decode(byte[] bytes) {
            return this.parser.decode(bytes);
        }

        public List<Key> decodeSet(byte[] bytes) {
            return this.parser.decodeSet(bytes);
        }

        public byte[] encodeSet(List<Key> keys) {
            return this.parser.encodeSet(keys);
        }

        public static interface Parser {
            public Key decode(byte[] var1);

            public byte[] encode(Key var1);

            default public List<Key> decodeSet(byte[] bytes) {
                Key key = this.decode(bytes);
                if (key == null) {
                    return null;
                }
                return Collections.singletonList(key);
            }

            default public byte[] encodeSet(List<Key> keys) {
                if (keys.size() == 0) {
                    throw new IllegalArgumentException("No keys to encode");
                }
                if (keys.size() > 1) {
                    throw new UnsupportedOperationException("Encoding multiple keys not supported for by this parser: " + this.getClass().getName());
                }
                return this.encode(keys.get(0));
            }
        }
    }

    public static enum Algorithm {
        RSA,
        DSA,
        EC,
        OCT;


        public Factory getKeyFactory() {
            if (this == OCT) {
                throw new UnsupportedOperationException();
            }
            try {
                return new Factory(KeyFactory.getInstance(this.name()));
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedAlgorithmException(this, (Throwable)e);
            }
        }
    }

    public static enum Type {
        PUBLIC,
        PRIVATE,
        SECRET;

    }
}

