/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geronimo.mail.handlers;

import jakarta.activation.ActivationDataFlavor;
import jakarta.activation.DataContentHandler;
import jakarta.activation.DataSource;
import jakarta.mail.Message;
import jakarta.mail.MessageAware;
import jakarta.mail.MessageContext;
import jakarta.mail.MessagingException;
import jakarta.mail.Session;
import jakarta.mail.internet.MimeMessage;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;

public class RFC822MessageHandler
implements DataContentHandler {
    protected final ActivationDataFlavor flavour = new ActivationDataFlavor(Message.class, "message/rfc822", "Message");

    public ActivationDataFlavor[] getTransferDataFlavors() {
        return new ActivationDataFlavor[]{this.flavour};
    }

    public Object getTransferData(ActivationDataFlavor df, DataSource ds) throws IOException {
        return this.flavour.equals(df) ? this.getContent(ds) : null;
    }

    public Object getContent(DataSource ds) throws IOException {
        try {
            if (ds instanceof MessageAware) {
                MessageContext context = ((MessageAware)ds).getMessageContext();
                return new MimeMessage(context.getSession(), ds.getInputStream());
            }
            return new MimeMessage(Session.getDefaultInstance((Properties)new Properties(), null), ds.getInputStream());
        }
        catch (MessagingException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public void writeTo(Object obj, String mimeType, OutputStream os) throws IOException {
        if (obj instanceof Message) {
            Message message = (Message)obj;
            try {
                message.writeTo(os);
            }
            catch (MessagingException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
    }
}

