/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.cdi.view;

import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Context;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Typed;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.faces.context.FacesContext;
import java.lang.annotation.Annotation;
import java.util.Map;
import org.apache.myfaces.cdi.util.ContextualInstanceInfo;
import org.apache.myfaces.cdi.util.ContextualStorage;
import org.apache.myfaces.cdi.view.ViewTransientScoped;

@Typed
public class ViewTransientScopeContext
implements Context {
    public static final String VIEW_TRANSIENT_SCOPED_STORAGE = "oam.VIEW_TRANSIENT_SCOPED_STORAGE";
    private BeanManager beanManager;

    public ViewTransientScopeContext(BeanManager beanManager) {
        this.beanManager = beanManager;
    }

    public Class<? extends Annotation> getScope() {
        return ViewTransientScoped.class;
    }

    public boolean isActive() {
        return this.isActive(FacesContext.getCurrentInstance());
    }

    public boolean isActive(FacesContext facesContext) {
        if (facesContext == null) {
            return false;
        }
        return facesContext.getViewRoot() != null;
    }

    public <T> T get(Contextual<T> bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        if (facesContext != null) {
            Map<Object, ContextualInstanceInfo<?>> contextMap;
            ContextualInstanceInfo<?> contextualInstanceInfo;
            ContextualStorage storage = this.getContextualStorage(false, facesContext);
            if (storage != null && (contextualInstanceInfo = (contextMap = storage.getStorage()).get(storage.getBeanKey(bean))) != null) {
                return (T)contextualInstanceInfo.getContextualInstance();
            }
        } else {
            throw new IllegalStateException("FacesContext cannot be found when resolving bean " + bean.toString());
        }
        return null;
    }

    public <T> T get(Contextual<T> bean, CreationalContext<T> creationalContext) {
        Object instance;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        this.checkActive(facesContext);
        ContextualStorage storage = this.getContextualStorage(true, facesContext);
        Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
        ContextualInstanceInfo<?> contextualInstanceInfo = contextMap.get(storage.getBeanKey(bean));
        if (contextualInstanceInfo != null && (instance = contextualInstanceInfo.getContextualInstance()) != null) {
            return (T)instance;
        }
        return storage.createContextualInstance(bean, creationalContext);
    }

    protected ContextualStorage getContextualStorage(boolean createIfNotExist, FacesContext facesContext) {
        ContextualStorage contextualStorage = (ContextualStorage)facesContext.getViewRoot().getTransientStateHelper().getTransient((Object)VIEW_TRANSIENT_SCOPED_STORAGE);
        if (contextualStorage == null && createIfNotExist) {
            contextualStorage = new ContextualStorage(this.beanManager, false, false);
            facesContext.getViewRoot().getTransientStateHelper().putTransient((Object)VIEW_TRANSIENT_SCOPED_STORAGE, (Object)contextualStorage);
        }
        return contextualStorage;
    }

    protected void checkActive(FacesContext facesContext) {
        if (!this.isActive(facesContext)) {
            throw new ContextNotActiveException("CDI context with scope annotation @" + this.getScope().getName() + " is not active with respect to the current thread");
        }
    }

    public boolean destroy(Contextual bean) {
        FacesContext facesContext = FacesContext.getCurrentInstance();
        ContextualStorage storage = this.getContextualStorage(false, facesContext);
        if (storage == null) {
            return false;
        }
        ContextualInstanceInfo<?> contextualInstanceInfo = storage.getStorage().get(storage.getBeanKey(bean));
        if (contextualInstanceInfo == null) {
            return false;
        }
        bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
        return true;
    }

    public static void destroyAll(FacesContext facesContext) {
        if (facesContext == null || facesContext.getViewRoot() == null) {
            return;
        }
        ContextualStorage storage = (ContextualStorage)facesContext.getViewRoot().getTransientStateHelper().putTransient((Object)VIEW_TRANSIENT_SCOPED_STORAGE, null);
        if (storage != null) {
            Map<Object, ContextualInstanceInfo<?>> contextMap = storage.getStorage();
            for (Map.Entry<Object, ContextualInstanceInfo<?>> entry : contextMap.entrySet()) {
                Contextual<?> bean = storage.getBean(entry.getKey());
                ContextualInstanceInfo<?> contextualInstanceInfo = entry.getValue();
                bean.destroy(contextualInstanceInfo.getContextualInstance(), contextualInstanceInfo.getCreationalContext());
            }
        }
    }
}

