/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.view.facelets;

import jakarta.faces.FactoryFinder;
import jakarta.faces.component.NamingContainer;
import jakarta.faces.component.UIComponent;
import jakarta.faces.component.UIComponentBase;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.faces.render.RenderKit;
import jakarta.faces.render.RenderKitFactory;
import jakarta.faces.render.ResponseStateManager;
import jakarta.faces.view.StateManagementStrategy;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.myfaces.application.TreeStructureManager;
import org.apache.myfaces.application.viewstate.StateCacheUtils;
import org.apache.myfaces.context.RequestViewContext;
import org.apache.myfaces.core.api.shared.ComponentUtils;

public class FullStateManagementStrategy
extends StateManagementStrategy {
    private static final Logger LOG = Logger.getLogger(FullStateManagementStrategy.class.getName());
    private RenderKitFactory renderKitFactory;
    public static final String SERIALIZED_VIEW_REQUEST_ATTR = FullStateManagementStrategy.class.getName() + ".SERIALIZED_VIEW";

    public FullStateManagementStrategy(FacesContext context) {
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        Object[] stateArray;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Entering restoreView - viewId: " + viewId + " ; renderKitId: " + renderKitId);
        }
        UIViewRoot uiViewRoot = null;
        RenderKit renderKit = this.getRenderKitFactory().getRenderKit(context, renderKitId);
        ResponseStateManager responseStateManager = renderKit.getResponseStateManager();
        Object state = responseStateManager.getState(context, viewId);
        if (state != null && (uiViewRoot = TreeStructureManager.restoreTreeStructure(((Object[])(stateArray = (Object[])state)[0])[0])) != null) {
            context.setViewRoot(uiViewRoot);
            uiViewRoot.processRestoreState(context, stateArray[1]);
            RequestViewContext.getCurrentInstance(context).refreshRequestViewContext(context, uiViewRoot);
            Object rlc = ((Object[])stateArray[0])[1];
            if (rlc != null) {
                context.setResourceLibraryContracts((List)UIComponentBase.restoreAttachedState((FacesContext)context, (Object)rlc));
            }
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Exiting restoreView - " + viewId);
        }
        return uiViewRoot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object saveView(FacesContext facesContext) {
        UIViewRoot uiViewRoot = facesContext.getViewRoot();
        if (uiViewRoot.isTransient()) {
            return null;
        }
        Object[] serializedView = null;
        ResponseStateManager responseStateManager = facesContext.getRenderKit().getResponseStateManager();
        try {
            facesContext.getAttributes().put("jakarta.faces.IS_SAVING_STATE", Boolean.TRUE);
            if (uiViewRoot.isTransient()) {
                Object var5_5 = null;
                return var5_5;
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Entering saveSerializedView");
            }
            FullStateManagementStrategy.checkForDuplicateIds(facesContext, (UIComponent)facesContext.getViewRoot(), new HashSet<String>());
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Processing saveSerializedView - Checked for duplicate Ids");
            }
            if ((serializedView = (Object[])facesContext.getAttributes().get(SERIALIZED_VIEW_REQUEST_ATTR)) == null) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Processing saveSerializedView - create new serialized view");
                }
                Object treeStruct = this.getTreeStructureToSave(facesContext);
                Object compStates = this.getComponentStateToSave(facesContext);
                Object rlcStates = !facesContext.getResourceLibraryContracts().isEmpty() ? UIComponentBase.saveAttachedState((FacesContext)facesContext, new ArrayList(facesContext.getResourceLibraryContracts())) : null;
                serializedView = new Object[]{new Object[]{treeStruct, rlcStates}, compStates};
                facesContext.getAttributes().put(SERIALIZED_VIEW_REQUEST_ATTR, serializedView);
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Processing saveSerializedView - new serialized view created");
                }
            }
            if (StateCacheUtils.isMyFacesResponseStateManager(responseStateManager)) {
                StateCacheUtils.getMyFacesResponseStateManager(responseStateManager).saveState(facesContext, serializedView);
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.finest("Exiting saveView");
            }
        }
        finally {
            facesContext.getAttributes().remove("jakarta.faces.IS_SAVING_STATE");
        }
        return serializedView;
    }

    private static void checkForDuplicateIds(FacesContext context, UIComponent component, Set<String> ids) {
        String id = component.getId();
        if (id != null && !ids.add(id)) {
            throw new IllegalStateException("Client-id : " + id + " is duplicated in the faces tree. Component : " + component.getClientId(context) + ", path: " + ComponentUtils.getPathToComponent((UIComponent)component));
        }
        if (component instanceof NamingContainer) {
            ids = new HashSet<String>();
        }
        if (component.getFacetCount() > 0) {
            for (UIComponent facet : component.getFacets().values()) {
                FullStateManagementStrategy.checkForDuplicateIds(context, facet, ids);
            }
        }
        int childCount = component.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            UIComponent child = (UIComponent)component.getChildren().get(i);
            FullStateManagementStrategy.checkForDuplicateIds(context, child, ids);
        }
    }

    protected RenderKitFactory getRenderKitFactory() {
        if (this.renderKitFactory == null) {
            this.renderKitFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"jakarta.faces.render.RenderKitFactory");
        }
        return this.renderKitFactory;
    }

    protected Object getComponentStateToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Entering getComponentStateToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        Object serializedComponentStates = viewRoot.processSaveState(facesContext);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Exiting getComponentStateToSave");
        }
        return serializedComponentStates;
    }

    protected Object getTreeStructureToSave(FacesContext facesContext) {
        UIViewRoot viewRoot;
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Entering getTreeStructureToSave");
        }
        if ((viewRoot = facesContext.getViewRoot()).isTransient()) {
            return null;
        }
        Object retVal = TreeStructureManager.buildTreeStructureToSave(viewRoot);
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("Exiting getTreeStructureToSave");
        }
        return retVal;
    }
}

