/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.util;

import java.lang.reflect.InvocationTargetException;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.bval.util.ObjectWrapper;

public class Exceptions {
    public static <E extends Exception> E create(Function<? super String, ? extends E> fn, String format, Object ... args) {
        return Exceptions.create(fn, () -> String.format(format, args));
    }

    public static <E extends Exception, C extends Throwable> E create(BiFunction<? super String, ? super C, ? extends E> fn, C cause, String format, Object ... args) {
        return Exceptions.create(fn, cause, () -> String.format(format, args));
    }

    public static <E extends Exception> E create(Function<? super String, ? extends E> fn, Supplier<String> message) {
        return (E)Exceptions.elideStackTrace((Exception)fn.apply(message.get()));
    }

    public static <E extends Exception, C extends Throwable> E create(BiFunction<? super String, ? super C, ? extends E> fn, C cause, Supplier<String> message) {
        return (E)Exceptions.elideStackTrace((Exception)fn.apply(message.get(), cause));
    }

    public static <E extends Exception, R> R raise(Function<? super String, ? extends E> fn, String format, Object ... args) throws E {
        throw Exceptions.create(fn, format, args);
    }

    public static <E extends Exception> void raiseIf(boolean condition, Function<? super String, ? extends E> fn, String format, Object ... args) throws E {
        if (condition) {
            Exceptions.raise(fn, format, args);
        }
    }

    public static <E extends Exception> void raiseUnless(boolean condition, Function<? super String, ? extends E> fn, String format, Object ... args) throws E {
        Exceptions.raiseIf(!condition, fn, format, args);
    }

    public static <E extends Exception, R> R raise(Function<? super String, ? extends E> fn, Supplier<String> message) throws E {
        throw Exceptions.create(fn, message);
    }

    public static <E extends Exception> void raiseIf(boolean condition, Function<? super String, ? extends E> fn, String format, Consumer<FormatArgs> argsProvider) throws E {
        if (condition) {
            Exceptions.raise(fn, Exceptions.message(format, argsProvider));
        }
    }

    public static <E extends Exception> void raiseIf(boolean condition, Function<? super String, ? extends E> fn, Supplier<String> message) throws E {
        if (condition) {
            Exceptions.raise(fn, message);
        }
    }

    public static <E extends Exception> void raiseUnless(boolean condition, Function<? super String, ? extends E> fn, String format, Consumer<FormatArgs> argsProvider) throws E {
        Exceptions.raiseIf(!condition, fn, format, argsProvider);
    }

    public static <E extends Exception> void raiseUnless(boolean condition, Function<? super String, ? extends E> fn, Supplier<String> message) throws E {
        Exceptions.raiseIf(!condition, fn, message);
    }

    public static <E extends Exception, C extends Throwable, R> R raise(BiFunction<? super String, ? super C, ? extends E> fn, C cause, String format, Object ... args) throws E {
        throw Exceptions.create(fn, cause, format, args);
    }

    public static <E extends Exception, C extends Throwable> void raiseIf(boolean condition, BiFunction<? super String, ? super C, ? extends E> fn, C cause, String format, Object ... args) throws E {
        if (condition) {
            Exceptions.raise(fn, cause, format, args);
        }
    }

    public static <E extends Exception, C extends Throwable> void raiseUnless(boolean condition, BiFunction<? super String, ? super C, ? extends E> fn, C cause, String format, Object ... args) throws E {
        Exceptions.raiseIf(!condition, fn, cause, format, args);
    }

    public static <E extends Exception, C extends Throwable, R> R raise(BiFunction<? super String, ? super C, ? extends E> fn, C cause, Supplier<String> message) throws E {
        throw Exceptions.create(fn, cause, message);
    }

    public static <E extends Exception, C extends Throwable> void raiseIf(boolean condition, BiFunction<? super String, ? super C, ? extends E> fn, C cause, String format, Consumer<FormatArgs> argsProvider) throws E {
        if (condition) {
            Exceptions.raise(fn, cause, Exceptions.message(format, argsProvider));
        }
    }

    public static <E extends Exception, C extends Throwable> void raiseIf(boolean condition, BiFunction<? super String, ? super C, ? extends E> fn, C cause, Supplier<String> message) throws E {
        if (condition) {
            Exceptions.raise(fn, cause, message);
        }
    }

    public static <E extends Exception, C extends Throwable> void raiseUnless(boolean condition, BiFunction<? super String, ? super C, ? extends E> fn, C cause, String format, Consumer<FormatArgs> argsProvider) throws E {
        Exceptions.raiseIf(!condition, fn, cause, Exceptions.message(format, argsProvider));
    }

    public static <E extends Exception, C extends Throwable> void raiseUnless(boolean condition, BiFunction<? super String, ? super C, ? extends E> fn, C cause, Supplier<String> message) throws E {
        Exceptions.raiseIf(!condition, fn, cause, message);
    }

    public static Throwable causeOf(Throwable t) {
        while (t instanceof InvocationTargetException) {
            t = t.getCause();
        }
        return t;
    }

    private static <T extends Throwable> T elideStackTrace(T t) {
        StackTraceElement[] stackTrace = t.fillInStackTrace().getStackTrace();
        t.setStackTrace((StackTraceElement[])Stream.of(stackTrace).filter(e -> !Exceptions.class.getName().equals(e.getClassName())).toArray(StackTraceElement[]::new));
        return t;
    }

    private static Supplier<String> message(String format, Consumer<FormatArgs> argsProvider) {
        ObjectWrapper args = new ObjectWrapper();
        argsProvider.accept(args::accept);
        return () -> String.format(format, (Object[])args.get());
    }

    private Exceptions() {
    }

    @FunctionalInterface
    public static interface FormatArgs {
        public void args(Object ... var1);
    }
}

