/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cdi;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.function.Supplier;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.spi.SecurityService;

public class ManagedSecurityService
implements SecurityService {
    private final org.apache.webbeans.corespi.security.ManagedSecurityService delegate = new org.apache.webbeans.corespi.security.ManagedSecurityService();
    private final Logger logger = Logger.getInstance(LogCategory.OPENEJB_CDI, ManagedSecurityService.class.getName());
    private final boolean useWrapper;
    private Principal proxy = null;

    public ManagedSecurityService(WebBeansContext context) {
        boolean bl = this.useWrapper = !Boolean.parseBoolean(context.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.component.PrincipalBean.proxy", "true").trim());
        if (this.useWrapper) {
            ClassLoader loader = ManagedSecurityService.class.getClassLoader();
            String[] apiInterfaces = context.getOpenWebBeansConfiguration().getProperty("org.apache.webbeans.component.PrincipalBean.proxyApis", "org.eclipse.microprofile.jwt.JsonWebToken").split(",");
            ArrayList interfaceList = new ArrayList();
            ArrayList<String> notFoundInterfaceList = new ArrayList<String>();
            for (String apiInterface : apiInterfaces) {
                try {
                    Class<?> clazz = loader.loadClass(apiInterface.trim());
                    interfaceList.add(clazz);
                }
                catch (ClassNotFoundException | NoClassDefFoundError e) {
                    notFoundInterfaceList.add(apiInterface);
                }
            }
            if (!notFoundInterfaceList.isEmpty()) {
                this.logger.info("Some Principal APIs could not be loaded: {0} out of {1} not found", Join.join(",", notFoundInterfaceList), Join.join(",", Arrays.asList(apiInterfaces)));
            }
            if (interfaceList.isEmpty()) {
                interfaceList.add(Principal.class);
            }
            this.proxy = (Principal)Principal.class.cast(Proxy.newProxyInstance(loader, interfaceList.toArray(new Class[0]), (InvocationHandler)new PrincipalInvocationHandler(this::doGetPrincipal)));
        }
    }

    public Principal getCurrentPrincipal() {
        if (this.useWrapper) {
            return this.proxy;
        }
        return this.doGetPrincipal();
    }

    private Principal doGetPrincipal() {
        org.apache.openejb.spi.SecurityService service = SystemInstance.get().getComponent(org.apache.openejb.spi.SecurityService.class);
        if (service != null) {
            return service.getCallerPrincipal();
        }
        return null;
    }

    public <T> Constructor<T> doPrivilegedGetDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        return this.delegate.doPrivilegedGetDeclaredConstructor(clazz, (Class[])parameterTypes);
    }

    public <T> Constructor<T> doPrivilegedGetConstructor(Class<T> clazz, Class<?> ... parameterTypes) {
        return this.delegate.doPrivilegedGetConstructor(clazz, (Class[])parameterTypes);
    }

    public <T> Constructor<?>[] doPrivilegedGetDeclaredConstructors(Class<T> clazz) {
        return this.delegate.doPrivilegedGetDeclaredConstructors(clazz);
    }

    public <T> Method doPrivilegedGetDeclaredMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) {
        return this.delegate.doPrivilegedGetDeclaredMethod(clazz, name, (Class[])parameterTypes);
    }

    public <T> Method[] doPrivilegedGetDeclaredMethods(Class<T> clazz) {
        return this.delegate.doPrivilegedGetDeclaredMethods(clazz);
    }

    public <T> Field doPrivilegedGetDeclaredField(Class<T> clazz, String name) {
        return this.delegate.doPrivilegedGetDeclaredField(clazz, name);
    }

    public <T> Field[] doPrivilegedGetDeclaredFields(Class<T> clazz) {
        return this.delegate.doPrivilegedGetDeclaredFields(clazz);
    }

    public void doPrivilegedSetAccessible(AccessibleObject obj, boolean flag) {
        this.delegate.doPrivilegedSetAccessible(obj, flag);
    }

    public boolean doPrivilegedIsAccessible(AccessibleObject obj) {
        return this.delegate.doPrivilegedIsAccessible(obj);
    }

    public <T> T doPrivilegedObjectCreate(Class<T> clazz) throws PrivilegedActionException, IllegalAccessException, InstantiationException {
        return (T)this.delegate.doPrivilegedObjectCreate(clazz);
    }

    public void doPrivilegedSetSystemProperty(String propertyName, String value) {
        this.delegate.doPrivilegedSetSystemProperty(propertyName, value);
    }

    public String doPrivilegedGetSystemProperty(String propertyName, String defaultValue) {
        return this.delegate.doPrivilegedGetSystemProperty(propertyName, propertyName);
    }

    public Properties doPrivilegedGetSystemProperties() {
        return this.delegate.doPrivilegedGetSystemProperties();
    }

    public static class PrincipalInvocationHandler
    implements InvocationHandler {
        private final Supplier<Principal> principalSupplier;

        public PrincipalInvocationHandler(Supplier<Principal> principalSupplier) {
            this.principalSupplier = principalSupplier;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            Principal principal = this.principalSupplier.get();
            if (principal == null) {
                return null;
            }
            return method.invoke((Object)principal, args);
        }

        public boolean isLogged() {
            return this.principalSupplier.get() != null;
        }
    }
}

