/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core;

import jakarta.ejb.EJBLocalObject;
import jakarta.ejb.EJBObject;
import jakarta.ejb.SessionContext;
import jakarta.transaction.UserTransaction;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.InterfaceType;
import org.apache.openejb.InternalErrorException;
import org.apache.openejb.core.BaseContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.EjbObjectProxyHandler;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.managed.ManagedObjectHandler;
import org.apache.openejb.core.singleton.SingletonEjbObjectHandler;
import org.apache.openejb.core.stateful.StatefulEjbObjectHandler;
import org.apache.openejb.core.stateless.StatelessEjbObjectHandler;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;

public abstract class BaseSessionContext
extends BaseContext
implements SessionContext {
    protected BaseSessionContext(SecurityService securityService) {
        super(securityService);
    }

    public BaseSessionContext(SecurityService securityService, UserTransaction userTransaction) {
        super(securityService, userTransaction);
    }

    public boolean wasCancelCalled() {
        ThreadContext threadContext = ThreadContext.getThreadContext();
        BeanContext di = threadContext.getBeanContext();
        Method runningMethod = threadContext.get(Method.class);
        if (runningMethod == null) {
            throw new IllegalStateException("No running method");
        }
        if (di.isAsynchronous(runningMethod)) {
            if (runningMethod.getReturnType() == Void.TYPE) {
                throw new IllegalStateException("Current running method " + runningMethod.getName() + " is an asynchronous method, but its return type is void :" + di.getDestinationId());
            }
            return ThreadContext.isAsynchronousCancelled();
        }
        throw new IllegalStateException("Current running method " + runningMethod.getName() + " is not an asynchronous method :" + di.getDestinationId());
    }

    public EJBLocalObject getEJBLocalObject() throws IllegalStateException {
        this.doCheck(BaseContext.Call.getEJBLocalObject);
        ThreadContext threadContext = ThreadContext.getThreadContext();
        BeanContext di = threadContext.getBeanContext();
        if (di.getLocalHomeInterface() == null) {
            throw new IllegalStateException("Bean does not have an EJBLocalObject interface: " + di.getDeploymentID());
        }
        return (EJBLocalObject)EjbObjectProxyHandler.createProxy(di, threadContext.getPrimaryKey(), InterfaceType.EJB_LOCAL, di.getLocalInterface());
    }

    public EJBObject getEJBObject() throws IllegalStateException {
        this.doCheck(BaseContext.Call.getEJBObject);
        ThreadContext threadContext = ThreadContext.getThreadContext();
        BeanContext di = threadContext.getBeanContext();
        if (di.getHomeInterface() == null) {
            throw new IllegalStateException("Bean does not have an EJBObject interface: " + di.getDeploymentID());
        }
        return (EJBObject)EjbObjectProxyHandler.createProxy(di, threadContext.getPrimaryKey(), InterfaceType.EJB_OBJECT, di.getRemoteInterface());
    }

    public Object getBusinessObject(Class interfce) {
        this.doCheck(BaseContext.Call.getBusinessObject);
        if (interfce == null) {
            throw new IllegalStateException("Interface argument cannot me null.");
        }
        ThreadContext threadContext = ThreadContext.getThreadContext();
        BeanContext di = threadContext.getBeanContext();
        InterfaceType interfaceType = di.getInterfaceType(interfce);
        BeanType type = di.getComponentType();
        if (interfaceType == null) {
            throw new IllegalStateException("Component has no such interface: " + interfce.getName());
        }
        if (!interfaceType.isBusiness()) {
            throw new IllegalStateException("Interface is not a business interface for this bean: " + interfce.getName());
        }
        try {
            EjbObjectProxyHandler handler = switch (di.getComponentType()) {
                case BeanType.STATEFUL -> new StatefulEjbObjectHandler(di, threadContext.getPrimaryKey(), interfaceType, new ArrayList<Class>(), interfce);
                case BeanType.STATELESS -> new StatelessEjbObjectHandler(di, threadContext.getPrimaryKey(), interfaceType, new ArrayList<Class>(), interfce);
                case BeanType.SINGLETON -> new SingletonEjbObjectHandler(di, threadContext.getPrimaryKey(), interfaceType, new ArrayList<Class>(), interfce);
                case BeanType.MANAGED -> new ManagedObjectHandler(di, threadContext.getPrimaryKey(), interfaceType, new ArrayList<Class>(), interfce);
                default -> throw new IllegalStateException("Bean is not a session bean: " + di.getComponentType());
            };
            if (InterfaceType.LOCALBEAN.equals((Object)interfaceType)) {
                return LocalBeanProxyFactory.constructProxy(di.get(BeanContext.ProxyClass.class).getProxy(), handler);
            }
            ArrayList<Class> interfaces = new ArrayList<Class>(di.getInterfaces(interfaceType));
            interfaces.add(Serializable.class);
            interfaces.add(IntraVmProxy.class);
            if (BeanType.STATEFUL.equals((Object)type) || BeanType.MANAGED.equals((Object)type)) {
                interfaces.add(BeanContext.Removable.class);
            }
            return ProxyManager.newProxyInstance(interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)handler);
        }
        catch (IllegalAccessException iae) {
            throw new InternalErrorException("Could not create IVM proxy for " + interfce.getName() + " interface", iae);
        }
    }

    public Class getInvokedBusinessInterface() {
        this.doCheck(BaseContext.Call.getInvokedBusinessInterface);
        ThreadContext threadContext = ThreadContext.getThreadContext();
        Class invokedInterface = threadContext.getInvokedInterface();
        InterfaceType type = threadContext.getBeanContext().getInterfaceType(invokedInterface);
        if (!type.isBusiness()) {
            throw new IllegalStateException("The EJB spec requires us to cripple the use of this method for anything but business interface proxy.  But FYI, your invoked interface is: " + invokedInterface.getName());
        }
        if (invokedInterface == null) {
            throw new IllegalStateException("Business interface not set into ThreadContext.");
        }
        return invokedInterface;
    }
}

