/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.mdb;

import jakarta.resource.spi.ApplicationServerInternalException;
import jakarta.resource.spi.UnavailableException;
import java.lang.reflect.Method;
import javax.transaction.xa.XAResource;
import org.apache.openejb.BeanContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.SystemException;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.mdb.AbstractEndpointHandler;
import org.apache.openejb.core.mdb.BaseMdbContainer;
import org.apache.openejb.core.mdb.MdbInstanceManager;
import org.apache.openejb.core.mdb.State;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class PoolEndpointHandler
extends AbstractEndpointHandler {
    private static final Logger LOGGER = Logger.getInstance(LogCategory.OPENEJB, "org.apache.openejb.util.resources");
    private final BeanContext deployment;
    private final MdbInstanceManager instanceManager;
    private final XAResource xaResource;
    private ThreadContext callContext;

    public PoolEndpointHandler(BaseMdbContainer container, BeanContext deployment, MdbInstanceManager instanceManager, XAResource xaResource) throws UnavailableException {
        super(container);
        this.deployment = deployment;
        this.instanceManager = instanceManager;
        this.xaResource = xaResource;
        this.callContext = ThreadContext.getThreadContext();
    }

    @Override
    public void beforeDelivery(Method method) throws ApplicationServerInternalException {
        switch (this.state) {
            case RELEASED: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case BEFORE_CALLED: {
                throw new IllegalStateException("beforeDelivery can not be called again until message is delivered and afterDelivery is called");
            }
            case METHOD_CALLED: 
            case SYSTEM_EXCEPTION: {
                throw new IllegalStateException("The last message delivery must be completed with an afterDeliver before beforeDeliver can be called again");
            }
        }
        try {
            this.instance = this.instanceManager.getInstance(new ThreadContext(this.deployment, null));
            this.container.beforeDelivery(this.deployment, this.instance, method, this.xaResource);
        }
        catch (SystemException se) {
            Throwable throwable = se.getRootCause() != null ? se.getRootCause() : se;
            throw new ApplicationServerInternalException(throwable);
        }
        catch (OpenEJBException oe) {
            throw new ApplicationServerInternalException((Throwable)oe);
        }
        this.state = State.BEFORE_CALLED;
    }

    @Override
    protected void recreateInstance(boolean exceptionAlreadyThrown) throws UnavailableException {
    }

    @Override
    public void afterDelivery() throws ApplicationServerInternalException, UnavailableException {
        switch (this.state) {
            case RELEASED: {
                throw new IllegalStateException("Message endpoint factory has been released");
            }
            case NONE: {
                throw new IllegalStateException("afterDelivery may only be called if message delivery began with a beforeDelivery call");
            }
        }
        try {
            this.container.afterDelivery(this.instance);
        }
        catch (SystemException se) {
            Throwable throwable = se.getRootCause() != null ? se.getRootCause() : se;
            throw new ApplicationServerInternalException(throwable);
        }
        finally {
            this.state = State.NONE;
            this.instance = null;
        }
    }

    @Override
    public void release() {
        if (this.state == State.RELEASED) {
            return;
        }
        this.state = State.RELEASED;
        try {
            this.container.release(this.deployment, this.instance);
        }
        finally {
            if (this.instance != null) {
                try {
                    this.instanceManager.poolInstance(new ThreadContext(this.deployment, null), this.instance);
                }
                catch (OpenEJBException e) {
                    LOGGER.error("Unable to add instance back to the pool", e);
                }
            }
            this.instance = null;
        }
    }
}

