/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.core.api.shared;

import jakarta.faces.component.UIComponent;
import java.util.HashMap;
import java.util.Map;

public class CommonHtmlAttributes {
    public static final String ATTRIBUTES_MARKED = "oam.ATTRIBUTES_MARKED";
    public static final long STYLE = 1L;
    public static final long STYLECLASS = 2L;
    public static final long DIR = 4L;
    public static final long LANG = 8L;
    public static final long TITLE = 16L;
    public static final long ESCAPE = 32L;
    public static final long DISABLED = 64L;
    public static final long ENABLED = 128L;
    public static final long READONLY = 256L;
    public static final long ACCESSKEY = 512L;
    public static final long ALT = 1024L;
    public static final long ONCHANGE = 2048L;
    public static final long ONSELECT = 4096L;
    public static final long ONCLICK = 8192L;
    public static final long ONDBLCLICK = 16384L;
    public static final long ONMOUSEDOWN = 32768L;
    public static final long ONMOUSEUP = 65536L;
    public static final long ONMOUSEOVER = 131072L;
    public static final long ONMOUSEMOVE = 262144L;
    public static final long ONMOUSEOUT = 524288L;
    public static final long ONKEYPRESS = 0x100000L;
    public static final long ONKEYDOWN = 0x200000L;
    public static final long ONKEYUP = 0x400000L;
    public static final long ONFOCUS = 0x800000L;
    public static final long ONBLUR = 0x1000000L;
    public static final long LABEL = 0x2000000L;
    public static final long CHARSET = 0x4000000L;
    public static final long COORDS = 0x8000000L;
    public static final long HREFLANG = 0x10000000L;
    public static final long REL = 0x20000000L;
    public static final long REV = 0x40000000L;
    public static final long SHAPE = 0x80000000L;
    public static final long TARGET = 0x100000000L;
    public static final long TYPE = 0x200000000L;
    public static final long TABINDEX = 0x400000000L;
    public static final long ALIGN = 0x800000000L;
    public static final long CHECKED = 0x1000000000L;
    public static final long MAXLENGTH = 0x2000000000L;
    public static final long SIZE = 0x4000000000L;
    public static final long ROLE = 0x8000000000L;
    public static final long ONINPUT = 0x1000000000L;
    public static final long ONINVALID = 0x2000000000L;
    public static final long ONRESET = 0x4000000000L;
    public static final long ONCONTEXTMENU = 0x8000000000L;
    public static final long ONSUBMIT = 0x10000000000L;
    public static final long ONWHEEL = 0x20000000000L;
    public static final long ONCOPY = 0x40000000000L;
    public static final long ONCUT = 0x80000000000L;
    public static final long ONPASTE = 0x100000000000L;
    public static final long ONDRAG = 0x200000000000L;
    public static final long ONDRAGEND = 0x400000000000L;
    public static final long ONDRAGENTER = 0x800000000000L;
    public static final long ONDRAGLEAVE = 0x1000000000000L;
    public static final long ONDRAGOVER = 0x2000000000000L;
    public static final long ONDRAGSTART = 0x4000000000000L;
    public static final long ONDROP = 0x8000000000000L;
    public static final long ONSCROLL = 0x10000000000000L;
    public static final Map<String, Long> COMMONERTIES_KEY_BY_NAME = new HashMap<String, Long>(64, 1.0f);

    public static void markAttribute(UIComponent component, String name) {
        Long propertyConstant = COMMONERTIES_KEY_BY_NAME.get(name);
        if (propertyConstant == null) {
            return;
        }
        Long commonPropertiesSet = (Long)component.getAttributes().get(ATTRIBUTES_MARKED);
        if (commonPropertiesSet == null) {
            commonPropertiesSet = 0L;
        }
        component.getAttributes().put(ATTRIBUTES_MARKED, commonPropertiesSet | propertyConstant);
    }

    public static void markAttribute(UIComponent component, long propertyConstant) {
        Long commonPropertiesSet = (Long)component.getAttributes().get(ATTRIBUTES_MARKED);
        if (commonPropertiesSet == null) {
            commonPropertiesSet = 0L;
        }
        component.getAttributes().put(ATTRIBUTES_MARKED, commonPropertiesSet | propertyConstant);
    }

    public static long getMarkedAttributes(UIComponent component) {
        Long commonProperties = (Long)component.getAttributes().get(ATTRIBUTES_MARKED);
        if (commonProperties == null) {
            commonProperties = 0L;
        }
        return commonProperties;
    }

    static {
        COMMONERTIES_KEY_BY_NAME.put("style", 1L);
        COMMONERTIES_KEY_BY_NAME.put("styleClass", 2L);
        COMMONERTIES_KEY_BY_NAME.put("dir", 4L);
        COMMONERTIES_KEY_BY_NAME.put("lang", 8L);
        COMMONERTIES_KEY_BY_NAME.put("title", 16L);
        COMMONERTIES_KEY_BY_NAME.put("escape", 32L);
        COMMONERTIES_KEY_BY_NAME.put("disabled", 64L);
        COMMONERTIES_KEY_BY_NAME.put("enabled", 128L);
        COMMONERTIES_KEY_BY_NAME.put("readonly", 256L);
        COMMONERTIES_KEY_BY_NAME.put("accesskey", 512L);
        COMMONERTIES_KEY_BY_NAME.put("alt", 1024L);
        COMMONERTIES_KEY_BY_NAME.put("onchange", 2048L);
        COMMONERTIES_KEY_BY_NAME.put("onselect", 4096L);
        COMMONERTIES_KEY_BY_NAME.put("onclick", 8192L);
        COMMONERTIES_KEY_BY_NAME.put("ondblclick", 16384L);
        COMMONERTIES_KEY_BY_NAME.put("onmousedown", 32768L);
        COMMONERTIES_KEY_BY_NAME.put("onmouseup", 65536L);
        COMMONERTIES_KEY_BY_NAME.put("onmouseover", 131072L);
        COMMONERTIES_KEY_BY_NAME.put("onmousemove", 262144L);
        COMMONERTIES_KEY_BY_NAME.put("onmouseout", 524288L);
        COMMONERTIES_KEY_BY_NAME.put("onkeypress", 0x100000L);
        COMMONERTIES_KEY_BY_NAME.put("onkeydown", 0x200000L);
        COMMONERTIES_KEY_BY_NAME.put("onkeyup", 0x400000L);
        COMMONERTIES_KEY_BY_NAME.put("onfocus", 0x800000L);
        COMMONERTIES_KEY_BY_NAME.put("onblur", 0x1000000L);
        COMMONERTIES_KEY_BY_NAME.put("label", 0x2000000L);
        COMMONERTIES_KEY_BY_NAME.put("charset", 0x4000000L);
        COMMONERTIES_KEY_BY_NAME.put("coords", 0x8000000L);
        COMMONERTIES_KEY_BY_NAME.put("hreflang", 0x10000000L);
        COMMONERTIES_KEY_BY_NAME.put("rel", 0x20000000L);
        COMMONERTIES_KEY_BY_NAME.put("rev", 0x40000000L);
        COMMONERTIES_KEY_BY_NAME.put("shape", 0x80000000L);
        COMMONERTIES_KEY_BY_NAME.put("target", 0x100000000L);
        COMMONERTIES_KEY_BY_NAME.put("type", 0x200000000L);
        COMMONERTIES_KEY_BY_NAME.put("tabindex", 0x400000000L);
        COMMONERTIES_KEY_BY_NAME.put("align", 0x800000000L);
        COMMONERTIES_KEY_BY_NAME.put("checked", 0x1000000000L);
        COMMONERTIES_KEY_BY_NAME.put("maxlength", 0x2000000000L);
        COMMONERTIES_KEY_BY_NAME.put("size", 0x4000000000L);
        COMMONERTIES_KEY_BY_NAME.put("role", 0x8000000000L);
        COMMONERTIES_KEY_BY_NAME.put("oninput", 0x1000000000L);
        COMMONERTIES_KEY_BY_NAME.put("oninvalid", 0x2000000000L);
        COMMONERTIES_KEY_BY_NAME.put("onreset", 0x4000000000L);
        COMMONERTIES_KEY_BY_NAME.put("oncontextmenu", 0x8000000000L);
        COMMONERTIES_KEY_BY_NAME.put("onsubmit", 0x10000000000L);
        COMMONERTIES_KEY_BY_NAME.put("onwheel", 0x20000000000L);
        COMMONERTIES_KEY_BY_NAME.put("oncopy", 0x40000000000L);
        COMMONERTIES_KEY_BY_NAME.put("oncut", 0x80000000000L);
        COMMONERTIES_KEY_BY_NAME.put("onpaste", 0x100000000000L);
        COMMONERTIES_KEY_BY_NAME.put("ondrag", 0x200000000000L);
        COMMONERTIES_KEY_BY_NAME.put("ondragend", 0x400000000000L);
        COMMONERTIES_KEY_BY_NAME.put("ondragenter", 0x800000000000L);
        COMMONERTIES_KEY_BY_NAME.put("ondragleave", 0x1000000000000L);
        COMMONERTIES_KEY_BY_NAME.put("ondragover", 0x2000000000000L);
        COMMONERTIES_KEY_BY_NAME.put("ondragstart", 0x4000000000000L);
        COMMONERTIES_KEY_BY_NAME.put("ondrop", 0x8000000000000L);
        COMMONERTIES_KEY_BY_NAME.put("onscroll", 0x10000000000000L);
    }
}

