#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
# http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
# -*- coding: utf-8 -*-
#
# Configuration file for the Sphinx documentation builder.
#
# This file does only contain a selection of the most common options. For a
# full list see the documentation:
# http://www.sphinx-doc.org/en/master/config

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
here = os.path.dirname(__file__)
clientPath = os.path.join(here, '..', '..', 'traffic_control', 'clients', 'python')
clientPath = os.path.abspath(clientPath)
sys.path.insert(0, clientPath)
sys.path.insert(0, os.path.join(here, '_ext'))

# -- Custom Lexical Analyzer for DNS -----------------------------------------
from pygments.lexer import RegexLexer, bygroups
from pygments.token import *
from sphinx.highlighting import lexers

class DNSLexer(RegexLexer):
    """
    DNSLexer is a lexer for the pygments code highlighter that highlights DNS messages
    as printed out by the 'dig' command.
    """
    name = 'DNS'
    aliases = ['dns', 'dig']

    tokens = {
        'root': [
            (r"^;( <<>> .*?| \((\d+|no) server(s)? found\)\s*|; global options:.*?|; Got answer:\s*)$", Comment.Singleline),
            (r"^;;", Operator),
            (r"^;\w.*?$", String),
            (r"->>HEADER<<-", Keyword),
            (r"(WARNING)(:)( )(.*?)$", bygroups(Generic.Subheading, Operator, Text, Error)),
            (r"(WHEN)(:)( )(.*?)$", bygroups(Generic.Subheading, Operator, Text, Literal.Date)),
            (r"(\w+)(:)(\s*)(\w+)(,)?", bygroups(Name.Variable, Operator, Text, String, Text)),
            (r"(flags:)( )(?=(\w+)( )?)+", bygroups(Name.Entity, Text, String, Text)),
            (r";", Keyword),
            (r"[a-zA-Z]+ SECTION:", Generic.Heading),
            (r"(\d+\.){3}\d+", String.Other),
            (r"\d", Number),
            (r"[\w\.\-#\(\)]+", String),
            (r'\s', Text)
        ]
    }

lexers['DNS'] = DNSLexer(startinline=True)

# -- Project information -----------------------------------------------------

project = 'Traffic Control'
copyright = '2018, Apache Traffic Control'
author = 'Apache Traffic Control'

with open(os.path.abspath(os.path.join(here, '..', '..', 'VERSION'))) as fd:
	# The short X.Y version
	version = fd.read().strip()

# The full version, including alpha/beta/rc tags
release = version


# -- General configuration ---------------------------------------------------

# If your documentation needs a minimal Sphinx version, state it here.
#
# needs_sphinx = '1.0'

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
	'sphinx.ext.autodoc',
	'sphinx_autodoc_typehints',
    'atc'
]

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# The suffix(es) of source filenames.
# You can specify multiple suffix as a list of string:
#
# source_suffix = ['.rst', '.md']
source_suffix = '.rst'

# The master toctree document.
master_doc = 'index'

# The language for content autogenerated by Sphinx. Refer to documentation
# for a list of supported languages.
#
# This is also used if you do content translation via gettext catalogs.
# Usually you set "language" from the command line for these cases.
language = "en"

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path .
exclude_patterns = []

# The name of the Pygments (syntax highlighting) style to use.
pygments_style = 'sphinx'


# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of built-in themes.
#
html_theme = 'sphinx_rtd_theme'

# Theme options are theme-specific and customize the look and feel of a theme
# further.  For a list of options available for each theme, see the
# documentation.
#
# html_theme_options = {}

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the built-in static files,
# so a file named "default.css" will overwrite the built-in "default.css".
html_static_path = ['_static']

# Custom sidebar templates, must be a dictionary that maps document names
# to template names.
#
# The default sidebars (for documents that don't match any pattern) are
# defined by theme itself.  Builtin themes are using these templates by
# default: ``['localtoc.html', 'relations.html', 'sourcelink.html',
# 'searchbox.html']``.
#
# html_sidebars = {}

# Sets the favicon for the HTML pages
html_favicon="favicon.ico"

# Sets the sidebar logo for HTML pages
html_logo="../../misc/logos/ATC-SVG-FULL-WHITE.svg"


# -- Options for HTMLHelp output ---------------------------------------------

# Output file base name for HTML help builder.
htmlhelp_basename = 'traffic-control-cdn-doc'


# -- Options for LaTeX output ------------------------------------------------

latex_elements = {
    # The paper size ('letterpaper' or 'a4paper').
    #
    'papersize': 'a4paper',

    # The font size ('10pt', '11pt' or '12pt').
    #
    'pointsize': '12pt',
	# Additional stuff for the LaTeX preamble.
	#
	# 'preamble': '',

	# Latex figure (float) alignment
	#
	# 'figure_align': 'htbp',
}

# Grouping the document tree into LaTeX files. List of tuples
# (source start file, target name, title,
#  author, documentclass [howto, manual, or own class]).
latex_documents = [
	(master_doc, 'trafficcontrol.tex', 'Apache Traffic Control Documentation',
	 'Apache Traffic Control', 'manual'),
]

latex_logo = "../../misc/logos/ATC-PNG-FULL-BLACK-LARGE.png"


# -- Options for manual page output ------------------------------------------

# One entry per manual page. List of tuples
# (source start file, name, description, authors, manual section).
man_pages = [
	(master_doc, 'Apache Traffic Control', 'Apache Traffic Control Documentation',
	 [author], 1)
]

# A format string that will be used to link to manual pages for appropriately-roled Linux utilities.
manpages_url = "https://manpages.debian.org/{path}"


# -- Options for Texinfo output ----------------------------------------------

# Grouping the document tree into Texinfo files. List of tuples
# (source start file, target name, title, author,
#  dir menu entry, description, category)
texinfo_documents = [
	(master_doc, 'trafficcontrol', 'trafficcontrol Documentation',
	 author, 'trafficcontrol', 'Traffic Control is an Open Source implementation of a Content Delivery Network.',
	 'Miscellaneous'),
]

# Hopefully this will cause tab expansion to use 4 spaces rather than the
# (GNU-supported) default of 8.
tab_width=4

# Causes floating environments to be automatically numbered when they are captioned.
numfig = True
numfig_format = {"figure": "Fig. %s",
                 "table": "Table %s",
                 "code-block": "#%s",
                 "section": "Section"}
numfig_secnum_depth = 0
