/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

module.exports = angular.module('trafficPortal.private.cdns.dnssecKeys.generate', [])
	.config(function($stateProvider, $urlRouterProvider) {
		$stateProvider
			.state('trafficPortal.private.cdns.dnssecKeys.generate', {
				url: '/generate',
				views: {
					cdnDnssecKeysContent: {
						templateUrl: 'common/modules/form/cdnDnssecKeys/generate/form.GenerateCdnDnssecKeys.tpl.html',
						controller: 'FormGenerateCdnDnssecKeysController as ctrl',
						resolve: {
							cdn: function($stateParams, cdnService) {
								return cdnService.getCDN($stateParams.cdnId);
							},
							dnssecKeysRequest: function(cdn) {
								return {
									key: cdn.name,
									name: cdn.domainName,
									ttl: 60,
									kskExpirationDays: 365,
									zskExpirationDays: 30,
									effectiveDate: moment().utc().format('YYYY-MM-DD HH:mm:ss')
								};
							}
						}
					}
				}
			})
		;
		$urlRouterProvider.otherwise('/');
	});
