// Copyright 2015-present Basho Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go.
// source: riak_kv.proto
// DO NOT EDIT!

/*
Package riak_kv is a generated protocol buffer package.

It is generated from these files:
	riak_kv.proto

It has these top-level messages:
	RpbGetClientIdResp
	RpbSetClientIdReq
	RpbGetReq
	RpbGetResp
	RpbPutReq
	RpbPutResp
	RpbDelReq
	RpbListBucketsReq
	RpbListBucketsResp
	RpbListKeysReq
	RpbListKeysResp
	RpbMapRedReq
	RpbMapRedResp
	RpbIndexReq
	RpbIndexResp
	RpbIndexBodyResp
	RpbCSBucketReq
	RpbCSBucketResp
	RpbIndexObject
	RpbContent
	RpbLink
	RpbCounterUpdateReq
	RpbCounterUpdateResp
	RpbCounterGetReq
	RpbCounterGetResp
	RpbGetBucketKeyPreflistReq
	RpbGetBucketKeyPreflistResp
	RpbBucketKeyPreflistItem
	RpbCoverageReq
	RpbCoverageResp
	RpbCoverageEntry
*/
package riak_kv

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import riak "github.com/basho/riak-go-client/rpb/riak"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type RpbIndexReq_IndexQueryType int32

const (
	RpbIndexReq_eq    RpbIndexReq_IndexQueryType = 0
	RpbIndexReq_range RpbIndexReq_IndexQueryType = 1
)

var RpbIndexReq_IndexQueryType_name = map[int32]string{
	0: "eq",
	1: "range",
}
var RpbIndexReq_IndexQueryType_value = map[string]int32{
	"eq":    0,
	"range": 1,
}

func (x RpbIndexReq_IndexQueryType) Enum() *RpbIndexReq_IndexQueryType {
	p := new(RpbIndexReq_IndexQueryType)
	*p = x
	return p
}
func (x RpbIndexReq_IndexQueryType) String() string {
	return proto.EnumName(RpbIndexReq_IndexQueryType_name, int32(x))
}
func (x *RpbIndexReq_IndexQueryType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(RpbIndexReq_IndexQueryType_value, data, "RpbIndexReq_IndexQueryType")
	if err != nil {
		return err
	}
	*x = RpbIndexReq_IndexQueryType(value)
	return nil
}
func (RpbIndexReq_IndexQueryType) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor0, []int{13, 0}
}

// Get ClientId Request - no message defined, just send RpbGetClientIdReq message code
type RpbGetClientIdResp struct {
	ClientId         []byte `protobuf:"bytes,1,req,name=client_id" json:"client_id,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbGetClientIdResp) Reset()                    { *m = RpbGetClientIdResp{} }
func (m *RpbGetClientIdResp) String() string            { return proto.CompactTextString(m) }
func (*RpbGetClientIdResp) ProtoMessage()               {}
func (*RpbGetClientIdResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *RpbGetClientIdResp) GetClientId() []byte {
	if m != nil {
		return m.ClientId
	}
	return nil
}

type RpbSetClientIdReq struct {
	ClientId         []byte `protobuf:"bytes,1,req,name=client_id" json:"client_id,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbSetClientIdReq) Reset()                    { *m = RpbSetClientIdReq{} }
func (m *RpbSetClientIdReq) String() string            { return proto.CompactTextString(m) }
func (*RpbSetClientIdReq) ProtoMessage()               {}
func (*RpbSetClientIdReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *RpbSetClientIdReq) GetClientId() []byte {
	if m != nil {
		return m.ClientId
	}
	return nil
}

// Get Request - retrieve bucket/key
type RpbGetReq struct {
	Bucket           []byte  `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Key              []byte  `protobuf:"bytes,2,req,name=key" json:"key,omitempty"`
	R                *uint32 `protobuf:"varint,3,opt,name=r" json:"r,omitempty"`
	Pr               *uint32 `protobuf:"varint,4,opt,name=pr" json:"pr,omitempty"`
	BasicQuorum      *bool   `protobuf:"varint,5,opt,name=basic_quorum" json:"basic_quorum,omitempty"`
	NotfoundOk       *bool   `protobuf:"varint,6,opt,name=notfound_ok" json:"notfound_ok,omitempty"`
	IfModified       []byte  `protobuf:"bytes,7,opt,name=if_modified" json:"if_modified,omitempty"`
	Head             *bool   `protobuf:"varint,8,opt,name=head" json:"head,omitempty"`
	Deletedvclock    *bool   `protobuf:"varint,9,opt,name=deletedvclock" json:"deletedvclock,omitempty"`
	Timeout          *uint32 `protobuf:"varint,10,opt,name=timeout" json:"timeout,omitempty"`
	SloppyQuorum     *bool   `protobuf:"varint,11,opt,name=sloppy_quorum" json:"sloppy_quorum,omitempty"`
	NVal             *uint32 `protobuf:"varint,12,opt,name=n_val" json:"n_val,omitempty"`
	Type             []byte  `protobuf:"bytes,13,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbGetReq) Reset()                    { *m = RpbGetReq{} }
func (m *RpbGetReq) String() string            { return proto.CompactTextString(m) }
func (*RpbGetReq) ProtoMessage()               {}
func (*RpbGetReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *RpbGetReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbGetReq) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbGetReq) GetR() uint32 {
	if m != nil && m.R != nil {
		return *m.R
	}
	return 0
}

func (m *RpbGetReq) GetPr() uint32 {
	if m != nil && m.Pr != nil {
		return *m.Pr
	}
	return 0
}

func (m *RpbGetReq) GetBasicQuorum() bool {
	if m != nil && m.BasicQuorum != nil {
		return *m.BasicQuorum
	}
	return false
}

func (m *RpbGetReq) GetNotfoundOk() bool {
	if m != nil && m.NotfoundOk != nil {
		return *m.NotfoundOk
	}
	return false
}

func (m *RpbGetReq) GetIfModified() []byte {
	if m != nil {
		return m.IfModified
	}
	return nil
}

func (m *RpbGetReq) GetHead() bool {
	if m != nil && m.Head != nil {
		return *m.Head
	}
	return false
}

func (m *RpbGetReq) GetDeletedvclock() bool {
	if m != nil && m.Deletedvclock != nil {
		return *m.Deletedvclock
	}
	return false
}

func (m *RpbGetReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *RpbGetReq) GetSloppyQuorum() bool {
	if m != nil && m.SloppyQuorum != nil {
		return *m.SloppyQuorum
	}
	return false
}

func (m *RpbGetReq) GetNVal() uint32 {
	if m != nil && m.NVal != nil {
		return *m.NVal
	}
	return 0
}

func (m *RpbGetReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

// Get Response - if the record was not found there will be no content/vclock
type RpbGetResp struct {
	Content          []*RpbContent `protobuf:"bytes,1,rep,name=content" json:"content,omitempty"`
	Vclock           []byte        `protobuf:"bytes,2,opt,name=vclock" json:"vclock,omitempty"`
	Unchanged        *bool         `protobuf:"varint,3,opt,name=unchanged" json:"unchanged,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *RpbGetResp) Reset()                    { *m = RpbGetResp{} }
func (m *RpbGetResp) String() string            { return proto.CompactTextString(m) }
func (*RpbGetResp) ProtoMessage()               {}
func (*RpbGetResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *RpbGetResp) GetContent() []*RpbContent {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *RpbGetResp) GetVclock() []byte {
	if m != nil {
		return m.Vclock
	}
	return nil
}

func (m *RpbGetResp) GetUnchanged() bool {
	if m != nil && m.Unchanged != nil {
		return *m.Unchanged
	}
	return false
}

// Put request - if options.return_body is set then the updated metadata/data for
//               the key will be returned.
type RpbPutReq struct {
	Bucket           []byte      `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Key              []byte      `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
	Vclock           []byte      `protobuf:"bytes,3,opt,name=vclock" json:"vclock,omitempty"`
	Content          *RpbContent `protobuf:"bytes,4,req,name=content" json:"content,omitempty"`
	W                *uint32     `protobuf:"varint,5,opt,name=w" json:"w,omitempty"`
	Dw               *uint32     `protobuf:"varint,6,opt,name=dw" json:"dw,omitempty"`
	ReturnBody       *bool       `protobuf:"varint,7,opt,name=return_body" json:"return_body,omitempty"`
	Pw               *uint32     `protobuf:"varint,8,opt,name=pw" json:"pw,omitempty"`
	IfNotModified    *bool       `protobuf:"varint,9,opt,name=if_not_modified" json:"if_not_modified,omitempty"`
	IfNoneMatch      *bool       `protobuf:"varint,10,opt,name=if_none_match" json:"if_none_match,omitempty"`
	ReturnHead       *bool       `protobuf:"varint,11,opt,name=return_head" json:"return_head,omitempty"`
	Timeout          *uint32     `protobuf:"varint,12,opt,name=timeout" json:"timeout,omitempty"`
	Asis             *bool       `protobuf:"varint,13,opt,name=asis" json:"asis,omitempty"`
	SloppyQuorum     *bool       `protobuf:"varint,14,opt,name=sloppy_quorum" json:"sloppy_quorum,omitempty"`
	NVal             *uint32     `protobuf:"varint,15,opt,name=n_val" json:"n_val,omitempty"`
	Type             []byte      `protobuf:"bytes,16,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *RpbPutReq) Reset()                    { *m = RpbPutReq{} }
func (m *RpbPutReq) String() string            { return proto.CompactTextString(m) }
func (*RpbPutReq) ProtoMessage()               {}
func (*RpbPutReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *RpbPutReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbPutReq) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbPutReq) GetVclock() []byte {
	if m != nil {
		return m.Vclock
	}
	return nil
}

func (m *RpbPutReq) GetContent() *RpbContent {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *RpbPutReq) GetW() uint32 {
	if m != nil && m.W != nil {
		return *m.W
	}
	return 0
}

func (m *RpbPutReq) GetDw() uint32 {
	if m != nil && m.Dw != nil {
		return *m.Dw
	}
	return 0
}

func (m *RpbPutReq) GetReturnBody() bool {
	if m != nil && m.ReturnBody != nil {
		return *m.ReturnBody
	}
	return false
}

func (m *RpbPutReq) GetPw() uint32 {
	if m != nil && m.Pw != nil {
		return *m.Pw
	}
	return 0
}

func (m *RpbPutReq) GetIfNotModified() bool {
	if m != nil && m.IfNotModified != nil {
		return *m.IfNotModified
	}
	return false
}

func (m *RpbPutReq) GetIfNoneMatch() bool {
	if m != nil && m.IfNoneMatch != nil {
		return *m.IfNoneMatch
	}
	return false
}

func (m *RpbPutReq) GetReturnHead() bool {
	if m != nil && m.ReturnHead != nil {
		return *m.ReturnHead
	}
	return false
}

func (m *RpbPutReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *RpbPutReq) GetAsis() bool {
	if m != nil && m.Asis != nil {
		return *m.Asis
	}
	return false
}

func (m *RpbPutReq) GetSloppyQuorum() bool {
	if m != nil && m.SloppyQuorum != nil {
		return *m.SloppyQuorum
	}
	return false
}

func (m *RpbPutReq) GetNVal() uint32 {
	if m != nil && m.NVal != nil {
		return *m.NVal
	}
	return 0
}

func (m *RpbPutReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

// Put response - same as get response with optional key if one was generated
type RpbPutResp struct {
	Content          []*RpbContent `protobuf:"bytes,1,rep,name=content" json:"content,omitempty"`
	Vclock           []byte        `protobuf:"bytes,2,opt,name=vclock" json:"vclock,omitempty"`
	Key              []byte        `protobuf:"bytes,3,opt,name=key" json:"key,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *RpbPutResp) Reset()                    { *m = RpbPutResp{} }
func (m *RpbPutResp) String() string            { return proto.CompactTextString(m) }
func (*RpbPutResp) ProtoMessage()               {}
func (*RpbPutResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *RpbPutResp) GetContent() []*RpbContent {
	if m != nil {
		return m.Content
	}
	return nil
}

func (m *RpbPutResp) GetVclock() []byte {
	if m != nil {
		return m.Vclock
	}
	return nil
}

func (m *RpbPutResp) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

// Delete request
type RpbDelReq struct {
	Bucket           []byte  `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Key              []byte  `protobuf:"bytes,2,req,name=key" json:"key,omitempty"`
	Rw               *uint32 `protobuf:"varint,3,opt,name=rw" json:"rw,omitempty"`
	Vclock           []byte  `protobuf:"bytes,4,opt,name=vclock" json:"vclock,omitempty"`
	R                *uint32 `protobuf:"varint,5,opt,name=r" json:"r,omitempty"`
	W                *uint32 `protobuf:"varint,6,opt,name=w" json:"w,omitempty"`
	Pr               *uint32 `protobuf:"varint,7,opt,name=pr" json:"pr,omitempty"`
	Pw               *uint32 `protobuf:"varint,8,opt,name=pw" json:"pw,omitempty"`
	Dw               *uint32 `protobuf:"varint,9,opt,name=dw" json:"dw,omitempty"`
	Timeout          *uint32 `protobuf:"varint,10,opt,name=timeout" json:"timeout,omitempty"`
	SloppyQuorum     *bool   `protobuf:"varint,11,opt,name=sloppy_quorum" json:"sloppy_quorum,omitempty"`
	NVal             *uint32 `protobuf:"varint,12,opt,name=n_val" json:"n_val,omitempty"`
	Type             []byte  `protobuf:"bytes,13,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbDelReq) Reset()                    { *m = RpbDelReq{} }
func (m *RpbDelReq) String() string            { return proto.CompactTextString(m) }
func (*RpbDelReq) ProtoMessage()               {}
func (*RpbDelReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *RpbDelReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbDelReq) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbDelReq) GetRw() uint32 {
	if m != nil && m.Rw != nil {
		return *m.Rw
	}
	return 0
}

func (m *RpbDelReq) GetVclock() []byte {
	if m != nil {
		return m.Vclock
	}
	return nil
}

func (m *RpbDelReq) GetR() uint32 {
	if m != nil && m.R != nil {
		return *m.R
	}
	return 0
}

func (m *RpbDelReq) GetW() uint32 {
	if m != nil && m.W != nil {
		return *m.W
	}
	return 0
}

func (m *RpbDelReq) GetPr() uint32 {
	if m != nil && m.Pr != nil {
		return *m.Pr
	}
	return 0
}

func (m *RpbDelReq) GetPw() uint32 {
	if m != nil && m.Pw != nil {
		return *m.Pw
	}
	return 0
}

func (m *RpbDelReq) GetDw() uint32 {
	if m != nil && m.Dw != nil {
		return *m.Dw
	}
	return 0
}

func (m *RpbDelReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *RpbDelReq) GetSloppyQuorum() bool {
	if m != nil && m.SloppyQuorum != nil {
		return *m.SloppyQuorum
	}
	return false
}

func (m *RpbDelReq) GetNVal() uint32 {
	if m != nil && m.NVal != nil {
		return *m.NVal
	}
	return 0
}

func (m *RpbDelReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

// List buckets request
type RpbListBucketsReq struct {
	Timeout          *uint32 `protobuf:"varint,1,opt,name=timeout" json:"timeout,omitempty"`
	Stream           *bool   `protobuf:"varint,2,opt,name=stream" json:"stream,omitempty"`
	Type             []byte  `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbListBucketsReq) Reset()                    { *m = RpbListBucketsReq{} }
func (m *RpbListBucketsReq) String() string            { return proto.CompactTextString(m) }
func (*RpbListBucketsReq) ProtoMessage()               {}
func (*RpbListBucketsReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *RpbListBucketsReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *RpbListBucketsReq) GetStream() bool {
	if m != nil && m.Stream != nil {
		return *m.Stream
	}
	return false
}

func (m *RpbListBucketsReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

// List buckets response - one or more of these packets will be sent
// the last one will have done set true (and may not have any buckets in it)
type RpbListBucketsResp struct {
	Buckets          [][]byte `protobuf:"bytes,1,rep,name=buckets" json:"buckets,omitempty"`
	Done             *bool    `protobuf:"varint,2,opt,name=done" json:"done,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *RpbListBucketsResp) Reset()                    { *m = RpbListBucketsResp{} }
func (m *RpbListBucketsResp) String() string            { return proto.CompactTextString(m) }
func (*RpbListBucketsResp) ProtoMessage()               {}
func (*RpbListBucketsResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *RpbListBucketsResp) GetBuckets() [][]byte {
	if m != nil {
		return m.Buckets
	}
	return nil
}

func (m *RpbListBucketsResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return false
}

// List keys in bucket request
type RpbListKeysReq struct {
	Bucket           []byte  `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Timeout          *uint32 `protobuf:"varint,2,opt,name=timeout" json:"timeout,omitempty"`
	Type             []byte  `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbListKeysReq) Reset()                    { *m = RpbListKeysReq{} }
func (m *RpbListKeysReq) String() string            { return proto.CompactTextString(m) }
func (*RpbListKeysReq) ProtoMessage()               {}
func (*RpbListKeysReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *RpbListKeysReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbListKeysReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *RpbListKeysReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

// List keys in bucket response - one or more of these packets will be sent
// the last one will have done set true (and may not have any keys in it)
type RpbListKeysResp struct {
	Keys             [][]byte `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
	Done             *bool    `protobuf:"varint,2,opt,name=done" json:"done,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *RpbListKeysResp) Reset()                    { *m = RpbListKeysResp{} }
func (m *RpbListKeysResp) String() string            { return proto.CompactTextString(m) }
func (*RpbListKeysResp) ProtoMessage()               {}
func (*RpbListKeysResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *RpbListKeysResp) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *RpbListKeysResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return false
}

// Map/Reduce request
type RpbMapRedReq struct {
	Request          []byte `protobuf:"bytes,1,req,name=request" json:"request,omitempty"`
	ContentType      []byte `protobuf:"bytes,2,req,name=content_type" json:"content_type,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbMapRedReq) Reset()                    { *m = RpbMapRedReq{} }
func (m *RpbMapRedReq) String() string            { return proto.CompactTextString(m) }
func (*RpbMapRedReq) ProtoMessage()               {}
func (*RpbMapRedReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *RpbMapRedReq) GetRequest() []byte {
	if m != nil {
		return m.Request
	}
	return nil
}

func (m *RpbMapRedReq) GetContentType() []byte {
	if m != nil {
		return m.ContentType
	}
	return nil
}

// Map/Reduce response
// one or more of these packets will be sent the last one will have done set
// true (and may not have phase/data in it)
type RpbMapRedResp struct {
	Phase            *uint32 `protobuf:"varint,1,opt,name=phase" json:"phase,omitempty"`
	Response         []byte  `protobuf:"bytes,2,opt,name=response" json:"response,omitempty"`
	Done             *bool   `protobuf:"varint,3,opt,name=done" json:"done,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbMapRedResp) Reset()                    { *m = RpbMapRedResp{} }
func (m *RpbMapRedResp) String() string            { return proto.CompactTextString(m) }
func (*RpbMapRedResp) ProtoMessage()               {}
func (*RpbMapRedResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *RpbMapRedResp) GetPhase() uint32 {
	if m != nil && m.Phase != nil {
		return *m.Phase
	}
	return 0
}

func (m *RpbMapRedResp) GetResponse() []byte {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *RpbMapRedResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return false
}

// Secondary Index query request
type RpbIndexReq struct {
	Bucket       []byte                      `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Index        []byte                      `protobuf:"bytes,2,req,name=index" json:"index,omitempty"`
	Qtype        *RpbIndexReq_IndexQueryType `protobuf:"varint,3,req,name=qtype,enum=RpbIndexReq_IndexQueryType" json:"qtype,omitempty"`
	Key          []byte                      `protobuf:"bytes,4,opt,name=key" json:"key,omitempty"`
	RangeMin     []byte                      `protobuf:"bytes,5,opt,name=range_min" json:"range_min,omitempty"`
	RangeMax     []byte                      `protobuf:"bytes,6,opt,name=range_max" json:"range_max,omitempty"`
	ReturnTerms  *bool                       `protobuf:"varint,7,opt,name=return_terms" json:"return_terms,omitempty"`
	Stream       *bool                       `protobuf:"varint,8,opt,name=stream" json:"stream,omitempty"`
	MaxResults   *uint32                     `protobuf:"varint,9,opt,name=max_results" json:"max_results,omitempty"`
	Continuation []byte                      `protobuf:"bytes,10,opt,name=continuation" json:"continuation,omitempty"`
	Timeout      *uint32                     `protobuf:"varint,11,opt,name=timeout" json:"timeout,omitempty"`
	Type         []byte                      `protobuf:"bytes,12,opt,name=type" json:"type,omitempty"`
	TermRegex    []byte                      `protobuf:"bytes,13,opt,name=term_regex" json:"term_regex,omitempty"`
	// Whether to use pagination sort for non-paginated queries
	PaginationSort *bool `protobuf:"varint,14,opt,name=pagination_sort" json:"pagination_sort,omitempty"`
	// parallel extraction extension
	CoverContext     []byte `protobuf:"bytes,15,opt,name=cover_context" json:"cover_context,omitempty"`
	ReturnBody       *bool  `protobuf:"varint,16,opt,name=return_body" json:"return_body,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbIndexReq) Reset()                    { *m = RpbIndexReq{} }
func (m *RpbIndexReq) String() string            { return proto.CompactTextString(m) }
func (*RpbIndexReq) ProtoMessage()               {}
func (*RpbIndexReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *RpbIndexReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbIndexReq) GetIndex() []byte {
	if m != nil {
		return m.Index
	}
	return nil
}

func (m *RpbIndexReq) GetQtype() RpbIndexReq_IndexQueryType {
	if m != nil && m.Qtype != nil {
		return *m.Qtype
	}
	return RpbIndexReq_eq
}

func (m *RpbIndexReq) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbIndexReq) GetRangeMin() []byte {
	if m != nil {
		return m.RangeMin
	}
	return nil
}

func (m *RpbIndexReq) GetRangeMax() []byte {
	if m != nil {
		return m.RangeMax
	}
	return nil
}

func (m *RpbIndexReq) GetReturnTerms() bool {
	if m != nil && m.ReturnTerms != nil {
		return *m.ReturnTerms
	}
	return false
}

func (m *RpbIndexReq) GetStream() bool {
	if m != nil && m.Stream != nil {
		return *m.Stream
	}
	return false
}

func (m *RpbIndexReq) GetMaxResults() uint32 {
	if m != nil && m.MaxResults != nil {
		return *m.MaxResults
	}
	return 0
}

func (m *RpbIndexReq) GetContinuation() []byte {
	if m != nil {
		return m.Continuation
	}
	return nil
}

func (m *RpbIndexReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *RpbIndexReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RpbIndexReq) GetTermRegex() []byte {
	if m != nil {
		return m.TermRegex
	}
	return nil
}

func (m *RpbIndexReq) GetPaginationSort() bool {
	if m != nil && m.PaginationSort != nil {
		return *m.PaginationSort
	}
	return false
}

func (m *RpbIndexReq) GetCoverContext() []byte {
	if m != nil {
		return m.CoverContext
	}
	return nil
}

func (m *RpbIndexReq) GetReturnBody() bool {
	if m != nil && m.ReturnBody != nil {
		return *m.ReturnBody
	}
	return false
}

// Secondary Index query response
type RpbIndexResp struct {
	Keys             [][]byte        `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
	Results          []*riak.RpbPair `protobuf:"bytes,2,rep,name=results" json:"results,omitempty"`
	Continuation     []byte          `protobuf:"bytes,3,opt,name=continuation" json:"continuation,omitempty"`
	Done             *bool           `protobuf:"varint,4,opt,name=done" json:"done,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *RpbIndexResp) Reset()                    { *m = RpbIndexResp{} }
func (m *RpbIndexResp) String() string            { return proto.CompactTextString(m) }
func (*RpbIndexResp) ProtoMessage()               {}
func (*RpbIndexResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *RpbIndexResp) GetKeys() [][]byte {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *RpbIndexResp) GetResults() []*riak.RpbPair {
	if m != nil {
		return m.Results
	}
	return nil
}

func (m *RpbIndexResp) GetContinuation() []byte {
	if m != nil {
		return m.Continuation
	}
	return nil
}

func (m *RpbIndexResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return false
}

// Stolen from CS bucket response, to be used when return_body=true
type RpbIndexBodyResp struct {
	Objects          []*RpbIndexObject `protobuf:"bytes,1,rep,name=objects" json:"objects,omitempty"`
	Continuation     []byte            `protobuf:"bytes,2,opt,name=continuation" json:"continuation,omitempty"`
	Done             *bool             `protobuf:"varint,3,opt,name=done" json:"done,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *RpbIndexBodyResp) Reset()                    { *m = RpbIndexBodyResp{} }
func (m *RpbIndexBodyResp) String() string            { return proto.CompactTextString(m) }
func (*RpbIndexBodyResp) ProtoMessage()               {}
func (*RpbIndexBodyResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *RpbIndexBodyResp) GetObjects() []*RpbIndexObject {
	if m != nil {
		return m.Objects
	}
	return nil
}

func (m *RpbIndexBodyResp) GetContinuation() []byte {
	if m != nil {
		return m.Continuation
	}
	return nil
}

func (m *RpbIndexBodyResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return false
}

// added solely for riak_cs currently
// for folding over a bucket and returning
// objects.
type RpbCSBucketReq struct {
	Bucket       []byte  `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	StartKey     []byte  `protobuf:"bytes,2,req,name=start_key" json:"start_key,omitempty"`
	EndKey       []byte  `protobuf:"bytes,3,opt,name=end_key" json:"end_key,omitempty"`
	StartIncl    *bool   `protobuf:"varint,4,opt,name=start_incl,def=1" json:"start_incl,omitempty"`
	EndIncl      *bool   `protobuf:"varint,5,opt,name=end_incl,def=0" json:"end_incl,omitempty"`
	Continuation []byte  `protobuf:"bytes,6,opt,name=continuation" json:"continuation,omitempty"`
	MaxResults   *uint32 `protobuf:"varint,7,opt,name=max_results" json:"max_results,omitempty"`
	Timeout      *uint32 `protobuf:"varint,8,opt,name=timeout" json:"timeout,omitempty"`
	Type         []byte  `protobuf:"bytes,9,opt,name=type" json:"type,omitempty"`
	// parallel extraction extension
	CoverContext     []byte `protobuf:"bytes,10,opt,name=cover_context" json:"cover_context,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbCSBucketReq) Reset()                    { *m = RpbCSBucketReq{} }
func (m *RpbCSBucketReq) String() string            { return proto.CompactTextString(m) }
func (*RpbCSBucketReq) ProtoMessage()               {}
func (*RpbCSBucketReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

const Default_RpbCSBucketReq_StartIncl bool = true
const Default_RpbCSBucketReq_EndIncl bool = false

func (m *RpbCSBucketReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbCSBucketReq) GetStartKey() []byte {
	if m != nil {
		return m.StartKey
	}
	return nil
}

func (m *RpbCSBucketReq) GetEndKey() []byte {
	if m != nil {
		return m.EndKey
	}
	return nil
}

func (m *RpbCSBucketReq) GetStartIncl() bool {
	if m != nil && m.StartIncl != nil {
		return *m.StartIncl
	}
	return Default_RpbCSBucketReq_StartIncl
}

func (m *RpbCSBucketReq) GetEndIncl() bool {
	if m != nil && m.EndIncl != nil {
		return *m.EndIncl
	}
	return Default_RpbCSBucketReq_EndIncl
}

func (m *RpbCSBucketReq) GetContinuation() []byte {
	if m != nil {
		return m.Continuation
	}
	return nil
}

func (m *RpbCSBucketReq) GetMaxResults() uint32 {
	if m != nil && m.MaxResults != nil {
		return *m.MaxResults
	}
	return 0
}

func (m *RpbCSBucketReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

func (m *RpbCSBucketReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RpbCSBucketReq) GetCoverContext() []byte {
	if m != nil {
		return m.CoverContext
	}
	return nil
}

// return for CS bucket fold
type RpbCSBucketResp struct {
	Objects          []*RpbIndexObject `protobuf:"bytes,1,rep,name=objects" json:"objects,omitempty"`
	Continuation     []byte            `protobuf:"bytes,2,opt,name=continuation" json:"continuation,omitempty"`
	Done             *bool             `protobuf:"varint,3,opt,name=done" json:"done,omitempty"`
	XXX_unrecognized []byte            `json:"-"`
}

func (m *RpbCSBucketResp) Reset()                    { *m = RpbCSBucketResp{} }
func (m *RpbCSBucketResp) String() string            { return proto.CompactTextString(m) }
func (*RpbCSBucketResp) ProtoMessage()               {}
func (*RpbCSBucketResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *RpbCSBucketResp) GetObjects() []*RpbIndexObject {
	if m != nil {
		return m.Objects
	}
	return nil
}

func (m *RpbCSBucketResp) GetContinuation() []byte {
	if m != nil {
		return m.Continuation
	}
	return nil
}

func (m *RpbCSBucketResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return false
}

type RpbIndexObject struct {
	Key              []byte      `protobuf:"bytes,1,req,name=key" json:"key,omitempty"`
	Object           *RpbGetResp `protobuf:"bytes,2,req,name=object" json:"object,omitempty"`
	XXX_unrecognized []byte      `json:"-"`
}

func (m *RpbIndexObject) Reset()                    { *m = RpbIndexObject{} }
func (m *RpbIndexObject) String() string            { return proto.CompactTextString(m) }
func (*RpbIndexObject) ProtoMessage()               {}
func (*RpbIndexObject) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *RpbIndexObject) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbIndexObject) GetObject() *RpbGetResp {
	if m != nil {
		return m.Object
	}
	return nil
}

// Content message included in get/put responses
// Holds the value and associated metadata
type RpbContent struct {
	Value            []byte          `protobuf:"bytes,1,req,name=value" json:"value,omitempty"`
	ContentType      []byte          `protobuf:"bytes,2,opt,name=content_type" json:"content_type,omitempty"`
	Charset          []byte          `protobuf:"bytes,3,opt,name=charset" json:"charset,omitempty"`
	ContentEncoding  []byte          `protobuf:"bytes,4,opt,name=content_encoding" json:"content_encoding,omitempty"`
	Vtag             []byte          `protobuf:"bytes,5,opt,name=vtag" json:"vtag,omitempty"`
	Links            []*RpbLink      `protobuf:"bytes,6,rep,name=links" json:"links,omitempty"`
	LastMod          *uint32         `protobuf:"varint,7,opt,name=last_mod" json:"last_mod,omitempty"`
	LastModUsecs     *uint32         `protobuf:"varint,8,opt,name=last_mod_usecs" json:"last_mod_usecs,omitempty"`
	Usermeta         []*riak.RpbPair `protobuf:"bytes,9,rep,name=usermeta" json:"usermeta,omitempty"`
	Indexes          []*riak.RpbPair `protobuf:"bytes,10,rep,name=indexes" json:"indexes,omitempty"`
	Deleted          *bool           `protobuf:"varint,11,opt,name=deleted" json:"deleted,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *RpbContent) Reset()                    { *m = RpbContent{} }
func (m *RpbContent) String() string            { return proto.CompactTextString(m) }
func (*RpbContent) ProtoMessage()               {}
func (*RpbContent) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{19} }

func (m *RpbContent) GetValue() []byte {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *RpbContent) GetContentType() []byte {
	if m != nil {
		return m.ContentType
	}
	return nil
}

func (m *RpbContent) GetCharset() []byte {
	if m != nil {
		return m.Charset
	}
	return nil
}

func (m *RpbContent) GetContentEncoding() []byte {
	if m != nil {
		return m.ContentEncoding
	}
	return nil
}

func (m *RpbContent) GetVtag() []byte {
	if m != nil {
		return m.Vtag
	}
	return nil
}

func (m *RpbContent) GetLinks() []*RpbLink {
	if m != nil {
		return m.Links
	}
	return nil
}

func (m *RpbContent) GetLastMod() uint32 {
	if m != nil && m.LastMod != nil {
		return *m.LastMod
	}
	return 0
}

func (m *RpbContent) GetLastModUsecs() uint32 {
	if m != nil && m.LastModUsecs != nil {
		return *m.LastModUsecs
	}
	return 0
}

func (m *RpbContent) GetUsermeta() []*riak.RpbPair {
	if m != nil {
		return m.Usermeta
	}
	return nil
}

func (m *RpbContent) GetIndexes() []*riak.RpbPair {
	if m != nil {
		return m.Indexes
	}
	return nil
}

func (m *RpbContent) GetDeleted() bool {
	if m != nil && m.Deleted != nil {
		return *m.Deleted
	}
	return false
}

// Link metadata
type RpbLink struct {
	Bucket           []byte `protobuf:"bytes,1,opt,name=bucket" json:"bucket,omitempty"`
	Key              []byte `protobuf:"bytes,2,opt,name=key" json:"key,omitempty"`
	Tag              []byte `protobuf:"bytes,3,opt,name=tag" json:"tag,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbLink) Reset()                    { *m = RpbLink{} }
func (m *RpbLink) String() string            { return proto.CompactTextString(m) }
func (*RpbLink) ProtoMessage()               {}
func (*RpbLink) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{20} }

func (m *RpbLink) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbLink) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbLink) GetTag() []byte {
	if m != nil {
		return m.Tag
	}
	return nil
}

// Counter update request
type RpbCounterUpdateReq struct {
	Bucket           []byte  `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Key              []byte  `protobuf:"bytes,2,req,name=key" json:"key,omitempty"`
	Amount           *int64  `protobuf:"zigzag64,3,req,name=amount" json:"amount,omitempty"`
	W                *uint32 `protobuf:"varint,4,opt,name=w" json:"w,omitempty"`
	Dw               *uint32 `protobuf:"varint,5,opt,name=dw" json:"dw,omitempty"`
	Pw               *uint32 `protobuf:"varint,6,opt,name=pw" json:"pw,omitempty"`
	Returnvalue      *bool   `protobuf:"varint,7,opt,name=returnvalue" json:"returnvalue,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbCounterUpdateReq) Reset()                    { *m = RpbCounterUpdateReq{} }
func (m *RpbCounterUpdateReq) String() string            { return proto.CompactTextString(m) }
func (*RpbCounterUpdateReq) ProtoMessage()               {}
func (*RpbCounterUpdateReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{21} }

func (m *RpbCounterUpdateReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbCounterUpdateReq) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbCounterUpdateReq) GetAmount() int64 {
	if m != nil && m.Amount != nil {
		return *m.Amount
	}
	return 0
}

func (m *RpbCounterUpdateReq) GetW() uint32 {
	if m != nil && m.W != nil {
		return *m.W
	}
	return 0
}

func (m *RpbCounterUpdateReq) GetDw() uint32 {
	if m != nil && m.Dw != nil {
		return *m.Dw
	}
	return 0
}

func (m *RpbCounterUpdateReq) GetPw() uint32 {
	if m != nil && m.Pw != nil {
		return *m.Pw
	}
	return 0
}

func (m *RpbCounterUpdateReq) GetReturnvalue() bool {
	if m != nil && m.Returnvalue != nil {
		return *m.Returnvalue
	}
	return false
}

// Counter update response? No message | error response
type RpbCounterUpdateResp struct {
	Value            *int64 `protobuf:"zigzag64,1,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbCounterUpdateResp) Reset()                    { *m = RpbCounterUpdateResp{} }
func (m *RpbCounterUpdateResp) String() string            { return proto.CompactTextString(m) }
func (*RpbCounterUpdateResp) ProtoMessage()               {}
func (*RpbCounterUpdateResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{22} }

func (m *RpbCounterUpdateResp) GetValue() int64 {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return 0
}

// counter value
type RpbCounterGetReq struct {
	Bucket           []byte  `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Key              []byte  `protobuf:"bytes,2,req,name=key" json:"key,omitempty"`
	R                *uint32 `protobuf:"varint,3,opt,name=r" json:"r,omitempty"`
	Pr               *uint32 `protobuf:"varint,4,opt,name=pr" json:"pr,omitempty"`
	BasicQuorum      *bool   `protobuf:"varint,5,opt,name=basic_quorum" json:"basic_quorum,omitempty"`
	NotfoundOk       *bool   `protobuf:"varint,6,opt,name=notfound_ok" json:"notfound_ok,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbCounterGetReq) Reset()                    { *m = RpbCounterGetReq{} }
func (m *RpbCounterGetReq) String() string            { return proto.CompactTextString(m) }
func (*RpbCounterGetReq) ProtoMessage()               {}
func (*RpbCounterGetReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{23} }

func (m *RpbCounterGetReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbCounterGetReq) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbCounterGetReq) GetR() uint32 {
	if m != nil && m.R != nil {
		return *m.R
	}
	return 0
}

func (m *RpbCounterGetReq) GetPr() uint32 {
	if m != nil && m.Pr != nil {
		return *m.Pr
	}
	return 0
}

func (m *RpbCounterGetReq) GetBasicQuorum() bool {
	if m != nil && m.BasicQuorum != nil {
		return *m.BasicQuorum
	}
	return false
}

func (m *RpbCounterGetReq) GetNotfoundOk() bool {
	if m != nil && m.NotfoundOk != nil {
		return *m.NotfoundOk
	}
	return false
}

// Counter value response
type RpbCounterGetResp struct {
	Value            *int64 `protobuf:"zigzag64,1,opt,name=value" json:"value,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbCounterGetResp) Reset()                    { *m = RpbCounterGetResp{} }
func (m *RpbCounterGetResp) String() string            { return proto.CompactTextString(m) }
func (*RpbCounterGetResp) ProtoMessage()               {}
func (*RpbCounterGetResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{24} }

func (m *RpbCounterGetResp) GetValue() int64 {
	if m != nil && m.Value != nil {
		return *m.Value
	}
	return 0
}

// Get bucket-key preflist request
type RpbGetBucketKeyPreflistReq struct {
	Bucket           []byte `protobuf:"bytes,1,req,name=bucket" json:"bucket,omitempty"`
	Key              []byte `protobuf:"bytes,2,req,name=key" json:"key,omitempty"`
	Type             []byte `protobuf:"bytes,3,opt,name=type" json:"type,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbGetBucketKeyPreflistReq) Reset()                    { *m = RpbGetBucketKeyPreflistReq{} }
func (m *RpbGetBucketKeyPreflistReq) String() string            { return proto.CompactTextString(m) }
func (*RpbGetBucketKeyPreflistReq) ProtoMessage()               {}
func (*RpbGetBucketKeyPreflistReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{25} }

func (m *RpbGetBucketKeyPreflistReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbGetBucketKeyPreflistReq) GetKey() []byte {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *RpbGetBucketKeyPreflistReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

// Get bucket-key preflist response
type RpbGetBucketKeyPreflistResp struct {
	Preflist         []*RpbBucketKeyPreflistItem `protobuf:"bytes,1,rep,name=preflist" json:"preflist,omitempty"`
	XXX_unrecognized []byte                      `json:"-"`
}

func (m *RpbGetBucketKeyPreflistResp) Reset()                    { *m = RpbGetBucketKeyPreflistResp{} }
func (m *RpbGetBucketKeyPreflistResp) String() string            { return proto.CompactTextString(m) }
func (*RpbGetBucketKeyPreflistResp) ProtoMessage()               {}
func (*RpbGetBucketKeyPreflistResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{26} }

func (m *RpbGetBucketKeyPreflistResp) GetPreflist() []*RpbBucketKeyPreflistItem {
	if m != nil {
		return m.Preflist
	}
	return nil
}

// Preflist item
type RpbBucketKeyPreflistItem struct {
	Partition        *int64 `protobuf:"varint,1,req,name=partition" json:"partition,omitempty"`
	Node             []byte `protobuf:"bytes,2,req,name=node" json:"node,omitempty"`
	Primary          *bool  `protobuf:"varint,3,req,name=primary" json:"primary,omitempty"`
	XXX_unrecognized []byte `json:"-"`
}

func (m *RpbBucketKeyPreflistItem) Reset()                    { *m = RpbBucketKeyPreflistItem{} }
func (m *RpbBucketKeyPreflistItem) String() string            { return proto.CompactTextString(m) }
func (*RpbBucketKeyPreflistItem) ProtoMessage()               {}
func (*RpbBucketKeyPreflistItem) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{27} }

func (m *RpbBucketKeyPreflistItem) GetPartition() int64 {
	if m != nil && m.Partition != nil {
		return *m.Partition
	}
	return 0
}

func (m *RpbBucketKeyPreflistItem) GetNode() []byte {
	if m != nil {
		return m.Node
	}
	return nil
}

func (m *RpbBucketKeyPreflistItem) GetPrimary() bool {
	if m != nil && m.Primary != nil {
		return *m.Primary
	}
	return false
}

// Request a segmented coverage plan for the specified bucket
type RpbCoverageReq struct {
	Type             []byte   `protobuf:"bytes,1,opt,name=type" json:"type,omitempty"`
	Bucket           []byte   `protobuf:"bytes,2,req,name=bucket" json:"bucket,omitempty"`
	MinPartitions    *uint32  `protobuf:"varint,3,opt,name=min_partitions" json:"min_partitions,omitempty"`
	ReplaceCover     []byte   `protobuf:"bytes,4,opt,name=replace_cover" json:"replace_cover,omitempty"`
	UnavailableCover [][]byte `protobuf:"bytes,5,rep,name=unavailable_cover" json:"unavailable_cover,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *RpbCoverageReq) Reset()                    { *m = RpbCoverageReq{} }
func (m *RpbCoverageReq) String() string            { return proto.CompactTextString(m) }
func (*RpbCoverageReq) ProtoMessage()               {}
func (*RpbCoverageReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{28} }

func (m *RpbCoverageReq) GetType() []byte {
	if m != nil {
		return m.Type
	}
	return nil
}

func (m *RpbCoverageReq) GetBucket() []byte {
	if m != nil {
		return m.Bucket
	}
	return nil
}

func (m *RpbCoverageReq) GetMinPartitions() uint32 {
	if m != nil && m.MinPartitions != nil {
		return *m.MinPartitions
	}
	return 0
}

func (m *RpbCoverageReq) GetReplaceCover() []byte {
	if m != nil {
		return m.ReplaceCover
	}
	return nil
}

func (m *RpbCoverageReq) GetUnavailableCover() [][]byte {
	if m != nil {
		return m.UnavailableCover
	}
	return nil
}

// Segmented coverage plan response
type RpbCoverageResp struct {
	Entries          []*RpbCoverageEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	XXX_unrecognized []byte              `json:"-"`
}

func (m *RpbCoverageResp) Reset()                    { *m = RpbCoverageResp{} }
func (m *RpbCoverageResp) String() string            { return proto.CompactTextString(m) }
func (*RpbCoverageResp) ProtoMessage()               {}
func (*RpbCoverageResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{29} }

func (m *RpbCoverageResp) GetEntries() []*RpbCoverageEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Segment of a coverage plan
type RpbCoverageEntry struct {
	Ip               []byte  `protobuf:"bytes,1,req,name=ip" json:"ip,omitempty"`
	Port             *uint32 `protobuf:"varint,2,req,name=port" json:"port,omitempty"`
	KeyspaceDesc     []byte  `protobuf:"bytes,3,opt,name=keyspace_desc" json:"keyspace_desc,omitempty"`
	CoverContext     []byte  `protobuf:"bytes,4,req,name=cover_context" json:"cover_context,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *RpbCoverageEntry) Reset()                    { *m = RpbCoverageEntry{} }
func (m *RpbCoverageEntry) String() string            { return proto.CompactTextString(m) }
func (*RpbCoverageEntry) ProtoMessage()               {}
func (*RpbCoverageEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{30} }

func (m *RpbCoverageEntry) GetIp() []byte {
	if m != nil {
		return m.Ip
	}
	return nil
}

func (m *RpbCoverageEntry) GetPort() uint32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

func (m *RpbCoverageEntry) GetKeyspaceDesc() []byte {
	if m != nil {
		return m.KeyspaceDesc
	}
	return nil
}

func (m *RpbCoverageEntry) GetCoverContext() []byte {
	if m != nil {
		return m.CoverContext
	}
	return nil
}

func init() {
	proto.RegisterType((*RpbGetClientIdResp)(nil), "RpbGetClientIdResp")
	proto.RegisterType((*RpbSetClientIdReq)(nil), "RpbSetClientIdReq")
	proto.RegisterType((*RpbGetReq)(nil), "RpbGetReq")
	proto.RegisterType((*RpbGetResp)(nil), "RpbGetResp")
	proto.RegisterType((*RpbPutReq)(nil), "RpbPutReq")
	proto.RegisterType((*RpbPutResp)(nil), "RpbPutResp")
	proto.RegisterType((*RpbDelReq)(nil), "RpbDelReq")
	proto.RegisterType((*RpbListBucketsReq)(nil), "RpbListBucketsReq")
	proto.RegisterType((*RpbListBucketsResp)(nil), "RpbListBucketsResp")
	proto.RegisterType((*RpbListKeysReq)(nil), "RpbListKeysReq")
	proto.RegisterType((*RpbListKeysResp)(nil), "RpbListKeysResp")
	proto.RegisterType((*RpbMapRedReq)(nil), "RpbMapRedReq")
	proto.RegisterType((*RpbMapRedResp)(nil), "RpbMapRedResp")
	proto.RegisterType((*RpbIndexReq)(nil), "RpbIndexReq")
	proto.RegisterType((*RpbIndexResp)(nil), "RpbIndexResp")
	proto.RegisterType((*RpbIndexBodyResp)(nil), "RpbIndexBodyResp")
	proto.RegisterType((*RpbCSBucketReq)(nil), "RpbCSBucketReq")
	proto.RegisterType((*RpbCSBucketResp)(nil), "RpbCSBucketResp")
	proto.RegisterType((*RpbIndexObject)(nil), "RpbIndexObject")
	proto.RegisterType((*RpbContent)(nil), "RpbContent")
	proto.RegisterType((*RpbLink)(nil), "RpbLink")
	proto.RegisterType((*RpbCounterUpdateReq)(nil), "RpbCounterUpdateReq")
	proto.RegisterType((*RpbCounterUpdateResp)(nil), "RpbCounterUpdateResp")
	proto.RegisterType((*RpbCounterGetReq)(nil), "RpbCounterGetReq")
	proto.RegisterType((*RpbCounterGetResp)(nil), "RpbCounterGetResp")
	proto.RegisterType((*RpbGetBucketKeyPreflistReq)(nil), "RpbGetBucketKeyPreflistReq")
	proto.RegisterType((*RpbGetBucketKeyPreflistResp)(nil), "RpbGetBucketKeyPreflistResp")
	proto.RegisterType((*RpbBucketKeyPreflistItem)(nil), "RpbBucketKeyPreflistItem")
	proto.RegisterType((*RpbCoverageReq)(nil), "RpbCoverageReq")
	proto.RegisterType((*RpbCoverageResp)(nil), "RpbCoverageResp")
	proto.RegisterType((*RpbCoverageEntry)(nil), "RpbCoverageEntry")
	proto.RegisterEnum("RpbIndexReq_IndexQueryType", RpbIndexReq_IndexQueryType_name, RpbIndexReq_IndexQueryType_value)
}

func init() { proto.RegisterFile("riak_kv.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1362 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xbc, 0x57, 0xcd, 0x6e, 0x1b, 0x47,
	0x12, 0x5e, 0x52, 0xfc, 0x19, 0x16, 0x7f, 0x24, 0x8d, 0x2d, 0x6b, 0x64, 0xef, 0x41, 0x18, 0x63,
	0x77, 0x85, 0x5d, 0xac, 0x0e, 0x36, 0x7c, 0xf1, 0x61, 0x17, 0x90, 0x13, 0x18, 0x8e, 0x6d, 0x44,
	0xa1, 0x13, 0x24, 0x48, 0x0e, 0x83, 0xe6, 0x4c, 0x49, 0xea, 0x70, 0xd8, 0xd3, 0xea, 0xee, 0xa1,
	0xc4, 0x3c, 0x50, 0x5e, 0x24, 0x2f, 0x91, 0x57, 0xc8, 0x03, 0xe4, 0x90, 0x5b, 0xd0, 0xd5, 0x3d,
	0xe4, 0x90, 0x94, 0x63, 0x04, 0x30, 0x72, 0xe3, 0x74, 0x57, 0x57, 0x55, 0x7f, 0xf5, 0xd5, 0x57,
	0x4d, 0x18, 0x2a, 0xce, 0xa6, 0xc9, 0x74, 0x7e, 0x2a, 0x55, 0x61, 0x8a, 0x87, 0x60, 0x3f, 0xdd,
	0xef, 0xf8, 0x5f, 0x10, 0x8e, 0xe5, 0xe4, 0x25, 0x9a, 0x17, 0x39, 0x47, 0x61, 0x5e, 0x65, 0x63,
	0xd4, 0x32, 0xdc, 0x87, 0x5e, 0x4a, 0xdf, 0x09, 0xcf, 0xa2, 0xc6, 0x71, 0xf3, 0x64, 0x10, 0xff,
	0x13, 0xf6, 0xc7, 0x72, 0xf2, 0xae, 0x6e, 0x78, 0x7d, 0x97, 0xdd, 0x2f, 0x0d, 0xe8, 0x39, 0x8f,
	0xd6, 0x60, 0x04, 0x9d, 0x49, 0x99, 0x4e, 0xd1, 0xb8, 0xdd, 0xb0, 0x0f, 0x3b, 0x53, 0x5c, 0x44,
	0x4d, 0xfa, 0xe8, 0x41, 0x43, 0x45, 0x3b, 0xc7, 0x8d, 0x93, 0x61, 0x08, 0xd0, 0x94, 0x2a, 0x6a,
	0xd1, 0xef, 0xfb, 0x30, 0x98, 0x30, 0xcd, 0xd3, 0xe4, 0xba, 0x2c, 0x54, 0x39, 0x8b, 0xda, 0xc7,
	0x8d, 0x93, 0x20, 0xbc, 0x07, 0x7d, 0x51, 0x98, 0x8b, 0xa2, 0x14, 0x59, 0x52, 0x4c, 0xa3, 0x4e,
	0xb5, 0xc8, 0x2f, 0x92, 0x59, 0x91, 0xf1, 0x0b, 0x8e, 0x59, 0xd4, 0x3d, 0x6e, 0x9c, 0x0c, 0xc2,
	0x01, 0xb4, 0xae, 0x90, 0x65, 0x51, 0x40, 0x26, 0x07, 0x30, 0xcc, 0x30, 0x47, 0x83, 0xd9, 0x3c,
	0xcd, 0x8b, 0x74, 0x1a, 0xf5, 0x68, 0x79, 0x17, 0xba, 0x86, 0xcf, 0xb0, 0x28, 0x4d, 0x04, 0x14,
	0xf5, 0x00, 0x86, 0x3a, 0x2f, 0xa4, 0x5c, 0x54, 0x61, 0xfb, 0x64, 0x37, 0x84, 0xb6, 0x48, 0xe6,
	0x2c, 0x8f, 0x06, 0x64, 0x35, 0x80, 0x96, 0x59, 0x48, 0x8c, 0x86, 0x36, 0x52, 0xfc, 0x16, 0xa0,
	0xba, 0xaa, 0x96, 0xe1, 0xdf, 0xa1, 0x9b, 0x16, 0xc2, 0xa0, 0xb0, 0x97, 0xdd, 0x39, 0xe9, 0x3f,
	0xe9, 0x9f, 0x8e, 0xe5, 0xe4, 0x85, 0x5b, 0xb2, 0x48, 0xf8, 0x04, 0x9a, 0x94, 0xe5, 0x3e, 0xf4,
	0x4a, 0x91, 0x5e, 0x31, 0x71, 0x89, 0x19, 0x81, 0x10, 0xc4, 0x3f, 0x36, 0x09, 0xba, 0xf3, 0xf2,
	0x8f, 0xa1, 0xb3, 0xa7, 0x57, 0xde, 0x76, 0xe8, 0xbb, 0x16, 0xbb, 0x75, 0xdc, 0xdc, 0x8c, 0xdd,
	0x83, 0xc6, 0x0d, 0xc1, 0x48, 0x40, 0x67, 0x37, 0x84, 0xde, 0xd0, 0xa2, 0xa7, 0xd0, 0x94, 0x4a,
	0x24, 0x93, 0x22, 0x5b, 0x10, 0x7a, 0x01, 0x55, 0xe2, 0x86, 0xb0, 0x1b, 0x86, 0x87, 0xb0, 0xcb,
	0x2f, 0x12, 0x51, 0x98, 0x15, 0xc4, 0xbd, 0x0a, 0x54, 0xda, 0x10, 0x98, 0xcc, 0x98, 0x49, 0xaf,
	0x08, 0xc3, 0xa0, 0xe6, 0x90, 0x0a, 0xd0, 0xdf, 0x44, 0x7a, 0x89, 0x21, 0xd3, 0x5c, 0x13, 0x86,
	0xc1, 0x36, 0xee, 0xa3, 0x75, 0xdc, 0x77, 0xd7, 0x70, 0xdf, 0x23, 0xdc, 0x5f, 0x12, 0xee, 0x84,
	0xd3, 0x9f, 0xc6, 0xdd, 0xc3, 0x48, 0xb0, 0xc5, 0x3f, 0x39, 0xb2, 0x7e, 0x82, 0xf9, 0x07, 0xc9,
	0x0a, 0xd0, 0x54, 0x37, 0x9e, 0xad, 0x2b, 0x9f, 0x2d, 0xf2, 0x49, 0x44, 0x76, 0xf8, 0x12, 0xd4,
	0x9d, 0x1a, 0xa7, 0xbb, 0xcb, 0xdf, 0x15, 0xaa, 0xae, 0x04, 0x3d, 0xfa, 0xfd, 0x51, 0x68, 0x78,
	0x46, 0xad, 0xf9, 0x86, 0x6b, 0x73, 0x46, 0xe9, 0x6b, 0x7b, 0x99, 0x9a, 0xe7, 0x46, 0x95, 0xb4,
	0x36, 0x0a, 0xd9, 0x8c, 0x80, 0x08, 0x96, 0x3e, 0x1c, 0x12, 0x4f, 0x49, 0x07, 0xd6, 0x7c, 0x68,
	0x69, 0x9d, 0x38, 0x44, 0x34, 0x41, 0x4b, 0xbd, 0x95, 0x15, 0x02, 0x9d, 0x8b, 0xf8, 0xff, 0x30,
	0xf2, 0x87, 0x5e, 0xe3, 0x42, 0xdf, 0x05, 0x61, 0x2d, 0x8b, 0xe6, 0x5a, 0xe6, 0x2e, 0xea, 0x7f,
	0x61, 0x77, 0xcd, 0x81, 0x96, 0xd6, 0x60, 0x8a, 0x8b, 0xbb, 0xe3, 0x3d, 0x83, 0xc1, 0x58, 0x4e,
	0xde, 0x32, 0x39, 0xc6, 0xcc, 0xdf, 0x51, 0xe1, 0x75, 0x89, 0xba, 0x0a, 0x77, 0x1f, 0x06, 0x9e,
	0x0a, 0x09, 0x45, 0xa1, 0xd2, 0xc5, 0xff, 0x83, 0x61, 0xed, 0x98, 0x96, 0x16, 0x4d, 0x79, 0xc5,
	0x34, 0x7a, 0x64, 0xf6, 0x20, 0x50, 0xa8, 0x65, 0x21, 0x34, 0x7a, 0x92, 0x54, 0x61, 0x5d, 0x5f,
	0xfe, 0xd6, 0x84, 0xfe, 0x58, 0x4e, 0x5e, 0x89, 0x0c, 0x6f, 0xef, 0xba, 0xe4, 0x10, 0xda, 0xdc,
	0xee, 0x79, 0xa6, 0xfc, 0x1b, 0xda, 0xd7, 0xfe, 0x8e, 0xcd, 0x93, 0xd1, 0x93, 0x47, 0xa7, 0xb5,
	0xb3, 0xa7, 0xf4, 0xe3, 0x8b, 0x12, 0xd5, 0xe2, 0xcb, 0x85, 0xc4, 0x8a, 0x62, 0xad, 0x4a, 0x12,
	0x94, 0xd5, 0x83, 0x64, 0xc6, 0x05, 0xd1, 0xa9, 0xbe, 0xc4, 0x6e, 0x89, 0x56, 0x74, 0x47, 0xdf,
	0x64, 0x06, 0xd5, 0x4c, 0xfb, 0xb6, 0x5d, 0x55, 0x37, 0xa8, 0x5a, 0x71, 0xc6, 0x6e, 0x13, 0x85,
	0xba, 0xcc, 0x8d, 0xf6, 0x6c, 0xf3, 0xf0, 0x70, 0x51, 0x32, 0xc3, 0x0b, 0x41, 0x94, 0x5b, 0xab,
	0x51, 0x7f, 0xad, 0x46, 0x03, 0xda, 0x0e, 0x01, 0x6c, 0xa0, 0x44, 0xe1, 0x25, 0xde, 0x3a, 0xc6,
	0x59, 0x61, 0x90, 0xec, 0x92, 0x0b, 0x72, 0x93, 0xe8, 0x42, 0x19, 0xdf, 0xb6, 0x07, 0x30, 0x4c,
	0x8b, 0x39, 0xaa, 0x84, 0xca, 0x70, 0x6b, 0xa8, 0x7d, 0x07, 0x9b, 0x4a, 0xb3, 0x47, 0xb0, 0x3e,
	0x86, 0xd1, 0x06, 0x1a, 0x1d, 0x68, 0xe2, 0xf5, 0xde, 0xdf, 0xc2, 0x1e, 0xb4, 0xe9, 0xd6, 0x7b,
	0x8d, 0xf8, 0x3b, 0x2a, 0xb9, 0x87, 0x6f, 0x8b, 0x1e, 0x47, 0x96, 0x00, 0xee, 0x86, 0x4d, 0x6a,
	0xfd, 0xc0, 0x82, 0x7d, 0xce, 0xb8, 0xda, 0xba, 0xeb, 0xce, 0x5a, 0x61, 0x5b, 0x94, 0xc1, 0x37,
	0xb0, 0x57, 0x39, 0x3f, 0x2b, 0xb2, 0x05, 0x05, 0x38, 0x86, 0x6e, 0x31, 0xf9, 0x1e, 0x53, 0x4f,
	0xf9, 0xfe, 0x93, 0xdd, 0x65, 0xfd, 0x3e, 0xa7, 0xf5, 0x2d, 0xcf, 0x77, 0x51, 0xe6, 0xe7, 0x06,
	0xb5, 0xc6, 0x8b, 0x77, 0xae, 0x9b, 0xee, 0x62, 0xcd, 0x3e, 0xf4, 0xb4, 0x61, 0xca, 0x24, 0x2b,
	0x8d, 0xd9, 0x85, 0x2e, 0x8a, 0x2c, 0x59, 0xea, 0x53, 0x18, 0x01, 0x38, 0x1b, 0x2e, 0xd2, 0xdc,
	0x25, 0xfd, 0xbc, 0x65, 0x54, 0x89, 0xe1, 0x21, 0x04, 0xd6, 0x94, 0xd6, 0x69, 0x40, 0x3e, 0x6f,
	0x5f, 0xb0, 0x5c, 0xe3, 0x56, 0x76, 0x9d, 0xaa, 0x00, 0x75, 0x3a, 0x74, 0x37, 0xc5, 0x27, 0x58,
	0x2b, 0x7c, 0x8f, 0xce, 0x6c, 0xd5, 0x92, 0xe8, 0x12, 0x7f, 0x4d, 0x3d, 0xbb, 0xba, 0xd9, 0x47,
	0xc3, 0xec, 0x39, 0x41, 0x56, 0x3f, 0xe5, 0xbb, 0xc3, 0xe1, 0xf5, 0x08, 0x3a, 0x2e, 0x08, 0x81,
	0xe5, 0x55, 0xde, 0xcf, 0xde, 0xf8, 0xd7, 0x06, 0x8d, 0x84, 0x4a, 0xf4, 0x87, 0xd0, 0x9e, 0xb3,
	0xbc, 0xc4, 0xf7, 0xca, 0x82, 0xe7, 0x7d, 0x7a, 0xc5, 0x94, 0x46, 0xb3, 0x44, 0x7b, 0xaf, 0x32,
	0x43, 0x91, 0x16, 0x19, 0x17, 0x97, 0xbe, 0x33, 0x07, 0xd0, 0x9a, 0x1b, 0x76, 0xe9, 0x9b, 0xf2,
	0x10, 0xda, 0x39, 0x17, 0x53, 0x1d, 0x75, 0x56, 0x9c, 0x7b, 0xc3, 0xc5, 0xd4, 0x0a, 0x49, 0xce,
	0x34, 0x4d, 0x4b, 0x0f, 0xf1, 0x03, 0x18, 0x55, 0x2b, 0x49, 0xa9, 0x31, 0xd5, 0x1e, 0xe9, 0x87,
	0x10, 0x94, 0x1a, 0xd5, 0x0c, 0x0d, 0x8b, 0x7a, 0x1b, 0xcc, 0x3d, 0x82, 0x2e, 0xc9, 0x09, 0xea,
	0x08, 0x36, 0xb6, 0x76, 0xa1, 0xeb, 0x1f, 0x33, 0x6e, 0x2e, 0xc4, 0x4f, 0xa1, 0x5b, 0x05, 0xaf,
	0xf3, 0xab, 0xb1, 0xf9, 0x5e, 0xe8, 0xc3, 0x8e, 0xcd, 0xdf, 0xa9, 0xee, 0x0f, 0x70, 0x8f, 0xb0,
	0x2a, 0x85, 0x41, 0xf5, 0x95, 0xcc, 0x98, 0xc1, 0x0f, 0x8e, 0xbf, 0x11, 0x74, 0xd8, 0xcc, 0x9e,
	0x20, 0x55, 0x0b, 0xdd, 0x9c, 0x6b, 0xd5, 0xe6, 0x59, 0xbb, 0x36, 0xe7, 0x36, 0x9e, 0x17, 0xae,
	0x14, 0xa4, 0x53, 0xf1, 0x3f, 0xe0, 0xfe, 0x76, 0x6c, 0x27, 0xc9, 0x55, 0xc5, 0x1a, 0x27, 0x61,
	0x7c, 0x4d, 0x9d, 0xe9, 0xcd, 0xfe, 0x92, 0xb7, 0x64, 0x1c, 0xd3, 0x14, 0xad, 0x87, 0xdc, 0x4e,
	0xeb, 0x25, 0x3c, 0x74, 0xa4, 0x73, 0xe4, 0x7f, 0x8d, 0x8b, 0x73, 0x85, 0x17, 0x39, 0xd7, 0x1f,
	0x4e, 0x70, 0x7d, 0xf0, 0x7d, 0x06, 0x8f, 0xde, 0xeb, 0x48, 0xcb, 0xf0, 0x3f, 0x10, 0x48, 0xff,
	0xed, 0x3b, 0xea, 0xc8, 0x72, 0x60, 0xcb, 0xf8, 0x95, 0xc1, 0x59, 0xfc, 0x06, 0xa2, 0xf7, 0xed,
	0x59, 0x91, 0x91, 0x4c, 0x19, 0x4e, 0x4d, 0x67, 0xb3, 0xda, 0xb1, 0x89, 0x88, 0x22, 0xc3, 0x95,
	0xe4, 0x48, 0xc5, 0x67, 0x4c, 0x2d, 0xa8, 0xb0, 0x41, 0x7c, 0xeb, 0x84, 0xcb, 0x36, 0x3e, 0xbb,
	0x24, 0x5e, 0x54, 0x99, 0x37, 0xaa, 0x97, 0xa7, 0xbf, 0xa4, 0x73, 0xf0, 0x00, 0x46, 0x33, 0x2e,
	0x92, 0x65, 0x14, 0xed, 0xab, 0x70, 0x00, 0x43, 0x85, 0x32, 0x67, 0x29, 0x26, 0xa4, 0x22, 0xbe,
	0x93, 0x8e, 0x60, 0xbf, 0x14, 0x6c, 0xce, 0x78, 0xce, 0x26, 0x79, 0xb5, 0xd5, 0xb6, 0x62, 0x1e,
	0x3f, 0x73, 0xc2, 0xb2, 0x8c, 0xac, 0x65, 0x18, 0x5b, 0x41, 0x34, 0x8a, 0x63, 0x25, 0x2c, 0xfb,
	0xa7, 0x35, 0x93, 0x4f, 0x85, 0x51, 0x8b, 0xf8, 0x5b, 0x4f, 0x95, 0xda, 0x9a, 0xa5, 0x00, 0x97,
	0xbe, 0x0a, 0x03, 0x68, 0x49, 0x3b, 0xa0, 0x6c, 0xba, 0x94, 0x96, 0x9d, 0x1f, 0xd2, 0xe6, 0x95,
	0xa1, 0x4e, 0x7d, 0xeb, 0x6f, 0x69, 0x9d, 0x7d, 0x45, 0x0f, 0xce, 0x1e, 0xc3, 0x61, 0x5a, 0xcc,
	0x4e, 0x27, 0x4c, 0x5f, 0x15, 0xa7, 0xab, 0x7f, 0x4d, 0x93, 0xf2, 0xe2, 0x2c, 0x18, 0x73, 0x36,
	0x7d, 0x3d, 0x3f, 0x3f, 0xfb, 0x3d, 0x00, 0x00, 0xff, 0xff, 0x02, 0x3d, 0x92, 0x78, 0x5e, 0x0d,
	0x00, 0x00,
}
