// Copyright 2015-present Basho Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go.
// source: riak_ts.proto
// DO NOT EDIT!

/*
Package riak_ts is a generated protocol buffer package.

It is generated from these files:
	riak_ts.proto

It has these top-level messages:
	TsQueryReq
	TsQueryResp
	TsGetReq
	TsGetResp
	TsPutReq
	TsPutResp
	TsDelReq
	TsDelResp
	TsInterpolation
	TsColumnDescription
	TsRow
	TsCell
	TsListKeysReq
	TsListKeysResp
	TsCoverageReq
	TsCoverageResp
	TsCoverageEntry
	TsRange
*/
package riak_ts

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import riak "github.com/basho/riak-go-client/rpb/riak"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

type TsColumnType int32

const (
	TsColumnType_VARCHAR   TsColumnType = 0
	TsColumnType_SINT64    TsColumnType = 1
	TsColumnType_DOUBLE    TsColumnType = 2
	TsColumnType_TIMESTAMP TsColumnType = 3
	TsColumnType_BOOLEAN   TsColumnType = 4
	TsColumnType_BLOB      TsColumnType = 5
)

var TsColumnType_name = map[int32]string{
	0: "VARCHAR",
	1: "SINT64",
	2: "DOUBLE",
	3: "TIMESTAMP",
	4: "BOOLEAN",
	5: "BLOB",
}
var TsColumnType_value = map[string]int32{
	"VARCHAR":   0,
	"SINT64":    1,
	"DOUBLE":    2,
	"TIMESTAMP": 3,
	"BOOLEAN":   4,
	"BLOB":      5,
}

func (x TsColumnType) Enum() *TsColumnType {
	p := new(TsColumnType)
	*p = x
	return p
}
func (x TsColumnType) String() string {
	return proto.EnumName(TsColumnType_name, int32(x))
}
func (x *TsColumnType) UnmarshalJSON(data []byte) error {
	value, err := proto.UnmarshalJSONEnum(TsColumnType_value, data, "TsColumnType")
	if err != nil {
		return err
	}
	*x = TsColumnType(value)
	return nil
}
func (TsColumnType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Dispatch a query to Riak
type TsQueryReq struct {
	// left optional to support parameterized queries in the future
	Query            *TsInterpolation `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	Stream           *bool            `protobuf:"varint,2,opt,name=stream,def=0" json:"stream,omitempty"`
	CoverContext     []byte           `protobuf:"bytes,3,opt,name=cover_context" json:"cover_context,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *TsQueryReq) Reset()                    { *m = TsQueryReq{} }
func (m *TsQueryReq) String() string            { return proto.CompactTextString(m) }
func (*TsQueryReq) ProtoMessage()               {}
func (*TsQueryReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

const Default_TsQueryReq_Stream bool = false

func (m *TsQueryReq) GetQuery() *TsInterpolation {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *TsQueryReq) GetStream() bool {
	if m != nil && m.Stream != nil {
		return *m.Stream
	}
	return Default_TsQueryReq_Stream
}

func (m *TsQueryReq) GetCoverContext() []byte {
	if m != nil {
		return m.CoverContext
	}
	return nil
}

type TsQueryResp struct {
	Columns          []*TsColumnDescription `protobuf:"bytes,1,rep,name=columns" json:"columns,omitempty"`
	Rows             []*TsRow               `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	Done             *bool                  `protobuf:"varint,3,opt,name=done,def=1" json:"done,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *TsQueryResp) Reset()                    { *m = TsQueryResp{} }
func (m *TsQueryResp) String() string            { return proto.CompactTextString(m) }
func (*TsQueryResp) ProtoMessage()               {}
func (*TsQueryResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

const Default_TsQueryResp_Done bool = true

func (m *TsQueryResp) GetColumns() []*TsColumnDescription {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *TsQueryResp) GetRows() []*TsRow {
	if m != nil {
		return m.Rows
	}
	return nil
}

func (m *TsQueryResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return Default_TsQueryResp_Done
}

type TsGetReq struct {
	Table            []byte    `protobuf:"bytes,1,req,name=table" json:"table,omitempty"`
	Key              []*TsCell `protobuf:"bytes,2,rep,name=key" json:"key,omitempty"`
	Timeout          *uint32   `protobuf:"varint,3,opt,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *TsGetReq) Reset()                    { *m = TsGetReq{} }
func (m *TsGetReq) String() string            { return proto.CompactTextString(m) }
func (*TsGetReq) ProtoMessage()               {}
func (*TsGetReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *TsGetReq) GetTable() []byte {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *TsGetReq) GetKey() []*TsCell {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TsGetReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

type TsGetResp struct {
	Columns          []*TsColumnDescription `protobuf:"bytes,1,rep,name=columns" json:"columns,omitempty"`
	Rows             []*TsRow               `protobuf:"bytes,2,rep,name=rows" json:"rows,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *TsGetResp) Reset()                    { *m = TsGetResp{} }
func (m *TsGetResp) String() string            { return proto.CompactTextString(m) }
func (*TsGetResp) ProtoMessage()               {}
func (*TsGetResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *TsGetResp) GetColumns() []*TsColumnDescription {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *TsGetResp) GetRows() []*TsRow {
	if m != nil {
		return m.Rows
	}
	return nil
}

type TsPutReq struct {
	Table []byte `protobuf:"bytes,1,req,name=table" json:"table,omitempty"`
	// optional: omitting it should use table order
	Columns          []*TsColumnDescription `protobuf:"bytes,2,rep,name=columns" json:"columns,omitempty"`
	Rows             []*TsRow               `protobuf:"bytes,3,rep,name=rows" json:"rows,omitempty"`
	XXX_unrecognized []byte                 `json:"-"`
}

func (m *TsPutReq) Reset()                    { *m = TsPutReq{} }
func (m *TsPutReq) String() string            { return proto.CompactTextString(m) }
func (*TsPutReq) ProtoMessage()               {}
func (*TsPutReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *TsPutReq) GetTable() []byte {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *TsPutReq) GetColumns() []*TsColumnDescription {
	if m != nil {
		return m.Columns
	}
	return nil
}

func (m *TsPutReq) GetRows() []*TsRow {
	if m != nil {
		return m.Rows
	}
	return nil
}

type TsPutResp struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TsPutResp) Reset()                    { *m = TsPutResp{} }
func (m *TsPutResp) String() string            { return proto.CompactTextString(m) }
func (*TsPutResp) ProtoMessage()               {}
func (*TsPutResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

type TsDelReq struct {
	Table            []byte    `protobuf:"bytes,1,req,name=table" json:"table,omitempty"`
	Key              []*TsCell `protobuf:"bytes,2,rep,name=key" json:"key,omitempty"`
	Vclock           []byte    `protobuf:"bytes,3,opt,name=vclock" json:"vclock,omitempty"`
	Timeout          *uint32   `protobuf:"varint,4,opt,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *TsDelReq) Reset()                    { *m = TsDelReq{} }
func (m *TsDelReq) String() string            { return proto.CompactTextString(m) }
func (*TsDelReq) ProtoMessage()               {}
func (*TsDelReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *TsDelReq) GetTable() []byte {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *TsDelReq) GetKey() []*TsCell {
	if m != nil {
		return m.Key
	}
	return nil
}

func (m *TsDelReq) GetVclock() []byte {
	if m != nil {
		return m.Vclock
	}
	return nil
}

func (m *TsDelReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

type TsDelResp struct {
	XXX_unrecognized []byte `json:"-"`
}

func (m *TsDelResp) Reset()                    { *m = TsDelResp{} }
func (m *TsDelResp) String() string            { return proto.CompactTextString(m) }
func (*TsDelResp) ProtoMessage()               {}
func (*TsDelResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

type TsInterpolation struct {
	Base             []byte          `protobuf:"bytes,1,req,name=base" json:"base,omitempty"`
	Interpolations   []*riak.RpbPair `protobuf:"bytes,2,rep,name=interpolations" json:"interpolations,omitempty"`
	XXX_unrecognized []byte          `json:"-"`
}

func (m *TsInterpolation) Reset()                    { *m = TsInterpolation{} }
func (m *TsInterpolation) String() string            { return proto.CompactTextString(m) }
func (*TsInterpolation) ProtoMessage()               {}
func (*TsInterpolation) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *TsInterpolation) GetBase() []byte {
	if m != nil {
		return m.Base
	}
	return nil
}

func (m *TsInterpolation) GetInterpolations() []*riak.RpbPair {
	if m != nil {
		return m.Interpolations
	}
	return nil
}

type TsColumnDescription struct {
	Name             []byte        `protobuf:"bytes,1,req,name=name" json:"name,omitempty"`
	Type             *TsColumnType `protobuf:"varint,2,req,name=type,enum=TsColumnType" json:"type,omitempty"`
	XXX_unrecognized []byte        `json:"-"`
}

func (m *TsColumnDescription) Reset()                    { *m = TsColumnDescription{} }
func (m *TsColumnDescription) String() string            { return proto.CompactTextString(m) }
func (*TsColumnDescription) ProtoMessage()               {}
func (*TsColumnDescription) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *TsColumnDescription) GetName() []byte {
	if m != nil {
		return m.Name
	}
	return nil
}

func (m *TsColumnDescription) GetType() TsColumnType {
	if m != nil && m.Type != nil {
		return *m.Type
	}
	return TsColumnType_VARCHAR
}

type TsRow struct {
	Cells            []*TsCell `protobuf:"bytes,1,rep,name=cells" json:"cells,omitempty"`
	XXX_unrecognized []byte    `json:"-"`
}

func (m *TsRow) Reset()                    { *m = TsRow{} }
func (m *TsRow) String() string            { return proto.CompactTextString(m) }
func (*TsRow) ProtoMessage()               {}
func (*TsRow) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *TsRow) GetCells() []*TsCell {
	if m != nil {
		return m.Cells
	}
	return nil
}

type TsCell struct {
	VarcharValue     []byte   `protobuf:"bytes,1,opt,name=varchar_value" json:"varchar_value,omitempty"`
	Sint64Value      *int64   `protobuf:"zigzag64,2,opt,name=sint64_value" json:"sint64_value,omitempty"`
	TimestampValue   *int64   `protobuf:"zigzag64,3,opt,name=timestamp_value" json:"timestamp_value,omitempty"`
	BooleanValue     *bool    `protobuf:"varint,4,opt,name=boolean_value" json:"boolean_value,omitempty"`
	DoubleValue      *float64 `protobuf:"fixed64,5,opt,name=double_value" json:"double_value,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TsCell) Reset()                    { *m = TsCell{} }
func (m *TsCell) String() string            { return proto.CompactTextString(m) }
func (*TsCell) ProtoMessage()               {}
func (*TsCell) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *TsCell) GetVarcharValue() []byte {
	if m != nil {
		return m.VarcharValue
	}
	return nil
}

func (m *TsCell) GetSint64Value() int64 {
	if m != nil && m.Sint64Value != nil {
		return *m.Sint64Value
	}
	return 0
}

func (m *TsCell) GetTimestampValue() int64 {
	if m != nil && m.TimestampValue != nil {
		return *m.TimestampValue
	}
	return 0
}

func (m *TsCell) GetBooleanValue() bool {
	if m != nil && m.BooleanValue != nil {
		return *m.BooleanValue
	}
	return false
}

func (m *TsCell) GetDoubleValue() float64 {
	if m != nil && m.DoubleValue != nil {
		return *m.DoubleValue
	}
	return 0
}

type TsListKeysReq struct {
	Table            []byte  `protobuf:"bytes,1,req,name=table" json:"table,omitempty"`
	Timeout          *uint32 `protobuf:"varint,2,opt,name=timeout" json:"timeout,omitempty"`
	XXX_unrecognized []byte  `json:"-"`
}

func (m *TsListKeysReq) Reset()                    { *m = TsListKeysReq{} }
func (m *TsListKeysReq) String() string            { return proto.CompactTextString(m) }
func (*TsListKeysReq) ProtoMessage()               {}
func (*TsListKeysReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *TsListKeysReq) GetTable() []byte {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *TsListKeysReq) GetTimeout() uint32 {
	if m != nil && m.Timeout != nil {
		return *m.Timeout
	}
	return 0
}

type TsListKeysResp struct {
	Keys             []*TsRow `protobuf:"bytes,1,rep,name=keys" json:"keys,omitempty"`
	Done             *bool    `protobuf:"varint,2,opt,name=done" json:"done,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TsListKeysResp) Reset()                    { *m = TsListKeysResp{} }
func (m *TsListKeysResp) String() string            { return proto.CompactTextString(m) }
func (*TsListKeysResp) ProtoMessage()               {}
func (*TsListKeysResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *TsListKeysResp) GetKeys() []*TsRow {
	if m != nil {
		return m.Keys
	}
	return nil
}

func (m *TsListKeysResp) GetDone() bool {
	if m != nil && m.Done != nil {
		return *m.Done
	}
	return false
}

// Request a segmented coverage plan for this query
type TsCoverageReq struct {
	// left optional to support parameterized queries in the future
	Query            *TsInterpolation `protobuf:"bytes,1,opt,name=query" json:"query,omitempty"`
	Table            []byte           `protobuf:"bytes,2,req,name=table" json:"table,omitempty"`
	ReplaceCover     []byte           `protobuf:"bytes,3,opt,name=replace_cover" json:"replace_cover,omitempty"`
	UnavailableCover [][]byte         `protobuf:"bytes,4,rep,name=unavailable_cover" json:"unavailable_cover,omitempty"`
	XXX_unrecognized []byte           `json:"-"`
}

func (m *TsCoverageReq) Reset()                    { *m = TsCoverageReq{} }
func (m *TsCoverageReq) String() string            { return proto.CompactTextString(m) }
func (*TsCoverageReq) ProtoMessage()               {}
func (*TsCoverageReq) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *TsCoverageReq) GetQuery() *TsInterpolation {
	if m != nil {
		return m.Query
	}
	return nil
}

func (m *TsCoverageReq) GetTable() []byte {
	if m != nil {
		return m.Table
	}
	return nil
}

func (m *TsCoverageReq) GetReplaceCover() []byte {
	if m != nil {
		return m.ReplaceCover
	}
	return nil
}

func (m *TsCoverageReq) GetUnavailableCover() [][]byte {
	if m != nil {
		return m.UnavailableCover
	}
	return nil
}

// Segmented TS coverage plan response
type TsCoverageResp struct {
	Entries          []*TsCoverageEntry `protobuf:"bytes,1,rep,name=entries" json:"entries,omitempty"`
	XXX_unrecognized []byte             `json:"-"`
}

func (m *TsCoverageResp) Reset()                    { *m = TsCoverageResp{} }
func (m *TsCoverageResp) String() string            { return proto.CompactTextString(m) }
func (*TsCoverageResp) ProtoMessage()               {}
func (*TsCoverageResp) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *TsCoverageResp) GetEntries() []*TsCoverageEntry {
	if m != nil {
		return m.Entries
	}
	return nil
}

// Segment of a TS coverage plan
type TsCoverageEntry struct {
	Ip               []byte   `protobuf:"bytes,1,req,name=ip" json:"ip,omitempty"`
	Port             *uint32  `protobuf:"varint,2,req,name=port" json:"port,omitempty"`
	CoverContext     []byte   `protobuf:"bytes,3,req,name=cover_context" json:"cover_context,omitempty"`
	Range            *TsRange `protobuf:"bytes,4,opt,name=range" json:"range,omitempty"`
	XXX_unrecognized []byte   `json:"-"`
}

func (m *TsCoverageEntry) Reset()                    { *m = TsCoverageEntry{} }
func (m *TsCoverageEntry) String() string            { return proto.CompactTextString(m) }
func (*TsCoverageEntry) ProtoMessage()               {}
func (*TsCoverageEntry) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *TsCoverageEntry) GetIp() []byte {
	if m != nil {
		return m.Ip
	}
	return nil
}

func (m *TsCoverageEntry) GetPort() uint32 {
	if m != nil && m.Port != nil {
		return *m.Port
	}
	return 0
}

func (m *TsCoverageEntry) GetCoverContext() []byte {
	if m != nil {
		return m.CoverContext
	}
	return nil
}

func (m *TsCoverageEntry) GetRange() *TsRange {
	if m != nil {
		return m.Range
	}
	return nil
}

// Each prospective subquery has a range of valid time values
type TsRange struct {
	FieldName           []byte `protobuf:"bytes,1,req,name=field_name" json:"field_name,omitempty"`
	LowerBound          *int64 `protobuf:"zigzag64,2,req,name=lower_bound" json:"lower_bound,omitempty"`
	LowerBoundInclusive *bool  `protobuf:"varint,3,req,name=lower_bound_inclusive" json:"lower_bound_inclusive,omitempty"`
	UpperBound          *int64 `protobuf:"zigzag64,4,req,name=upper_bound" json:"upper_bound,omitempty"`
	UpperBoundInclusive *bool  `protobuf:"varint,5,req,name=upper_bound_inclusive" json:"upper_bound_inclusive,omitempty"`
	Desc                []byte `protobuf:"bytes,6,req,name=desc" json:"desc,omitempty"`
	XXX_unrecognized    []byte `json:"-"`
}

func (m *TsRange) Reset()                    { *m = TsRange{} }
func (m *TsRange) String() string            { return proto.CompactTextString(m) }
func (*TsRange) ProtoMessage()               {}
func (*TsRange) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

func (m *TsRange) GetFieldName() []byte {
	if m != nil {
		return m.FieldName
	}
	return nil
}

func (m *TsRange) GetLowerBound() int64 {
	if m != nil && m.LowerBound != nil {
		return *m.LowerBound
	}
	return 0
}

func (m *TsRange) GetLowerBoundInclusive() bool {
	if m != nil && m.LowerBoundInclusive != nil {
		return *m.LowerBoundInclusive
	}
	return false
}

func (m *TsRange) GetUpperBound() int64 {
	if m != nil && m.UpperBound != nil {
		return *m.UpperBound
	}
	return 0
}

func (m *TsRange) GetUpperBoundInclusive() bool {
	if m != nil && m.UpperBoundInclusive != nil {
		return *m.UpperBoundInclusive
	}
	return false
}

func (m *TsRange) GetDesc() []byte {
	if m != nil {
		return m.Desc
	}
	return nil
}

func init() {
	proto.RegisterType((*TsQueryReq)(nil), "TsQueryReq")
	proto.RegisterType((*TsQueryResp)(nil), "TsQueryResp")
	proto.RegisterType((*TsGetReq)(nil), "TsGetReq")
	proto.RegisterType((*TsGetResp)(nil), "TsGetResp")
	proto.RegisterType((*TsPutReq)(nil), "TsPutReq")
	proto.RegisterType((*TsPutResp)(nil), "TsPutResp")
	proto.RegisterType((*TsDelReq)(nil), "TsDelReq")
	proto.RegisterType((*TsDelResp)(nil), "TsDelResp")
	proto.RegisterType((*TsInterpolation)(nil), "TsInterpolation")
	proto.RegisterType((*TsColumnDescription)(nil), "TsColumnDescription")
	proto.RegisterType((*TsRow)(nil), "TsRow")
	proto.RegisterType((*TsCell)(nil), "TsCell")
	proto.RegisterType((*TsListKeysReq)(nil), "TsListKeysReq")
	proto.RegisterType((*TsListKeysResp)(nil), "TsListKeysResp")
	proto.RegisterType((*TsCoverageReq)(nil), "TsCoverageReq")
	proto.RegisterType((*TsCoverageResp)(nil), "TsCoverageResp")
	proto.RegisterType((*TsCoverageEntry)(nil), "TsCoverageEntry")
	proto.RegisterType((*TsRange)(nil), "TsRange")
	proto.RegisterEnum("TsColumnType", TsColumnType_name, TsColumnType_value)
}

func init() { proto.RegisterFile("riak_ts.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 768 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0xa4, 0x54, 0x51, 0x6f, 0xdb, 0x36,
	0x10, 0x9e, 0x64, 0xc9, 0x76, 0xcf, 0x52, 0xe2, 0xb1, 0xf1, 0xe2, 0x6d, 0x18, 0xaa, 0x69, 0x18,
	0x60, 0xec, 0x41, 0x03, 0xb2, 0xa0, 0x0f, 0x7d, 0xaa, 0x9d, 0x04, 0x6b, 0xb0, 0xb4, 0xf1, 0x5c,
	0xad, 0xc0, 0x50, 0x60, 0x06, 0xa5, 0x5c, 0x5a, 0xc1, 0xb4, 0xc8, 0x90, 0x94, 0x33, 0x63, 0x3f,
	0x63, 0x7f, 0x78, 0x20, 0x2d, 0x25, 0xea, 0x90, 0x87, 0x00, 0x7d, 0xa3, 0x8e, 0xbc, 0xef, 0xfb,
	0xee, 0xbb, 0x3b, 0x41, 0x28, 0x0b, 0xba, 0x5a, 0x6a, 0x95, 0x08, 0xc9, 0x35, 0xff, 0x06, 0xcc,
	0xe7, 0xee, 0x1c, 0xbf, 0x07, 0x48, 0xd5, 0xef, 0x15, 0xca, 0xed, 0x02, 0x6f, 0xc8, 0x33, 0xf0,
	0x6f, 0xcc, 0x79, 0xec, 0x44, 0xce, 0x64, 0x70, 0x34, 0x4c, 0x52, 0x75, 0x5e, 0x6a, 0x94, 0x82,
	0x33, 0xaa, 0x0b, 0x5e, 0x92, 0x11, 0x74, 0x95, 0x96, 0x48, 0xd7, 0x63, 0x37, 0x72, 0x26, 0xfd,
	0x17, 0xfe, 0x35, 0x65, 0x0a, 0xc9, 0x08, 0xc2, 0x9c, 0x6f, 0x50, 0x2e, 0x73, 0x5e, 0x6a, 0xfc,
	0x5b, 0x8f, 0x3b, 0x91, 0x33, 0x09, 0xe2, 0xbf, 0x60, 0x70, 0x07, 0xae, 0x04, 0xf9, 0x11, 0x7a,
	0x39, 0x67, 0xd5, 0xba, 0x54, 0x63, 0x27, 0xea, 0x4c, 0x06, 0x47, 0x07, 0x49, 0xaa, 0x4e, 0x6c,
	0xe4, 0x14, 0x55, 0x2e, 0x0b, 0x61, 0x39, 0x0e, 0xc0, 0x93, 0xfc, 0x56, 0x8d, 0x5d, 0xfb, 0xa6,
	0x9b, 0xa4, 0x6a, 0xc1, 0x6f, 0x09, 0x01, 0xef, 0x8a, 0x97, 0x68, 0x91, 0xfb, 0x2f, 0x3c, 0x2d,
	0x2b, 0x8c, 0x5f, 0x42, 0x3f, 0x55, 0xbf, 0xa2, 0x36, 0xd2, 0x43, 0xf0, 0x35, 0xcd, 0x18, 0x8e,
	0x9d, 0xc8, 0x9d, 0x04, 0xe4, 0x00, 0x3a, 0x2b, 0xdc, 0xd6, 0x18, 0x3d, 0xc3, 0x83, 0x8c, 0x91,
	0x7d, 0xe8, 0xe9, 0x62, 0x8d, 0xbc, 0xda, 0x29, 0x0c, 0xe3, 0x57, 0xf0, 0xa4, 0x46, 0xf8, 0x4c,
	0x7d, 0xf1, 0x3b, 0xa3, 0x65, 0x5e, 0x3d, 0xa4, 0xa5, 0x85, 0xeb, 0x3e, 0x02, 0xb7, 0xf3, 0x09,
	0xee, 0xc0, 0x28, 0xb4, 0xb8, 0x4a, 0xc4, 0x73, 0x43, 0x72, 0x8a, 0xec, 0xd1, 0x05, 0xef, 0x41,
	0x77, 0x93, 0x33, 0x9e, 0xaf, 0x76, 0x1d, 0x69, 0x1b, 0xe0, 0x59, 0x03, 0x2c, 0xbc, 0x45, 0x54,
	0x22, 0x9e, 0xc2, 0xfe, 0xff, 0x1b, 0x1e, 0x80, 0x97, 0x51, 0xd5, 0x90, 0x44, 0xb0, 0x57, 0xb4,
	0xaf, 0x9b, 0x82, 0xfa, 0xc9, 0x42, 0x64, 0x73, 0x5a, 0xc8, 0xf8, 0x25, 0x3c, 0x7d, 0xa8, 0xb6,
	0x00, 0xbc, 0x92, 0xae, 0x1b, 0x98, 0x6f, 0xc1, 0xd3, 0x5b, 0x81, 0x63, 0x37, 0x72, 0x27, 0x7b,
	0x47, 0xe1, 0x9d, 0x1b, 0xe9, 0x56, 0x60, 0xfc, 0x0c, 0xfc, 0x5d, 0xc7, 0xbf, 0x02, 0x3f, 0x47,
	0xc6, 0x9a, 0x66, 0x34, 0x35, 0xc5, 0xff, 0x40, 0xb7, 0xae, 0x6e, 0x04, 0xe1, 0x86, 0xca, 0xfc,
	0x23, 0x95, 0xcb, 0x0d, 0x65, 0x15, 0xda, 0xb1, 0x35, 0x56, 0x04, 0xaa, 0x28, 0xf5, 0xf3, 0xe3,
	0x3a, 0x6a, 0x46, 0x95, 0x90, 0x43, 0xd8, 0x37, 0xa5, 0x2b, 0x4d, 0xd7, 0xa2, 0xbe, 0xe8, 0xd8,
	0x8b, 0x11, 0x84, 0x19, 0xe7, 0x0c, 0x69, 0x59, 0x87, 0x8d, 0x33, 0x7d, 0x83, 0x72, 0xc5, 0xab,
	0x8c, 0x61, 0x1d, 0xf5, 0x23, 0x67, 0xe2, 0xc4, 0x3f, 0x43, 0x98, 0xaa, 0x8b, 0x42, 0xe9, 0xdf,
	0x70, 0xab, 0x1e, 0x68, 0x43, 0xcb, 0x60, 0xd7, 0x1a, 0x7c, 0x0c, 0x7b, 0xed, 0x04, 0x25, 0x4c,
	0x9f, 0x57, 0xb8, 0x6d, 0xca, 0x6a, 0xe6, 0x3b, 0xa8, 0xe7, 0xdb, 0xee, 0x55, 0x7c, 0x63, 0x68,
	0x4e, 0xcc, 0x4a, 0xd1, 0x0f, 0xf8, 0xa8, 0xcd, 0xbc, 0xd3, 0xe1, 0x5a, 0x1d, 0x23, 0x08, 0x25,
	0x0a, 0x46, 0x73, 0x5c, 0xda, 0xcd, 0xac, 0xfb, 0xff, 0x35, 0x7c, 0x59, 0x95, 0x74, 0x43, 0x0b,
	0x66, 0xde, 0xd6, 0x57, 0x5e, 0xd4, 0x99, 0x04, 0xf1, 0x2f, 0x46, 0xe8, 0x3d, 0xa5, 0x12, 0xe4,
	0x7b, 0xe8, 0x61, 0xa9, 0x65, 0x81, 0x8d, 0xd6, 0x61, 0x72, 0xff, 0xe2, 0xac, 0xd4, 0x72, 0x1b,
	0xbf, 0x37, 0x13, 0xf3, 0x49, 0x88, 0x00, 0xb8, 0x85, 0xa8, 0xdd, 0x08, 0xc0, 0x13, 0x5c, 0x6a,
	0xab, 0x29, 0x7c, 0xe8, 0x2f, 0x61, 0x1e, 0x1d, 0x82, 0x2f, 0x69, 0xf9, 0x61, 0xe7, 0xbb, 0x99,
	0xa5, 0x54, 0x2d, 0xcc, 0x77, 0xfc, 0xaf, 0x03, 0xbd, 0xfa, 0x4c, 0x08, 0xc0, 0x75, 0x81, 0xec,
	0x6a, 0xd9, 0x1a, 0xa3, 0xa7, 0x30, 0x60, 0xfc, 0x16, 0xe5, 0x32, 0xe3, 0x55, 0x79, 0x65, 0x49,
	0x08, 0xf9, 0x0e, 0x46, 0xad, 0xe0, 0xb2, 0x28, 0x73, 0x56, 0xa9, 0x62, 0x83, 0x96, 0xac, 0x6f,
	0x72, 0x2a, 0x21, 0xee, 0x72, 0xbc, 0x26, 0xa7, 0x15, 0x6c, 0xe5, 0xf8, 0x36, 0xc7, 0xb4, 0x06,
	0x55, 0x3e, 0xee, 0x1a, 0xd6, 0x9f, 0xfe, 0x84, 0xa0, 0x3d, 0xaf, 0x64, 0x00, 0xbd, 0x77, 0xd3,
	0xc5, 0xc9, 0xab, 0xe9, 0x62, 0xf8, 0x05, 0x01, 0xe8, 0xbe, 0x3d, 0x7f, 0x93, 0x3e, 0x3f, 0x1e,
	0x3a, 0xe6, 0x7c, 0x7a, 0xf9, 0xc7, 0xec, 0xe2, 0x6c, 0xe8, 0x92, 0x10, 0x9e, 0xa4, 0xe7, 0xaf,
	0xcf, 0xde, 0xa6, 0xd3, 0xd7, 0xf3, 0x61, 0xc7, 0xe4, 0xcc, 0x2e, 0x2f, 0x2f, 0xce, 0xa6, 0x6f,
	0x86, 0x1e, 0xe9, 0x83, 0x37, 0xbb, 0xb8, 0x9c, 0x0d, 0xfd, 0xd9, 0x0f, 0x70, 0x98, 0xf3, 0x75,
	0x92, 0x51, 0xf5, 0x91, 0x27, 0xf7, 0x3f, 0xe9, 0xac, 0xba, 0x9e, 0xf5, 0x17, 0x05, 0x5d, 0xa5,
	0x6a, 0x3e, 0xfb, 0x2f, 0x00, 0x00, 0xff, 0xff, 0x77, 0xff, 0x56, 0x9d, 0xcd, 0x05, 0x00, 0x00,
}
